/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.HttpStatusCode;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class HttpStatusCodeTest {
    @Test
    public void isValidStatusCode_invalidCode_returnsFalse() {
        Set validCodes = Stream.of(HttpStatusCode.values()).map(HttpStatusCode::getCode).collect(Collectors.toSet());
        IntStream.rangeClosed(-1000, 1000).filter(sc -> !validCodes.contains(sc)).forEach(sc -> Assert.assertFalse((String)(sc + " should be invalid, but was not"), (boolean)HttpStatusCode.isValidStatusCode((int)sc)));
    }

    @Test
    public void isValidStatusCode_validCode_returnsTrue() {
        Stream.of(HttpStatusCode.values()).mapToInt(HttpStatusCode::getCode).forEach(sc -> Assert.assertTrue((String)(sc + " should be valid, but was not"), (boolean)HttpStatusCode.isValidStatusCode((int)sc)));
    }
}

