/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JacksonUtils;
import org.junit.Assert;
import org.junit.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class ConstantPoolTest {
    private ConstantPool constantPool = new ConstantPool();

    @Test
    public void newConstantPool_noNewItems() {
        Assert.assertFalse((boolean)this.constantPool.hasNewConstants());
        Assert.assertEquals((long)0L, (long)JacksonUtils.getKeys((JsonNode)this.constantPool.dumpConstants()).size());
    }

    @Test
    public void valueIsRegistered() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        Assert.assertTrue((boolean)this.constantPool.hasNewConstants());
        ObjectNode dump = this.constantPool.dumpConstants();
        Assert.assertEquals((long)1L, (long)JacksonUtils.getKeys((JsonNode)dump).size());
        Assert.assertEquals((Object)"{}", (Object)dump.get(constantId).toString());
    }

    @Test
    public void sameValue_sameId() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        this.constantPool.dumpConstants();
        String otherId = this.constantPool.getConstantId(new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode()));
        Assert.assertEquals((Object)constantId, (Object)otherId);
        Assert.assertFalse((boolean)this.constantPool.hasNewConstants());
    }

    @Test
    public void differentValue_differentId() {
        ConstantPoolKey reference = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        String constantId = this.constantPool.getConstantId(reference);
        this.constantPool.dumpConstants();
        String otherId = this.constantPool.getConstantId(new ConstantPoolKey((JsonNode)JacksonUtils.createArrayNode()));
        Assert.assertNotEquals((Object)constantId, (Object)otherId);
        Assert.assertTrue((boolean)this.constantPool.hasNewConstants());
    }

    @Test
    public void constantPoolKey_exportedDirectly_idCreated() {
        ConstantPoolKey constantPoolKey = new ConstantPoolKey((JsonNode)JacksonUtils.createObjectNode());
        ObjectNode message = JacksonUtils.createObjectNode();
        constantPoolKey.export(message);
        Assert.assertTrue((boolean)message.has(constantPoolKey.getId()));
    }
}

