/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.BrowserWindowResizeListener;
import com.vaadin.flow.component.page.ColorScheme;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.shared.ui.Dependency;
import com.vaadin.flow.shared.ui.LoadMode;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import tools.jackson.databind.JsonNode;

public class PageTest {
    private UI ui = new TestUI();
    private TestPage page = new TestPage(this.ui);
    private BrowserWindowResizeListener listener = (BrowserWindowResizeListener & Serializable)event -> {};

    @Test(expected=NullPointerException.class)
    public void addNullAsAListener_trows() {
        this.page.addBrowserWindowResizeListener(null);
    }

    @Test
    public void retrieveExtendedClientDetails_twice_jsOnceAndCallbackTwice() {
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... params) {
                super.executeJs(expression, params);
                return new PendingJavaScriptResult(){

                    public boolean cancelExecution() {
                        return false;
                    }

                    public boolean isSentToBrowser() {
                        return false;
                    }

                    public void then(SerializableConsumer<JsonNode> resultHandler, SerializableConsumer<String> errorHandler) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("v-sw", "2560");
                        params.put("v-sh", "1450");
                        params.put("v-tzo", "-270");
                        params.put("v-rtzo", "-210");
                        params.put("v-dstd", "60");
                        params.put("v-dston", "true");
                        params.put("v-tzid", "Asia/Tehran");
                        params.put("v-curdate", "1555000000000");
                        params.put("v-td", "false");
                        params.put("v-wn", "ROOT-1234567-0.1234567");
                        resultHandler.accept((Object)JacksonUtils.createObject(params, JacksonUtils::createNode));
                    }
                };
            }
        };
        mockUI.setPage(page);
        AtomicInteger callbackInvocations = new AtomicInteger();
        Page.ExtendedClientDetailsReceiver & Serializable receiver = (Page.ExtendedClientDetailsReceiver & Serializable)details -> callbackInvocations.incrementAndGet();
        page.retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver)receiver);
        page.retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver)receiver);
        int jsInvocations = mockUI.getInternals().dumpPendingJavaScriptInvocations().size();
        Assert.assertEquals((long)1L, (long)jsInvocations);
        Assert.assertEquals((long)2L, (long)callbackInvocations.get());
    }

    @Test
    public void fetchCurrentUrl_consumerReceivesCorrectURL() {
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... params) {
                super.executeJs(expression, params);
                Assert.assertEquals((String)"Expected javascript for fetching location is wrong.", (Object)"return window.location.href", (Object)expression);
                return new PendingJavaScriptResult(){

                    public boolean cancelExecution() {
                        return false;
                    }

                    public boolean isSentToBrowser() {
                        return false;
                    }

                    public void then(SerializableConsumer<JsonNode> resultHandler, SerializableConsumer<String> errorHandler) {
                        resultHandler.accept((Object)JacksonUtils.createNode((Object)"http://localhost:8080/home"));
                    }
                };
            }
        };
        AtomicReference callbackInvocations = new AtomicReference();
        SerializableConsumer & Serializable receiver = (SerializableConsumer & Serializable)details -> callbackInvocations.compareAndSet(null, details);
        page.fetchCurrentURL((SerializableConsumer)receiver);
        Assert.assertEquals((String)"Returned URL was wrong", (Object)"http://localhost:8080/home", (Object)((URL)callbackInvocations.get()).toString());
    }

    @Test
    public void fetchCurrentUrl_passNullCallback_throwsNullPointerException() {
        Assert.assertThrows(NullPointerException.class, () -> {
            MockUI mockUI = new MockUI();
            Page page = new Page((UI)mockUI);
            page.fetchCurrentURL(null);
        });
    }

    @Test
    public void addJsModule_accepts_onlyExternalAndStartingSlash() {
        LinkedList<String> urls = new LinkedList<String>();
        urls.add("http://sample.com/mod.js");
        urls.add("https://sample.com/mod.js");
        urls.add("//sample.com/mod.js");
        urls.add("/mod.js");
        for (String url : urls) {
            this.page.addJsModule(url);
        }
        Collection pendingSendToClient = this.ui.getInternals().getDependencyList().getPendingSendToClient();
        Assert.assertEquals((String)"There should be 4 dependencies added.", (long)4L, (long)pendingSendToClient.size());
        for (Dependency dependency : pendingSendToClient) {
            Assert.assertEquals((String)"Dependency should be a JSModule", (Object)Dependency.Type.JS_MODULE, (Object)dependency.getType());
            Assert.assertEquals((String)"JS module dependency should be EAGER", (Object)LoadMode.EAGER, (Object)dependency.getLoadMode());
            Assert.assertTrue((String)("Dependency " + dependency.getUrl() + " is not found in the source list."), (boolean)urls.contains(dependency.getUrl()));
            urls.remove(dependency.getUrl());
        }
        Assert.assertEquals((String)"Not all urls were added as dependencies", (long)0L, (long)urls.size());
    }

    @Test
    public void addJsModule_rejects_files() {
        try {
            this.page.addJsModule("mod.js");
            Assert.fail((String)"Adding a file without starting \"/\" is not to be allowed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void executeJavaScript_delegatesToExecJs() {
        final AtomicReference invokedExpression = new AtomicReference();
        final AtomicReference invokedParams = new AtomicReference();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                String oldExpression = invokedExpression.getAndSet(expression);
                Assert.assertNull((String)"There should be no old expression", (Object)oldExpression);
                Object[] oldParams = invokedParams.getAndSet(parameters);
                Assert.assertNull((String)"There should be no old params", (Object)oldParams);
                return null;
            }
        };
        PendingJavaScriptResult executionCanceler = page.executeJs("foo", new Object[]{1, true});
        Assert.assertNull((Object)executionCanceler);
        Assert.assertEquals((Object)"foo", invokedExpression.get());
        Assert.assertEquals((Object)1, (Object)((Object[])invokedParams.get())[0]);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((Object[])invokedParams.get())[1]);
    }

    @Test
    public void open_openInSameWindow_closeTheClientApplication() {
        final AtomicReference capture = new AtomicReference();
        final ArrayList params = new ArrayList();
        Page page = new Page(new MockUI()){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capture.set(expression);
                params.addAll(Arrays.asList(parameters));
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setLocation("foo");
        Assert.assertEquals((Object)"_self", params.get(1));
        MatcherAssert.assertThat((Object)((String)capture.get()), (Matcher)CoreMatchers.startsWith((String)"if ($1 == '_self') this.stopApplication();"));
    }

    @Test
    public void setColorScheme_setsStyleProperty() {
        final AtomicReference capturedExpression = new AtomicReference();
        final AtomicReference capturedParams = new AtomicReference();
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                capturedParams.set(parameters);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.DARK);
        String js = (String)capturedExpression.get();
        Assert.assertTrue((String)"Should set theme attribute", (boolean)js.contains("setAttribute('theme', $0)"));
        Assert.assertTrue((String)"Should set color-scheme property", (boolean)js.contains("style.colorScheme = $1"));
        Object[] params = (Object[])capturedParams.get();
        Assert.assertEquals((String)"Theme attribute should be 'dark'", (Object)"dark", (Object)params[0]);
        Assert.assertEquals((String)"Color scheme property should be 'dark'", (Object)"dark", (Object)params[1]);
    }

    @Test
    public void setColorScheme_lightDark_setsCorrectValues() {
        final AtomicReference capturedExpression = new AtomicReference();
        final AtomicReference capturedParams = new AtomicReference();
        MockUI mockUI = new MockUI();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                capturedParams.set(parameters);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.LIGHT_DARK);
        String js = (String)capturedExpression.get();
        Assert.assertTrue((String)"Should set theme attribute", (boolean)js.contains("setAttribute('theme', $0)"));
        Assert.assertTrue((String)"Should set color-scheme property", (boolean)js.contains("style.colorScheme = $1"));
        Object[] params = (Object[])capturedParams.get();
        Assert.assertEquals((String)"Theme attribute should use hyphen", (Object)"light-dark", (Object)params[0]);
        Assert.assertEquals((String)"Color scheme property should use space", (Object)"light dark", (Object)params[1]);
    }

    @Test
    public void setColorScheme_null_clearsProperty() {
        MockUI mockUI = new MockUI();
        final AtomicReference capturedExpression = new AtomicReference();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(null);
        String js = (String)capturedExpression.get();
        Assert.assertTrue((String)"Should remove theme attribute", (boolean)js.contains("removeAttribute('theme')"));
        Assert.assertTrue((String)"Should clear inline style", (boolean)js.contains("style.colorScheme = ''"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void setColorScheme_normal_clearsProperty() {
        MockUI mockUI = new MockUI();
        final AtomicReference capturedExpression = new AtomicReference();
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                capturedExpression.set(expression);
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        page.setColorScheme(ColorScheme.Value.NORMAL);
        String js = (String)capturedExpression.get();
        Assert.assertTrue((boolean)js.contains("style.colorScheme = ''"));
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void getColorScheme_returnsNormal_whenNotSet() {
        Page page = new Page((UI)new MockUI());
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    @Test
    public void getColorScheme_returnsCachedValue() {
        MockUI mockUI = new MockUI();
        ExtendedClientDetails details = new ExtendedClientDetails((UI)mockUI, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "dark", null);
        mockUI.getInternals().setExtendedClientDetails(details);
        Page page = new Page((UI)mockUI);
        Assert.assertEquals((Object)ColorScheme.Value.DARK, (Object)page.getColorScheme());
    }

    @Test
    public void setColorScheme_updatesGetColorScheme() {
        MockUI mockUI = new MockUI();
        ExtendedClientDetails details = new ExtendedClientDetails((UI)mockUI, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        mockUI.getInternals().setExtendedClientDetails(details);
        Page page = new Page(mockUI){

            public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
                return (PendingJavaScriptResult)Mockito.mock(PendingJavaScriptResult.class);
            }
        };
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.DARK);
        Assert.assertEquals((Object)ColorScheme.Value.DARK, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.LIGHT);
        Assert.assertEquals((Object)ColorScheme.Value.LIGHT, (Object)page.getColorScheme());
        page.setColorScheme(null);
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
        page.setColorScheme(ColorScheme.Value.NORMAL);
        Assert.assertEquals((Object)ColorScheme.Value.NORMAL, (Object)page.getColorScheme());
    }

    private class TestUI
    extends UI {
        private TestUI() {
        }

        public Page getPage() {
            return PageTest.this.page;
        }
    }

    private class TestPage
    extends Page {
        private int count;
        private String expression;
        private Object firstParam;

        public TestPage(UI ui) {
            super(ui);
            this.count = 0;
        }

        public PendingJavaScriptResult executeJs(String expression, Object ... parameters) {
            this.expression = expression;
            this.firstParam = parameters[0];
            ++this.count;
            return null;
        }
    }
}

