/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HeartbeatListener;
import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.component.page.Push;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.shared.communication.PushMode;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class UIInternalsTest {
    @Mock
    UI ui;
    MockVaadinServletService vaadinService;
    UIInternals internals;

    @Before
    public void init() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.ui.getUI()).thenReturn(Optional.of(this.ui));
        Element body = new Element("body");
        Mockito.when((Object)this.ui.getElement()).thenReturn((Object)body);
        this.vaadinService = new MockVaadinServletService();
        this.internals = new UIInternals(this.ui);
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)config);
        AlwaysLockedVaadinSession session = new AlwaysLockedVaadinSession((VaadinService)this.vaadinService);
        this.internals.setSession((VaadinSession)session);
        Mockito.when((Object)this.ui.getSession()).thenReturn((Object)session);
        Mockito.when((Object)this.ui.getInternals()).thenReturn((Object)this.internals);
    }

    @Test
    public void heartbeatTimestampSet_heartbeatListenersAreCalled() {
        ArrayList heartbeats = new ArrayList();
        Registration registration = this.internals.addHeartbeatListener((HeartbeatListener & Serializable)event -> heartbeats.add(event.getHeartbeatTime()));
        this.internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assert.assertEquals((String)"Heartbeat listener should have fired", (long)1L, (long)heartbeats.size());
        registration.remove();
        this.internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assert.assertEquals((String)"Heartbeat listener should been removed and no new event recorded", (long)1L, (long)heartbeats.size());
    }

    @Test
    public void heartbeatListenerRemovedFromHeartbeatEvent_noExplosion() {
        AtomicReference<Registration> reference = new AtomicReference<Registration>();
        AtomicInteger runCount = new AtomicInteger();
        Registration registration = this.internals.addHeartbeatListener((HeartbeatListener & Serializable)event -> {
            runCount.incrementAndGet();
            ((Registration)reference.get()).remove();
        });
        reference.set(registration);
        this.internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assert.assertEquals((String)"Listener should have been run once", (long)1L, (long)runCount.get());
        this.internals.setLastHeartbeatTimestamp(System.currentTimeMillis());
        Assert.assertEquals((String)"Listener should not have been run again since it was removed", (long)1L, (long)runCount.get());
    }

    @Test
    public void showRouteTarget_clientSideBootstrap() {
        PushConfiguration pushConfig = this.setUpInitialPush();
        this.internals.showRouteTarget((Location)Mockito.mock(Location.class), (Component)new RouteTarget(), Collections.emptyList());
        ((PushConfiguration)Mockito.verify((Object)pushConfig, (VerificationMode)Mockito.never())).setPushMode((PushMode)Mockito.any());
    }

    @Test
    public void showRouteTarget_navigateToAnotherViewWithinSameLayoutHierarchy_detachedRouterLayoutChildrenRemoved() {
        MainLayout mainLayout = new MainLayout();
        SubLayout subLayout = new SubLayout();
        FirstView firstView = new FirstView();
        AnotherView anotherView = new AnotherView();
        List<RouterLayout> oldLayouts = Arrays.asList(new RouterLayout[]{subLayout, mainLayout});
        List<MainLayout> newLayouts = Collections.singletonList(mainLayout);
        Location location = (Location)Mockito.mock(Location.class);
        this.setUpInitialPush();
        this.internals.showRouteTarget(location, (Component)firstView, oldLayouts);
        List activeRouterTargetsChain = this.internals.getActiveRouterTargetsChain();
        Assert.assertArrayEquals((String)"Unexpected initial router targets chain", (Object[])new HasElement[]{firstView, subLayout, mainLayout}, (Object[])activeRouterTargetsChain.toArray());
        Assert.assertEquals((String)"Expected one child element for main layout before navigation", (long)1L, (long)mainLayout.getElement().getChildren().count());
        Element subLayoutElement = (Element)mainLayout.getElement().getChildren().findFirst().get();
        Assert.assertEquals((String)"Unexpected sub layout element", (Object)SubLayout.ID, (Object)subLayoutElement.getAttribute("id"));
        Assert.assertEquals((String)"Expected one child element for sub layout before navigation", (long)1L, (long)subLayoutElement.getChildren().count());
        Element firstViewElement = (Element)subLayoutElement.getChildren().findFirst().get();
        Assert.assertEquals((String)"Unexpected first view element", (Object)FirstView.ID, (Object)firstViewElement.getAttribute("id"));
        this.internals.showRouteTarget(location, (Component)anotherView, newLayouts);
        activeRouterTargetsChain = this.internals.getActiveRouterTargetsChain();
        Assert.assertArrayEquals((String)"Unexpected router targets chain after navigation", (Object[])new HasElement[]{anotherView, mainLayout}, (Object[])activeRouterTargetsChain.toArray());
        Assert.assertEquals((String)"Expected one child element for main layout after navigation", (long)1L, (long)mainLayout.getElement().getChildren().count());
        Element anotherViewElement = (Element)mainLayout.getElement().getChildren().findFirst().get();
        Assert.assertEquals((String)"Unexpected another view element", (Object)AnotherView.ID, (Object)anotherViewElement.getAttribute("id"));
        Assert.assertEquals((String)"Expected no child elements for sub layout after navigation", (long)0L, (long)subLayout.getElement().getChildren().count());
    }

    @Test
    public void showRouteTarget_navigateToAnotherLayoutHierarchy_detachedLayoutHierarchyChildrenRemoved() {
        MainLayout mainLayout = new MainLayout();
        SubLayout subLayout = new SubLayout();
        FirstView firstView = new FirstView();
        AnotherLayout anotherLayout = new AnotherLayout();
        AnotherView anotherView = new AnotherView();
        List<RouterLayout> oldLayouts = Arrays.asList(new RouterLayout[]{subLayout, mainLayout});
        List<AnotherLayout> newLayouts = Collections.singletonList(anotherLayout);
        Location location = (Location)Mockito.mock(Location.class);
        this.setUpInitialPush();
        this.internals.showRouteTarget(location, (Component)firstView, oldLayouts);
        this.internals.showRouteTarget(location, (Component)anotherView, newLayouts);
        List activeRouterTargetsChain = this.internals.getActiveRouterTargetsChain();
        Assert.assertArrayEquals((String)"Unexpected router targets chain after navigation", (Object[])new HasElement[]{anotherView, anotherLayout}, (Object[])activeRouterTargetsChain.toArray());
        Assert.assertEquals((String)"Expected no child elements for main layout after navigation", (long)0L, (long)mainLayout.getElement().getChildren().count());
        Assert.assertEquals((String)"Expected no child elements for sub layout after navigation", (long)0L, (long)subLayout.getElement().getChildren().count());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_detachListenerRegisteredOnce() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0])));
        this.internals.dumpPendingJavaScriptInvocations();
        this.internals.dumpPendingJavaScriptInvocations();
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_multipleInvocationPerNode_onlyOneDetachListenerRegistered() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("1", new Object[0])));
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("2", new Object[0])));
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("3", new Object[0])));
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_registerOneDetachListenerPerNode() {
        StateNode node1 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node1.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node1);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node1, new UIInternals.JavaScriptInvocation("1", new Object[0])));
        StateNode node2 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node2.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node2);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node2, new UIInternals.JavaScriptInvocation("1", new Object[0])));
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node1, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        ((StateNode)Mockito.verify((Object)node2, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_invocationCompletes_pendingListPurged() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        PendingJavaScriptInvocation invocation = new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0]));
        this.internals.addJavaScriptInvocation(invocation);
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        invocation.complete(JacksonCodec.encodeWithTypeInfo((Object)"OK"));
        Assert.assertEquals((long)0L, (long)this.internals.getPendingJavaScriptInvocations().count());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_invocationFails_pendingListPurged() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        PendingJavaScriptInvocation invocation = new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0]));
        this.internals.addJavaScriptInvocation(invocation);
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        invocation.completeExceptionally(JacksonCodec.encodeWithTypeInfo((Object)"ERROR"));
        Assert.assertEquals((long)0L, (long)this.internals.getPendingJavaScriptInvocations().count());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_invocationCanceled_pendingListPurged() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        PendingJavaScriptInvocation invocation = new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0]));
        this.internals.addJavaScriptInvocation(invocation);
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        invocation.cancelExecution();
        Assert.assertEquals((long)0L, (long)this.internals.getPendingJavaScriptInvocations().count());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_nodeDetached_pendingListPurged() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        PendingJavaScriptInvocation invocation = new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0]));
        this.internals.addJavaScriptInvocation(invocation);
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        node.setParent(null);
        Assert.assertEquals((long)0L, (long)this.internals.getPendingJavaScriptInvocations().count());
    }

    @Test
    public void dumpPendingJavaScriptInvocations_multipleInvocation_detachListenerRegisteredOnce() {
        StateNode node = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node.getFeature(ElementData.class)).setVisible(false);
        ((ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class)).add(0, node);
        PendingJavaScriptInvocation invocation = (PendingJavaScriptInvocation)Mockito.spy((Object)new PendingJavaScriptInvocation(node, new UIInternals.JavaScriptInvocation("", new Object[0])));
        this.internals.addJavaScriptInvocation(invocation);
        this.internals.dumpPendingJavaScriptInvocations();
        this.internals.dumpPendingJavaScriptInvocations();
        this.internals.dumpPendingJavaScriptInvocations();
        this.internals.dumpPendingJavaScriptInvocations();
        ((StateNode)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).addDetachListener((Command)ArgumentMatchers.any());
        ((PendingJavaScriptInvocation)Mockito.verify((Object)invocation, (VerificationMode)Mockito.times((int)1))).then((SerializableConsumer)ArgumentMatchers.any(SerializableConsumer.class), (SerializableConsumer)ArgumentMatchers.any(SerializableConsumer.class));
        node.setParent(null);
        Assert.assertEquals((long)0L, (long)this.internals.getPendingJavaScriptInvocations().count());
    }

    @Test
    public void isDirty_noPendingJsInvocation_returnsFalse() {
        StateNode node1 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        StateNode node2 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node2.getFeature(ElementData.class)).setVisible(false);
        ElementChildrenList childrenList = (ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class);
        childrenList.add(0, node1);
        childrenList.add(1, node2);
        Assert.assertTrue((String)"Nodes added, expecting dirty UI", (boolean)this.internals.isDirty());
        this.internals.getStateTree().collectChanges(node -> {});
        this.internals.dumpPendingJavaScriptInvocations();
        Assert.assertFalse((String)"Changes collected, expecting UI not to be dirty", (boolean)this.internals.isDirty());
    }

    @Test
    public void isDirty_pendingJsInvocationReadyToSend_returnsTrue() {
        StateNode node1 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        StateNode node2 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node2.getFeature(ElementData.class)).setVisible(false);
        ElementChildrenList childrenList = (ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class);
        childrenList.add(0, node1);
        childrenList.add(1, node2);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node1, new UIInternals.JavaScriptInvocation("", new Object[0])));
        Assert.assertTrue((String)"Pending JS invocations, expecting dirty UI", (boolean)this.internals.isDirty());
        this.internals.getStateTree().collectChanges(node -> {});
        this.internals.dumpPendingJavaScriptInvocations();
        Assert.assertFalse((String)"No pending JS invocations to send to the client, expecting UI not to be dirty", (boolean)this.internals.isDirty());
    }

    @Test
    public void isDirty_pendingJsInvocationNotReadyToSend_returnsFalse() {
        StateNode node1 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        StateNode node2 = (StateNode)Mockito.spy((Object)new StateNode(new Class[]{ElementData.class}));
        ((ElementData)node2.getFeature(ElementData.class)).setVisible(false);
        ElementChildrenList childrenList = (ElementChildrenList)this.internals.getStateTree().getRootNode().getFeature(ElementChildrenList.class);
        childrenList.add(0, node1);
        childrenList.add(1, node2);
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node1, new UIInternals.JavaScriptInvocation("", new Object[0])));
        this.internals.addJavaScriptInvocation(new PendingJavaScriptInvocation(node2, new UIInternals.JavaScriptInvocation("", new Object[0])));
        Assert.assertTrue((String)"Pending JS invocations, expecting dirty UI", (boolean)this.internals.isDirty());
        this.internals.getStateTree().collectChanges(node -> {});
        this.internals.dumpPendingJavaScriptInvocations();
        Assert.assertFalse((String)"No pending JS invocations to send to the client, expecting UI not to be dirty", (boolean)this.internals.isDirty());
    }

    @Test
    public void setTitle_titleAndPendingJsInvocationSetsCorrectTitle() {
        this.internals.setTitle("new title");
        Assert.assertEquals((Object)"new title", (Object)this.internals.getTitle());
        Assert.assertEquals((String)"one pending JavaScript invocation should exist", (long)1L, (long)this.internals.getPendingJavaScriptInvocations().count());
        PendingJavaScriptInvocation pendingJavaScriptInvocation = this.internals.getPendingJavaScriptInvocations().findFirst().orElse(null);
        Assert.assertNotNull((String)"pendingJavaScriptInvocation should not be null", (Object)pendingJavaScriptInvocation);
        Assert.assertEquals((Object)"new title", pendingJavaScriptInvocation.getInvocation().getParameters().get(0));
        Assert.assertTrue((String)"document.title should be set via JavaScript", (boolean)pendingJavaScriptInvocation.getInvocation().getExpression().contains("document.title = $0"));
        Assert.assertTrue((String)"window.Vaadin.documentTitleSignal.value should be set conditionally via JavaScript", (boolean)pendingJavaScriptInvocation.getInvocation().getExpression().contains("    if(window?.Vaadin?.documentTitleSignal) {\n        window.Vaadin.documentTitleSignal.value = $0;\n    }\n".stripIndent()));
    }

    private PushConfiguration setUpInitialPush() {
        DeploymentConfiguration config = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        this.vaadinService.setConfiguration(config);
        PushConfiguration pushConfig = (PushConfiguration)Mockito.mock(PushConfiguration.class);
        Mockito.when((Object)this.ui.getPushConfiguration()).thenReturn((Object)pushConfig);
        Mockito.when((Object)config.getPushMode()).thenReturn((Object)PushMode.DISABLED);
        return pushConfig;
    }

    @Test
    public void getDeploymentConfiguration() {
        AlwaysLockedVaadinSession session = (AlwaysLockedVaadinSession)((Object)Mockito.mock(AlwaysLockedVaadinSession.class));
        MockVaadinServletService mockVaadinServletService = (MockVaadinServletService)((Object)Mockito.mock(MockVaadinServletService.class));
        this.internals = new UIInternals(this.ui);
        this.internals.setSession((VaadinSession)session);
        Mockito.when((Object)session.getService()).thenReturn((Object)mockVaadinServletService);
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        Mockito.when((Object)mockVaadinServletService.getDeploymentConfiguration()).thenReturn((Object)config);
        DeploymentConfiguration result = this.internals.getDeploymentConfiguration();
        ((AlwaysLockedVaadinSession)((Object)Mockito.verify((Object)((Object)session)))).getService();
        ((MockVaadinServletService)((Object)Mockito.verify((Object)((Object)mockVaadinServletService)))).getDeploymentConfiguration();
        Assert.assertEquals((Object)((Object)config), (Object)result);
    }

    @Route
    @Push
    @Tag(value="div")
    public static class RouteTarget
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    static class MainLayout
    extends Component
    implements RouterLayout {
        static String ID = "main-layout-id";

        public MainLayout() {
            this.setId(ID);
        }
    }

    @Tag(value="div")
    @ParentLayout(value=MainLayout.class)
    static class SubLayout
    extends Component
    implements RouterLayout {
        static String ID = "sub-layout-id";

        public SubLayout() {
            this.setId(ID);
        }
    }

    @Tag(value="div")
    @Route(value="child", layout=SubLayout.class)
    static class FirstView
    extends Component {
        static String ID = "child-view-id";

        public FirstView() {
            this.setId(ID);
        }
    }

    @Tag(value="div")
    @Route(value="another", layout=MainLayout.class)
    static class AnotherView
    extends Component {
        static String ID = "another-view-id";

        public AnotherView() {
            this.setId(ID);
        }
    }

    @Tag(value="div")
    static class AnotherLayout
    extends Component
    implements RouterLayout {
        static String ID = "another-layout-id";

        public AnotherLayout() {
            this.setId(ID);
        }
    }

    @Route(value="foo", layout=RouteTarget.class)
    @Tag(value="div")
    public static class RouteTarget1
    extends Component {
    }
}

