/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.SignalPropertySupport;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import com.vaadin.signals.ValueSignal;
import com.vaadin.tests.util.MockUI;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class SignalPropertySupportTest {
    private static MockVaadinServletService service;
    private MockedStatic<FeatureFlags> featureFlagStaticMock;
    private LinkedList<ErrorEvent> events;
    private AtomicInteger callCount;
    private AtomicReference<Object> lastValue;

    @BeforeClass
    public static void init() {
        MockedStatic featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        SignalPropertySupportTest.featureFlagEnabled((MockedStatic<FeatureFlags>)featureFlagStaticMock);
        service = new MockVaadinServletService();
        SignalPropertySupportTest.close((MockedStatic<FeatureFlags>)featureFlagStaticMock);
    }

    @AfterClass
    public static void clean() {
        CurrentInstance.clearAll();
        service.destroy();
    }

    @Before
    public void before() {
        this.featureFlagStaticMock = Mockito.mockStatic(FeatureFlags.class);
        SignalPropertySupportTest.featureFlagEnabled(this.featureFlagStaticMock);
        this.events = this.mockLockedSessionWithErrorHandler();
        this.callCount = new AtomicInteger(0);
        this.lastValue = new AtomicReference();
    }

    @After
    public void after() {
        Assert.assertTrue((boolean)this.events.isEmpty());
        SignalPropertySupportTest.close(this.featureFlagStaticMock);
        this.events = null;
    }

    private static void featureFlagEnabled(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        FeatureFlags flags = (FeatureFlags)Mockito.mock(FeatureFlags.class);
        Mockito.when((Object)flags.isEnabled(FeatureFlags.FLOW_FULLSTACK_SIGNALS.getId())).thenReturn((Object)true);
        featureFlagStaticMock.when(() -> FeatureFlags.get((VaadinContext)((VaadinContext)ArgumentMatchers.any()))).thenReturn((Object)flags);
    }

    private static void close(MockedStatic<FeatureFlags> featureFlagStaticMock) {
        CurrentInstance.clearAll();
        featureFlagStaticMock.close();
    }

    private LinkedList<ErrorEvent> mockLockedSessionWithErrorHandler() {
        VaadinService.setCurrent((VaadinService)service);
        MockVaadinSession session = new MockVaadinSession((VaadinService)service);
        session.lock();
        MockUI ui = new MockUI(session);
        LinkedList<ErrorEvent> events = new LinkedList<ErrorEvent>();
        session.setErrorHandler(events::add);
        return events;
    }

    @Test
    public void create_nullArguments_throwException() {
        Assert.assertThrows(NullPointerException.class, () -> SignalPropertySupport.create(null, (SerializableConsumer & Serializable)value -> {}));
        Assert.assertThrows(NullPointerException.class, () -> SignalPropertySupport.create((Component)new TestComponent(), null));
    }

    @Test
    public void get_notBound_nullValue() {
        TestComponent component = new TestComponent();
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {});
        Assert.assertNull((Object)signalPropertySupport.get());
    }

    @Test
    public void get_boundButNotAttached_valueNotSetInitially() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"foo");
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> this.callCount.incrementAndGet());
        signalPropertySupport.bind((Signal)signal);
        Assert.assertNull((Object)signalPropertySupport.get());
        Assert.assertEquals((long)0L, (long)this.callCount.get());
    }

    @Test
    public void get_boundAndAttached_valueSet() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)"foo");
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {
            this.callCount.incrementAndGet();
            this.lastValue.set(value);
        });
        signalPropertySupport.bind((Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"foo", (Object)this.lastValue.get());
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"bar", (Object)this.lastValue.get());
        Assert.assertEquals((long)2L, (long)this.callCount.get());
    }

    @Test
    public void set_notBound_valueSet() {
        TestComponent component = new TestComponent();
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {
            this.callCount.incrementAndGet();
            this.lastValue.set(value);
        });
        signalPropertySupport.set((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"foo", (Object)this.lastValue.get());
        signalPropertySupport.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"bar", (Object)this.lastValue.get());
        Assert.assertEquals((long)2L, (long)this.callCount.get());
    }

    @Test
    public void set_alreadyBound_throwException() {
        TestComponent component = new TestComponent();
        ValueSignal signal = new ValueSignal((Object)"foo");
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> this.callCount.incrementAndGet());
        signalPropertySupport.bind((Signal)signal);
        Assert.assertThrows(BindingActiveException.class, () -> signalPropertySupport.set((Object)"bar"));
        Assert.assertEquals((long)0L, (long)this.callCount.get());
    }

    @Test
    public void set_computedSignal_valueSet() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, this.lastValue::set);
        ValueSignal signal = new ValueSignal((Object)"foo");
        signalPropertySupport.bind(Signal.computed(() -> "computed-" + (String)signal.value()));
        Assert.assertEquals((Object)"computed-foo", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"computed-foo", (Object)this.lastValue.get());
    }

    @Test
    public void set_mappedSignal_valueSet() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, this.lastValue::set);
        ValueSignal signal = new ValueSignal((Object)"foo");
        signalPropertySupport.bind(signal.map(value -> "mapped-" + value));
        Assert.assertEquals((Object)"mapped-foo", (Object)signalPropertySupport.get());
        Assert.assertEquals((Object)"mapped-foo", (Object)this.lastValue.get());
    }

    @Test
    public void bind_nullWithNotYetBound_noEffect() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {});
        signalPropertySupport.bind(null);
        Assert.assertNull((Object)signalPropertySupport.get());
    }

    @Test
    public void bind_nullWithAlreadyBound_removeBinding() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {});
        ValueSignal signal = new ValueSignal((Object)"foo");
        signalPropertySupport.bind((Signal)new ValueSignal((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
        signalPropertySupport.bind(null);
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
    }

    @Test
    public void bind_alreadyBound_throw() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {});
        signalPropertySupport.bind((Signal)new ValueSignal((Object)"foo"));
        Assert.assertThrows(BindingActiveException.class, () -> signalPropertySupport.bind((Signal)new ValueSignal((Object)"foo")));
    }

    @Test
    public void bind_boundDetachedAttached_bindingRemovedAndAddedBack() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        SignalPropertySupport signalPropertySupport = SignalPropertySupport.create((Component)component, (SerializableConsumer & Serializable)value -> {});
        ValueSignal signal = new ValueSignal((Object)"foo");
        signalPropertySupport.bind((Signal)signal);
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
        component.removeFromParent();
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)signalPropertySupport.get());
        UI.getCurrent().add(new Component[]{component});
        Assert.assertEquals((Object)"bar", (Object)signalPropertySupport.get());
    }

    @Tag(value="div")
    private static class TestComponent
    extends Component {
        private TestComponent() {
        }
    }
}

