/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Unit;
import org.junit.Assert;
import org.junit.Test;

public class HasSizeTest {
    @Test
    public void setWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getWidth());
    }

    @Test
    public void setMinWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMinWidth());
    }

    @Test
    public void setMaxWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMaxWidth());
    }

    @Test
    public void removeWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getWidth());
        c.setWidth(null);
        Assert.assertNull((Object)c.getWidth());
    }

    @Test
    public void removeMinWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMinWidth());
        c.setMinWidth(null);
        Assert.assertNull((Object)c.getMinWidth());
    }

    @Test
    public void removeMaxWidth() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxWidth("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMaxWidth());
        c.setMaxWidth(null);
        Assert.assertNull((Object)c.getMaxWidth());
    }

    @Test
    public void setHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getHeight());
    }

    @Test
    public void setMinHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMinHeight());
    }

    @Test
    public void setMaxHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMaxHeight());
    }

    @Test
    public void removeHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getHeight());
        c.setHeight(null);
        Assert.assertNull((Object)c.getHeight());
    }

    @Test
    public void removeMinHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMinHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMinHeight());
        c.setMinHeight(null);
        Assert.assertNull((Object)c.getMinHeight());
    }

    @Test
    public void removeMaxHeight() {
        HasSizeComponent c = new HasSizeComponent();
        c.setMaxHeight("100px");
        Assert.assertEquals((Object)"100px", (Object)c.getMaxHeight());
        c.setMaxHeight(null);
        Assert.assertNull((Object)c.getMaxHeight());
    }

    @Test
    public void setSizeFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        Assert.assertEquals((Object)"100%", (Object)component.getWidth());
        Assert.assertEquals((Object)"100%", (Object)component.getHeight());
    }

    @Test
    public void setSizeFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        Assert.assertTrue((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeFull_setSize_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        component.setWidth("10px");
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
        component.setHeight("10px");
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeFull_setSizeUndefined_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setSizeFull();
        component.setSizeUndefined();
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setWidthFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        Assert.assertEquals((Object)"100%", (Object)component.getWidth());
    }

    @Test
    public void setWidthFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        Assert.assertTrue((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setWidthFull_setWidth_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidthFull();
        component.setWidth("10px");
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setHeightFull() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        Assert.assertEquals((Object)"100%", (Object)component.getHeight());
    }

    @Test
    public void setHeightFull_addsDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertTrue((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setHeightFull_setHeight_removesDataAttribute() {
        HasSizeComponent component = new HasSizeComponent();
        component.setHeightFull();
        component.setHeight("10px");
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-width-full"));
        Assert.assertFalse((boolean)component.getElement().hasAttribute("data-height-full"));
    }

    @Test
    public void setSizeUndefined() {
        HasSizeComponent component = new HasSizeComponent();
        component.setWidth("10px");
        component.setHeight("5em");
        component.setSizeUndefined();
        Assert.assertNull((Object)component.getWidth());
        Assert.assertNull((Object)component.getHeight());
    }

    @Test
    public void getWidthUnit() {
        HasSizeComponent component = new HasSizeComponent();
        Assert.assertFalse((boolean)component.getWidthUnit().isPresent());
        component.setWidth("10px");
        Assert.assertTrue((boolean)component.getWidthUnit().isPresent());
        Assert.assertEquals((Object)Unit.PIXELS, component.getWidthUnit().get());
        component.setSizeUndefined();
        Assert.assertFalse((boolean)component.getWidthUnit().isPresent());
    }

    @Test
    public void getHeightUnit() {
        HasSizeComponent component = new HasSizeComponent();
        Assert.assertFalse((boolean)component.getHeightUnit().isPresent());
        component.setHeight("10%");
        Assert.assertTrue((boolean)component.getHeightUnit().isPresent());
        Assert.assertEquals((Object)Unit.PERCENTAGE, component.getHeightUnit().get());
        component.setSizeUndefined();
        Assert.assertFalse((boolean)component.getHeightUnit().isPresent());
    }

    @Tag(value="div")
    public static class HasSizeComponent
    extends Component
    implements HasSize {
    }
}

