/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEffect;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.ValueSignal;
import com.vaadin.signals.WritableSignal;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class AbstractFieldBindValueTest
extends SignalsUnitTest {
    @Test
    public void bindValue_elementAttachedBefore_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttachedAfter_bindingActive() {
        TestInput input = new TestInput();
        Assert.assertEquals((Object)"", (Object)input.getValue());
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementAttached_bindingActive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        signal.value(null);
        Assert.assertEquals((Object)"", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementNotAttached_bindingInactive() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementDetached_bindingInactive() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        input.removeFromParent();
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_elementReAttached_bindingActivate() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        input.removeFromParent();
        signal.value((Object)"bar");
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_bindValueWhileBindingIsActive_throwException() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        input.bindValue((WritableSignal)new ValueSignal((Object)"foo"));
        Assert.assertThrows(BindingActiveException.class, () -> input.bindValue((WritableSignal)new ValueSignal((Object)"bar")));
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
    }

    @Test
    public void bindValue_setValueWhileBindingIsActive_signalUpdated() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", (Object)signal.peek());
    }

    @Test
    public void bindValue_withNullBinding_removesBinding() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        input.bindValue(null);
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_withNullBinding_allowsSetValue() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        input.bindValue(null);
        input.setValue("bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
    }

    @Test
    public void bindValue_lazyInitSignalBindingFeature() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        input.setValue("foo");
        input.getValue();
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).ifPresent(feature -> Assert.fail((String)"SignalBindingFeature should not be initialized before binding a signal"));
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        input.getElement().getNode().getFeatureIfInitialized(SignalBindingFeature.class).orElseThrow(() -> new AssertionError((Object)"SignalBindingFeature should be initialized after binding a signal"));
    }

    @Test
    public void bindValue_addValueChangeListener_signalValueChangeTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertNull(listenerValue.get());
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"bar", listenerValue.get());
    }

    @Test
    public void bindValue_addValueChangeListener_bindValueTriggersEvent() {
        TestInput input = new TestInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertNull(listenerValue.get());
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", listenerValue.get());
    }

    @Test
    public void bindValue_setValue_countEffectExecutions() {
        TestInput input = new TestInput();
        ValueSignal signal = new ValueSignal((Object)"foo");
        input.bindValue((WritableSignal)signal);
        AtomicInteger counter = new AtomicInteger(0);
        ComponentEffect.effect((Component)input, () -> {
            signal.value();
            counter.incrementAndGet();
        });
        Assert.assertEquals((long)0L, (long)counter.get());
        UI.getCurrent().add(new Component[]{input});
        Assert.assertEquals((long)1L, (long)counter.get());
        input.setValue("bar");
        Assert.assertEquals((long)2L, (long)counter.get());
        input.setValue("bar");
        Assert.assertEquals((long)2L, (long)counter.get());
        input.setValue("foo");
        Assert.assertEquals((long)3L, (long)counter.get());
        signal.value((Object)"baz");
        Assert.assertEquals((long)4L, (long)counter.get());
        input.setValue("baz");
        Assert.assertEquals((long)4L, (long)counter.get());
    }

    @Test
    public void bindValue_forElementProperty_addValueChangeListener_bindingValueChangeTriggersEvent() {
        TestPropertyInput input = new TestPropertyInput();
        UI.getCurrent().add(new Component[]{input});
        ValueSignal signal = new ValueSignal((Object)"foo");
        AtomicReference listenerValue = new AtomicReference();
        input.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listenerValue.set((Serializable)event.getValue()));
        Assert.assertEquals((Object)"", (Object)input.getValue());
        Assert.assertNull(listenerValue.get());
        input.bindValue((WritableSignal)signal);
        Assert.assertEquals((Object)"foo", (Object)input.getValue());
        Assert.assertEquals((Object)"foo", listenerValue.get());
        signal.value((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)input.getValue());
        Assert.assertEquals((Object)"bar", listenerValue.get());
        signal.value(null);
        Assert.assertEquals((Object)"", (Object)input.getValue());
        Assert.assertEquals((Object)"", listenerValue.get());
    }

    @Tag(value="input")
    private static class TestInput
    extends AbstractField<TestInput, String> {
        public TestInput() {
            this("");
        }

        public TestInput(String defaultValue) {
            super((Object)defaultValue);
        }

        protected void setPresentationValue(String newPresentationValue) {
        }
    }

    @Tag(value="input")
    private static class TestPropertyInput
    extends AbstractSinglePropertyField<TestInput, String> {
        public TestPropertyInput() {
            super("value", (Object)"", false);
        }
    }
}

