/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Layout;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RoutePrefix;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.auth.AccessDeniedErrorRouter;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;

public class AccessControlTestClasses {

    @PermitAll
    @Route(value="permitall", layout=NoPermitParent.class)
    public static class PermitAllWithEmptyParentView
    extends Component {
    }

    @Tag(value="div")
    public static class NoPermitParent
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @Layout
    @AnonymousAllowed
    public static class AnonymousAllowedLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    @Layout
    public static class NoAuthLayout
    extends Component
    implements RouterLayout {
    }

    @Tag(value="div")
    public static class NotAnnotatedCustomErrorView
    implements HasErrorParameter<NotFoundException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            return 0;
        }
    }

    @Tag(value="div")
    @AnonymousAllowed
    public static class CustomErrorView
    implements HasErrorParameter<NotFoundException> {
        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            return 0;
        }
    }

    @Route(value="no-annotation-permitall-from-parent-and-interfaces-ignored")
    public static class NoAnnotationPermitAllByGrandParentAsInterfacesIgnoredView
    extends PermitAllParentView
    implements CustomComponent {
    }

    @Route(value="no-annotation-denyall-as-interfaces-ignored")
    public static class NoAnnotationDenyAllAsInterfacesIgnoredView
    implements CustomComponent {
    }

    @AnonymousAllowed
    public static interface CustomComponent {
    }

    @Route(value="no-annotation-denyall-by-grandparent")
    public static class NoAnnotationDenyAllByGrandParentView
    extends DenyAllParentView {
    }

    public static class DenyAllParentView
    extends DenyAllGrandParentView {
    }

    @DenyAll
    public static class DenyAllGrandParentView {
    }

    @Route(value="no-annotation-roles-allowed-admin-by-grandparent")
    public static class NoAnnotationRolesAllowedAdminByGrandParentView
    extends RolesAllowedAdminParentView {
    }

    public static class RolesAllowedAdminParentView
    extends RolesAllowedAdminGrandParentView {
    }

    @RolesAllowed(value={"admin"})
    public static class RolesAllowedAdminGrandParentView {
    }

    @Route(value="no-annotation-roles-allowed-user-by-grandparent")
    public static class NoAnnotationRolesAllowedUserByGrandParentView
    extends RolesAllowedUserParentView {
    }

    public static class RolesAllowedUserParentView
    extends RolesAllowedUserGrandParentView {
    }

    @AccessDeniedErrorRouter(rerouteToError=NotFoundException.class)
    @RolesAllowed(value={"user"})
    public static class RolesAllowedUserGrandParentView {
    }

    @Route(value="no-annotation-permitall-by-grandparent")
    public static class NoAnnotationPermitAllByGrandParentView
    extends PermitAllParentView {
    }

    public static class PermitAllParentView
    extends PermitAllGrandParentView {
    }

    @PermitAll
    public static class PermitAllGrandParentView {
    }

    @Route(value="no-annotation-anonymous-by-grandparent")
    public static class NoAnnotationAnonymousAllowedByGrandParentView
    extends NoAnnotationAnonymousAllowedByParentView {
    }

    @Route(value="no-annotation-anonymous-by-parent")
    public static class NoAnnotationAnonymousAllowedByParentView
    extends AnonymousAllowedParentView {
    }

    @AnonymousAllowed
    public static class AnonymousAllowedParentView
    extends Component {
    }

    @RolesAllowed(value={"admin"})
    @Route(value="admin")
    public static class RolesAllowedAdminView
    extends Component {
    }

    @RolesAllowed(value={"user"})
    @Route(value="user")
    public static class RolesAllowedUserView
    extends Component {
    }

    @DenyAll
    @Route(value="denyall")
    public static class DenyAllView
    extends Component {
    }

    @PermitAll
    @Route(value="permitall")
    public static class PermitAllView
    extends Component {
    }

    @AnonymousAllowed
    @Route(value="anon-with-parent", layout=RoutePrefixParent.class)
    @RouteAlias(value="alias-with-parent", layout=RoutePrefixParent.class)
    public static class AnonymousAllowedWithParent
    extends Component {
    }

    @Tag(value="div")
    @RoutePrefix(value="parent")
    public static class RoutePrefixParent
    extends Component
    implements RouterLayout {
    }

    @AnonymousAllowed
    @Route(value="anon-template/:identifier/:category?/resource/:id([0-9]*)")
    @RouteAlias(value="anon-template-same-params/:identifier/:category?/resource/:id([0-9]*)")
    public static class AnonymousAllowedTemplateView
    extends Component {
    }

    @AnonymousAllowed
    @Route(value="anon-wildcard/:path*")
    public static class AnonymousAllowedWildcardView
    extends Component {
    }

    @AnonymousAllowed
    @Route(value="anon-url-parameter")
    public static class AnonymousAllowedUrlParameterView
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @AnonymousAllowed
    @Route(value="anon")
    @RouteAlias.Container(value={@RouteAlias(value="anon-alias"), @RouteAlias(value="anon-alias-wildcard/:path*"), @RouteAlias(value="anon-alias-template/:identifier/:category?/resource/:id([0-9]*)")})
    public static class AnonymousAllowedView
    extends Component {
    }

    @AccessDeniedErrorRouter(rerouteToError=NotFoundException.class)
    @Route(value="customaccessdenied")
    public static class CustomAccessDeniedView
    extends Component {
    }

    @Route(value="noannotation")
    public static class NoAnnotationView
    extends Component {
    }

    @Route(value="login")
    public static class TestLoginView
    extends Component {
    }

    @RolesAllowed(value={"admin"})
    public static class RolesAllowedAdminClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }

    @RolesAllowed(value={"user"})
    public static class RolesAllowedUserClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }

    @DenyAll
    public static class DenyAllClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }

    @PermitAll
    public static class PermitAllClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }

    @AnonymousAllowed
    public static class AnonymousAllowedClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }

    public static class NoAnnotationClass {
        public void noAnnotation() {
        }

        @AnonymousAllowed
        public void anonymousAllowed() {
        }

        @PermitAll
        public void permitAll() {
        }

        @DenyAll
        public void denyAll() {
        }

        @RolesAllowed(value={"user"})
        public void rolesAllowedUser() {
        }

        @RolesAllowed(value={"admin"})
        public void rolesAllowedAdmin() {
        }

        @RolesAllowed(value={"user", "admin"})
        public void rolesAllowedUserAdmin() {
        }
    }
}

