/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HtmlContainer;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RoutesChangedEvent;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.router.internal.HasUrlParameterFormat;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.WrappedSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.shared.Registration;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SessionRouteRegistryTest {
    private ApplicationRouteRegistry registry;
    private MockService vaadinService;
    private VaadinSession session;

    @Before
    public void init() {
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)new VaadinServletContext((ServletContext)Mockito.mock(ServletContext.class)));
        this.vaadinService = (MockService)((Object)Mockito.mock(MockService.class));
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)this.registry);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)configuration.getFrontendFolder()).thenReturn((Object)new File("/frontend"));
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)configuration);
        MockVaadinContext context = new MockVaadinContext();
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        context.setAttribute(ApplicationConfiguration.class, applicationConfiguration);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)context);
        Mockito.when((Object)applicationConfiguration.isProductionMode()).thenReturn((Object)true);
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        this.session = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return SessionRouteRegistryTest.this.vaadinService;
            }
        };
    }

    @After
    public void tearDown() {
        CurrentInstance.clearAll();
    }

    private SessionRouteRegistry getRegistry(VaadinSession session) {
        try {
            session.lock();
            SessionRouteRegistry sessionRouteRegistry = (SessionRouteRegistry)SessionRouteRegistry.getSessionRegistry((VaadinSession)session);
            return sessionRouteRegistry;
        }
        finally {
            session.unlock();
        }
    }

    @Test
    public void addSameClassForMultipleRoutes_removalOfRouteClassClearsRegisttry() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        registry.setRoute("home", MyRoute.class, Collections.emptyList());
        registry.setRoute("info", MyRoute.class, Collections.emptyList());
        registry.setRoute("path", MyRoute.class, Collections.emptyList());
        registry.setRoute("palace", MyRoute.class, Collections.emptyList());
        Assert.assertTrue((String)"Registry didn't contain navigation targets even though some were registered", (!registry.getRegisteredRoutes().isEmpty() ? 1 : 0) != 0);
        registry.removeRoute(MyRoute.class);
        Assert.assertFalse((String)"Registry should be empty as only one class was registered", (!registry.getRegisteredRoutes().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void addMultipleClassesToSameRoute_removeClassLeavesRoute() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        registry.setRoute("home", MyRoute.class, Collections.emptyList());
        registry.setRoute("home", Parameter.class, Collections.emptyList());
        Assert.assertTrue((String)"Registry didn't contain navigation targets even though some were registered", (!registry.getRegisteredRoutes().isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"No parameters route class was expected for only path String.", MyRoute.class, registry.getNavigationTarget("home").get());
        Assert.assertEquals((String)"No parameters route class was expected for empty segments.", MyRoute.class, registry.getNavigationTarget("home", Collections.emptyList()).get());
        Assert.assertEquals((String)"Expected HasRouteParameters class for request with segments.", Parameter.class, registry.getNavigationTarget("home", Arrays.asList("param")).get());
        registry.removeRoute(MyRoute.class);
        Assert.assertTrue((String)"Registry is empty even though we should have one route available", (!registry.getRegisteredRoutes().isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((String)"MyRoute should have been removed from the registry.", (boolean)registry.getTargetUrl(MyRoute.class).isPresent());
        Assert.assertTrue((String)"Parameter class should have been available from the registry", (boolean)registry.getTargetUrl(Parameter.class, HasUrlParameterFormat.getParameters((Object)"foo")).isPresent());
        Assert.assertTrue((String)"Parameter class should have been available from the registry", (boolean)registry.getTemplate(Parameter.class).isPresent());
        Assert.assertEquals((String)"Parameter route should have been available.", Parameter.class, registry.getNavigationTarget("home", Arrays.asList("param")).get());
    }

    @Test
    public void sessionRegistryOverridesParentRegistryForGetTargetUrl_globalRouteStillAccessible() {
        this.registry.setRoute("MyRoute", MyRoute.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("alternate", MyRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"Expected session registry route to be returned", (Object)"alternate", sessionRegistry.getTargetUrl(MyRoute.class).get());
        Assert.assertTrue((String)"Route 'alternate' should be available.", (boolean)sessionRegistry.getNavigationTarget("alternate").isPresent());
        Assert.assertTrue((String)"Route 'MyRoute' should be available.", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
    }

    @Test
    public void sessionRegistryOverridesParentRegistryWithOwnClass_globalRouteReturnedAfterClassRemoval() {
        this.registry.setRoute("MyRoute", MyRoute.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("MyRoute", Secondary.class, Collections.emptyList());
        Assert.assertEquals((String)"Route 'MyRoute' should return Secondary as registered to SessionRegistry.", Secondary.class, sessionRegistry.getNavigationTarget("MyRoute").get());
        sessionRegistry.removeRoute(Secondary.class);
        Assert.assertEquals((String)"Route 'MyRoute' should return MyRoute as registered to GlobalRegistry.", MyRoute.class, sessionRegistry.getNavigationTarget("MyRoute").get());
    }

    @Test
    public void registerRouteWithAliases_routeAliasesRegisteredAsExpected() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("MyRoute", MyRouteWithAliases.class, Collections.emptyList());
        sessionRegistry.setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        sessionRegistry.setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        Assert.assertTrue((String)"Main route was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
        Assert.assertTrue((String)"RouteAlias 'info' was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"RouteAlias 'version' was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("version").isPresent());
    }

    @Test
    public void routesWithParentLayouts_parentLayoutReturnsAsExpected() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("MyRoute", MyRouteWithAliases.class, Collections.singletonList(MainLayout.class));
        sessionRegistry.setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        sessionRegistry.setRoute("version", MyRouteWithAliases.class, Arrays.asList(MiddleLayout.class, MainLayout.class));
        Assert.assertFalse((String)"'MyRoute' should have a single parent", (boolean)sessionRegistry.getNavigationRouteTarget("MyRoute").getRouteTarget().getParentLayouts().isEmpty());
        Assert.assertTrue((String)"'info' should have no parents.", (boolean)sessionRegistry.getNavigationRouteTarget("info").getRouteTarget().getParentLayouts().isEmpty());
        Assert.assertEquals((String)"'version' should return two parents", (long)2L, (long)sessionRegistry.getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().size());
    }

    @Test
    public void registeredParentLayouts_changingListDoesntChangeRegistration() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        ArrayList<Class> parentChain = new ArrayList<Class>(Arrays.asList(MiddleLayout.class, MainLayout.class));
        registry.setRoute("version", MyRoute.class, parentChain);
        parentChain.remove(MainLayout.class);
        Assert.assertEquals((String)"'version' should return two parents even when original list is changed", (long)2L, (long)registry.getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().size());
    }

    @Test
    public void registeredParentLayouts_returnedListInSameOrder() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        ArrayList<Class> parentChain = new ArrayList<Class>(Arrays.asList(MiddleLayout.class, MainLayout.class));
        registry.setRoute("version", MyRoute.class, parentChain);
        Assert.assertArrayEquals((String)"Registry should return parent layouts in the same order as set.", (Object[])parentChain.toArray(), (Object[])registry.getNavigationRouteTarget("version").getRouteTarget().getParentLayouts().toArray());
    }

    @Test
    public void routeRegisteredOnMultiplePaths_removalOfDefaultPathUpdatesDefaultPath() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("MyRoute", MyRouteWithAliases.class, Collections.emptyList());
        sessionRegistry.setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        sessionRegistry.setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        Assert.assertTrue((String)"Main route was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
        Assert.assertTrue((String)"RouteAlias 'info' was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"RouteAlias 'version' was not registered for given Class.", (boolean)sessionRegistry.getNavigationTarget("version").isPresent());
        Assert.assertEquals((Object)"MyRoute", sessionRegistry.getTargetUrl(MyRouteWithAliases.class).get());
        sessionRegistry.removeRoute("MyRoute");
        Assert.assertFalse((String)"Route 'MyRoute' was still available even though it should have been removed.", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
        Assert.assertTrue((String)"Route 'info' has been removed eve though it should still be available", (boolean)sessionRegistry.getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"Route 'version' has been removed eve though it should still be available", (boolean)sessionRegistry.getNavigationTarget("version").isPresent());
        Assert.assertTrue((String)"Route was not found from the registry anymore even though it should be available.", (boolean)sessionRegistry.getTargetUrl(MyRouteWithAliases.class).isPresent());
        Assert.assertTrue((String)"Route didn't return a url matching either of the expected aliases.", (boolean)Arrays.asList("info", "version").contains(sessionRegistry.getTargetUrl(MyRouteWithAliases.class).get()));
    }

    @Test
    public void manuallyRegisteredAliases_RouteDataIsReturnedCorrectly() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("main", Secondary.class, Collections.emptyList());
        sessionRegistry.setRoute("Alias1", Secondary.class, Collections.emptyList());
        sessionRegistry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        List registeredRoutes = sessionRegistry.getRegisteredRoutes();
        Assert.assertTrue((String)"Registry didn't contain routes even though 3 should have been registered", (!registeredRoutes.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path for main route 'main' returned empty", (boolean)sessionRegistry.getNavigationTarget("main").isPresent());
        Assert.assertTrue((String)"RouteAlias 'Alias1' returned empty.", (boolean)sessionRegistry.getNavigationTarget("Alias1").isPresent());
        Assert.assertTrue((String)"RouteAlias 'Alias2' returned empty.", (boolean)sessionRegistry.getNavigationTarget("Alias2").isPresent());
        Assert.assertEquals((String)"Two 'RouteAlias'es should be registered in the collected route data.", (long)2L, (long)((RouteData)registeredRoutes.get(0)).getRouteAliases().size());
        sessionRegistry.removeRoute("main");
        registeredRoutes = sessionRegistry.getRegisteredRoutes();
        Assert.assertTrue((String)"Registry should still contain the alias routes", (!registeredRoutes.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((String)"One RouteAlias should be the main url so only 1 route alias should be marked as an alias", (long)1L, (long)((RouteData)registeredRoutes.get(0)).getRouteAliases().size());
    }

    @Test
    public void registeredRouteWithAliasGlobally_sessionRegistryReturnsFromGlobal() {
        this.registry.setRoute("MyRoute", MyRouteWithAliases.class, Collections.emptyList());
        this.registry.setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        this.registry.setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        List registeredRoutes = sessionRegistry.getRegisteredRoutes();
        Assert.assertTrue((String)"Registry didn't contain routes even though 3 should have been registered", (!registeredRoutes.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path for main route 'MyRoute' returned empty", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
        Assert.assertTrue((String)"RouteAlias 'info' returned empty.", (boolean)sessionRegistry.getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"RouteAlias 'version' returned empty.", (boolean)sessionRegistry.getNavigationTarget("version").isPresent());
        Assert.assertEquals((String)"Both route aliases should be found for Route", (long)2L, (long)((RouteData)registeredRoutes.get(0)).getRouteAliases().size());
    }

    @Test
    public void registeredRouteWithAliasGlobally_sessionRegistryOverridesMainUrl() {
        this.registry.setRoute("MyRoute", MyRouteWithAliases.class, Collections.emptyList());
        this.registry.setRoute("info", MyRouteWithAliases.class, Collections.emptyList());
        this.registry.setRoute("version", MyRouteWithAliases.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("MyRoute", Secondary.class, Collections.emptyList());
        Assert.assertTrue((String)"Registry didn't contain routes.", (!sessionRegistry.getRegisteredRoutes().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Path for main route 'MyRoute' returned empty", (boolean)sessionRegistry.getNavigationTarget("MyRoute").isPresent());
        Assert.assertEquals((String)"Navigation target for route 'MyRoute' was not the expected one.", Secondary.class, sessionRegistry.getNavigationTarget("MyRoute").get());
        Assert.assertTrue((String)"RouteAlias 'info' returned empty.", (boolean)sessionRegistry.getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"RouteAlias 'version' returned empty.", (boolean)sessionRegistry.getNavigationTarget("version").isPresent());
        Assert.assertTrue((String)"Both route aliases should be found for Route", (boolean)((RouteData)sessionRegistry.getRegisteredRoutes().get(0)).getRouteAliases().isEmpty());
    }

    @Test
    public void setSameRouteValueFromDifferentThreads_ConcurrencyTest() throws InterruptedException, ExecutionException {
        int THREADS = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List callables = IntStream.range(0, 5).mapToObj(i -> {
            Callable<Result> callable = () -> {
                try {
                    SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
                    sessionRegistry.setRoute("MyRoute", MyRoute.class, Collections.emptyList());
                }
                catch (Exception e) {
                    return new Result(e.getMessage());
                }
                return new Result(null);
            };
            return callable;
        }).collect(Collectors.toList());
        List futures = executorService.invokeAll(callables);
        ArrayList<String> exceptions = new ArrayList<String>();
        executorService.shutdown();
        for (Future future : futures) {
            Result result = (Result)future.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"Expected 4 route already exists exceptions due to route target validation", (long)4L, (long)exceptions.size());
        String expected = String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", MyRoute.class.getName(), MyRoute.class.getName());
        for (String exception : exceptions) {
            Assert.assertEquals((Object)expected, (Object)exception);
        }
        Optional optional = this.getRegistry(this.session).getNavigationTarget("MyRoute");
        Assert.assertTrue((String)"MyRoute was missing from the session scope registry.", (boolean)optional.isPresent());
    }

    @Test
    public void useRouteResolutionFromDifferentThreads_ConcurrencyTest() throws InterruptedException, ExecutionException {
        int THREADS = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List callables = IntStream.range(0, 5).mapToObj(i -> {
            Callable<Result> callable = () -> {
                try {
                    SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
                    sessionRegistry.setRoute("MyRoute", MyRoute.class, Collections.emptyList());
                }
                catch (Exception e) {
                    return new Result(e.getMessage());
                }
                return new Result(null);
            };
            return callable;
        }).collect(Collectors.toList());
        List futures = executorService.invokeAll(callables);
        ArrayList<String> exceptions = new ArrayList<String>();
        executorService.shutdown();
        for (Future future : futures) {
            Result result = (Result)future.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"Expected 4 route already exists exceptions due to route target validation", (long)4L, (long)exceptions.size());
        String expected = String.format("Navigation target paths (considering @Route, @RouteAlias and @RoutePrefix values) must be unique, found navigation targets '%s' and '%s' having the same route.", MyRoute.class.getName(), MyRoute.class.getName());
        for (String exception : exceptions) {
            Assert.assertEquals((Object)expected, (Object)exception);
        }
        Optional optional = this.getRegistry(this.session).getNavigationTarget("MyRoute");
        Assert.assertTrue((String)"MyRoute was missing from the session scope registry.", (boolean)optional.isPresent());
    }

    @Test
    public void updateRoutesFromMultipleThreads_allRoutesAreRegistered() throws InterruptedException, ExecutionException {
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getRegistry(this.session).setRoute("home", MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getRegistry(this.session).setRoute("info", MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getRegistry(this.session).setRoute("palace", MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"No exceptions should have been thrown for threaded updates.", (long)0L, (long)exceptions.size());
        Assert.assertTrue((String)"Route 'home' was not registered into the scope.", (boolean)this.getRegistry(this.session).getNavigationTarget("home").isPresent());
        Assert.assertTrue((String)"Route 'info' was not registered into the scope.", (boolean)this.getRegistry(this.session).getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"Route 'palace' was not registered into the scope.", (boolean)this.getRegistry(this.session).getNavigationTarget("palace").isPresent());
    }

    @Test
    public void updateAndRemoveFromMultipleThreads_endResultAsExpected() throws InterruptedException, ExecutionException {
        this.getRegistry(this.session).setRoute("home", MyRoute.class, Collections.emptyList());
        this.getRegistry(this.session).setRoute("info", MyRoute.class, Collections.emptyList());
        ArrayList<Callable<Result>> callables = new ArrayList<Callable<Result>>();
        callables.add(() -> {
            try {
                this.getRegistry(this.session).removeRoute("info");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getRegistry(this.session).setRoute("modular", MyRoute.class, Collections.emptyList());
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        callables.add(() -> {
            try {
                this.getRegistry(this.session).setRoute("palace", MyRoute.class, Collections.emptyList());
                this.getRegistry(this.session).removeRoute("home");
            }
            catch (Exception e) {
                return new Result(e.getMessage());
            }
            return new Result(null);
        });
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        ArrayList<String> exceptions = new ArrayList<String>();
        for (Future resultFuture : futures) {
            Result result = (Result)resultFuture.get();
            if (result.value == null) continue;
            exceptions.add(result.value);
        }
        Assert.assertEquals((String)"No exceptions should have been thrown for threaded updates.", (long)0L, (long)exceptions.size());
        Assert.assertFalse((String)"Route 'home' was still registered even though it should have been removed.", (boolean)this.getRegistry(this.session).getNavigationTarget("home").isPresent());
        Assert.assertFalse((String)"Route 'info' was still registered even though it should have been removed.", (boolean)this.getRegistry(this.session).getNavigationTarget("info").isPresent());
        Assert.assertTrue((String)"Route 'modular' was not registered into the scope.", (boolean)this.getRegistry(this.session).getNavigationTarget("modular").isPresent());
        Assert.assertTrue((String)"Route 'palace' was not registered into the scope.", (boolean)this.getRegistry(this.session).getNavigationTarget("palace").isPresent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void settingSessionRouteRegistryOfAnotherSession_getRegistryFails() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        MockVaadinSession anotherSession = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return SessionRouteRegistryTest.this.vaadinService;
            }
        };
        SessionRouteRegistry anotherRegistry = this.getRegistry(anotherSession);
        Assert.assertNotEquals((String)"Another session should receive another session", (Object)registry, (Object)anotherRegistry);
        this.session.lock();
        try {
            this.session.setAttribute(SessionRouteRegistry.class, (Object)anotherRegistry);
        }
        finally {
            this.session.unlock();
        }
        this.getRegistry(this.session);
        Assert.fail((String)"Setting anotherRegistry to session should fail when getting the registry!");
    }

    @Test
    public void lockingConfiguration_configurationIsUpdatedOnlyAfterUnlockk() {
        final CountDownLatch waitReaderThread = new CountDownLatch(1);
        final CountDownLatch waitUpdaterThread = new CountDownLatch(2);
        SessionRouteRegistry registry = this.getRegistry(this.session);
        Thread readerThread = new Thread(){

            @Override
            public void run() {
                SessionRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)SessionRouteRegistryTest.this.getRegistry(SessionRouteRegistryTest.this.session).getRegisteredRoutes().isEmpty());
                SessionRouteRegistryTest.this.awaitCountDown(waitUpdaterThread);
                Assert.assertTrue((String)"Registry should still remain empty", (boolean)SessionRouteRegistryTest.this.getRegistry(SessionRouteRegistryTest.this.session).getRegisteredRoutes().isEmpty());
                waitReaderThread.countDown();
            }
        };
        readerThread.start();
        registry.update((Command & Serializable)() -> {
            registry.setRoute("", MyRoute.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            registry.setRoute("path", Secondary.class, Collections.emptyList());
            waitUpdaterThread.countDown();
            this.awaitCountDown(waitReaderThread);
        });
        Assert.assertEquals((String)"After unlock registry should be updated for others to configure with new data", (long)2L, (long)this.getRegistry(this.session).getRegisteredRoutes().size());
    }

    @Test
    public void routeChangeListener_correctChangesAreReturned() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        registry.setRoute("", MyRoute.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(MyRoute.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"", (Object)((RouteBaseData)added.get(0)).getTemplate());
        registry.setRoute("home", Secondary.class, Collections.emptyList());
        Assert.assertFalse((String)"Added should contain data for one entry", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Only latest change should be available", (long)1L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        Assert.assertEquals(Secondary.class, (Object)((RouteBaseData)added.get(0)).getNavigationTarget());
        Assert.assertEquals((Object)"home", (Object)((RouteBaseData)added.get(0)).getTemplate());
        registry.removeRoute("home");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertEquals((String)"One route should have gotten removed", (long)1L, (long)removed.size());
        Assert.assertEquals(Secondary.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"The 'home' route should have been removed", (Object)"home", (Object)((RouteBaseData)removed.get(0)).getTemplate());
    }

    @Test
    public void routeChangeListener_blockChangesAreGivenCorrectlyInEvent() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        registry.setRoute("", MyRoute.class, Collections.emptyList());
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        registry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        registry.update((Command & Serializable)() -> {
            registry.removeRoute("");
            registry.setRoute("path", Secondary.class, Collections.emptyList());
            registry.setRoute("", MyRoute.class, Collections.singletonList(MainLayout.class));
        });
        Assert.assertEquals((String)"Two ne paths should have been added", (long)2L, (long)added.size());
        Assert.assertEquals((String)"One path should have been removed", (long)1L, (long)removed.size());
        for (RouteBaseData data : added) {
            if (data.getTemplate().equals("")) {
                Assert.assertEquals((String)"MyRoute should have been added", MyRoute.class, (Object)data.getNavigationTarget());
                Assert.assertEquals((String)"MyRoute should have been seen as a update as the parent layouts changed.", MainLayout.class, (Object)data.getParentLayout());
                continue;
            }
            Assert.assertEquals((String)"", Secondary.class, (Object)data.getNavigationTarget());
        }
        Assert.assertEquals((String)"One MyRoute should have been removed", MyRoute.class, (Object)((RouteBaseData)removed.get(0)).getNavigationTarget());
        Assert.assertEquals((String)"Removed version should not have a parent layout", Collections.emptyList(), (Object)((RouteBaseData)removed.get(0)).getParentLayouts());
    }

    @Test
    public void routeWithAliases_eventShowsCorrectlyAsRemoved() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        sessionRegistry.addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            added.clear();
            removed.clear();
            added.addAll(event.getAddedRoutes());
            removed.addAll(event.getRemovedRoutes());
        });
        sessionRegistry.update((Command & Serializable)() -> {
            sessionRegistry.setRoute("main", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"Main route and aliases should all be seen as added.", (long)3L, (long)added.size());
        Assert.assertTrue((String)"No routes should have been removed", (boolean)removed.isEmpty());
        sessionRegistry.removeRoute("Alias2");
        Assert.assertTrue((String)"No routes should have been added", (boolean)added.isEmpty());
        Assert.assertEquals((String)"Removing the alias route should be seen in the event", (long)1L, (long)removed.size());
    }

    @Test
    public void maskedPathsInParent_eventContainsOnlyChangesVisibleForSession() {
        this.registry.setRoute("main", MyRoute.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        ArrayList events = new ArrayList();
        sessionRegistry.update((Command & Serializable)() -> {
            sessionRegistry.setRoute("main", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        sessionRegistry.addRoutesChangeListener(events::add);
        this.registry.removeRoute(MyRoute.class);
        Assert.assertTrue((String)"No event for masked path should have been received.", (boolean)events.isEmpty());
        this.registry.setRoute("main", MyRoute.class, Collections.emptyList());
        Assert.assertTrue((String)"No event for masked path should have been received.", (boolean)events.isEmpty());
        this.registry.setRoute("home", Secondary.class, Collections.emptyList());
        Assert.assertEquals((String)"Addition of non masked path should have fired an event.", (long)1L, (long)events.size());
        Assert.assertEquals((String)"Source should have been ApplicationRouteRegistry", (Object)this.registry, (Object)((RoutesChangedEvent)events.get(0)).getSource());
        Assert.assertEquals((String)"One route should have been added", (long)1L, (long)((RoutesChangedEvent)events.get(0)).getAddedRoutes().size());
        Assert.assertEquals((String)"No routes should have been removed", (long)0L, (long)((RoutesChangedEvent)events.get(0)).getRemovedRoutes().size());
    }

    @Test
    public void removeListener_noEventsAreGottenForAnyRegistry() {
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        ArrayList events = new ArrayList();
        Registration registration = sessionRegistry.addRoutesChangeListener(events::add);
        this.registry.setRoute("main", MyRoute.class, Collections.emptyList());
        sessionRegistry.update((Command & Serializable)() -> {
            sessionRegistry.setRoute("main", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias1", Secondary.class, Collections.emptyList());
            sessionRegistry.setRoute("Alias2", Secondary.class, Collections.emptyList());
        });
        Assert.assertEquals((String)"One event for both registries should have been fired.", (long)2L, (long)events.size());
        registration.remove();
        sessionRegistry.removeRoute("main");
        Assert.assertEquals((String)"No new event should have been received for session scope", (long)2L, (long)events.size());
        this.registry.removeRoute("main");
        Assert.assertEquals((String)"No new event should have been received for application scope", (long)2L, (long)events.size());
    }

    @Test
    public void serialize_deserialize_parentRegistryIsANewOne() throws Throwable {
        this.session = new MockVaadinSession((VaadinService)this.vaadinService);
        TestSessionRouteRegistry registry = new TestSessionRouteRegistry(this.session);
        TestSessionRouteRegistry deserialized = this.serializeAndDeserialize(registry);
        TestService service = new TestService();
        RouteRegistry newAppRegistry = service.getRouteRegistry();
        Mockito.when((Object)newAppRegistry.getNavigationTarget("foo", Collections.emptyList())).thenReturn(Optional.of(HtmlContainer.class));
        WrappedSession wrappedSession = (WrappedSession)Mockito.mock(WrappedSession.class);
        deserialized.session.refreshTransients(wrappedSession, (VaadinService)service);
        Assert.assertEquals(Optional.empty(), (Object)registry.getNavigationTarget("foo", Collections.emptyList()));
        Assert.assertEquals(Optional.of(HtmlContainer.class), (Object)deserialized.getNavigationTarget("foo", Collections.emptyList()));
    }

    @Test
    public void getTargetUrl_annotatedRoute_rootIsAlias_mainRouteIsNotRoot_mainRouteIsReturned() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        RouteConfiguration configuration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        configuration.setAnnotatedRoute(RouteWithRootAlias.class);
        Optional url = registry.getTargetUrl(RouteWithRootAlias.class, RouteParameters.empty());
        Assert.assertTrue((boolean)url.isPresent());
        Assert.assertEquals((Object)"foo", url.get());
    }

    @Test
    public void getTargetUrl_annotatedRoute_rootIsAlias_mainRouteIsParamerterized_routeAliasIsReturned() {
        SessionRouteRegistry registry = this.getRegistry(this.session);
        RouteConfiguration configuration = RouteConfiguration.forRegistry((RouteRegistry)registry);
        configuration.setAnnotatedRoute(ParameterizedRouteWithRootAlias.class);
        Optional url = registry.getTargetUrl(ParameterizedRouteWithRootAlias.class, RouteParameters.empty());
        Assert.assertTrue((boolean)url.isPresent());
        Assert.assertEquals((Object)"", url.get());
    }

    @Test
    public void sessionScopeContainsTemplateRoute_applicationRegistryExactMatchIsReturned() {
        this.registry.setRoute(":first/:second", Templated.class, Collections.emptyList());
        this.registry.setRoute("other/view", NonTemplated.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        Assert.assertEquals((String)"ApplicationRegisty Templated should be found.", Templated.class, sessionRegistry.getNavigationTarget("oh/my").get());
        Assert.assertEquals((String)"ApplicationRegistry NonTemplated should be found", NonTemplated.class, sessionRegistry.getNavigationTarget("other/view").get());
        sessionRegistry.setRoute(":one/:two", Secondary.class, Collections.emptyList());
        Assert.assertEquals((String)"SessionRegistry should override ApplicationRegistry Templated", Secondary.class, sessionRegistry.getNavigationTarget("oh/my").get());
        Assert.assertEquals((String)"ApplicationRegistry exact match should be returned instead of SessionRegistry wildcard match", NonTemplated.class, sessionRegistry.getNavigationTarget("other/view").get());
        sessionRegistry.setRoute("other/:one", MyRoute.class, Collections.emptyList());
        Assert.assertEquals((String)"ApplicationRegistry exact match should be returned instead of any SessionRegistry wildcard match", NonTemplated.class, sessionRegistry.getNavigationTarget("other/view").get());
        Assert.assertEquals((String)"SessionRegistry best match with least wildcards should be returned", MyRoute.class, sessionRegistry.getNavigationTarget("other/plank").get());
    }

    @Test
    public void sessionScopeContainsTemplateRoute_applicationRegistryBetterMatchIsReturned() {
        this.registry.setRoute("other/view/parent", NonTemplated.class, Collections.emptyList());
        this.registry.setRoute("other/alias/:extra?", Templated.class, Collections.emptyList());
        SessionRouteRegistry sessionRegistry = this.getRegistry(this.session);
        sessionRegistry.setRoute("other/view/:session", MyRoute.class, Collections.emptyList());
        sessionRegistry.setRoute("other/:match/:session?", Secondary.class, Collections.emptyList());
        Assert.assertEquals((String)"MyRoute should be selected as the matching parts are equal", MyRoute.class, sessionRegistry.getNavigationTarget("other/view/offset").get());
        Assert.assertEquals((String)"Exact macth in ApplicationRegistry should be selected", NonTemplated.class, sessionRegistry.getNavigationTarget("other/view/parent").get());
        Assert.assertEquals((String)"Closer macth in ApplicationRegistry should be selected", Templated.class, sessionRegistry.getNavigationTarget("other/alias").get());
        Assert.assertEquals((String)"Closer macth in ApplicationRegistry should be selected", Templated.class, sessionRegistry.getNavigationTarget("other/alias/extra").get());
    }

    private <T> T serializeAndDeserialize(T instance) throws Throwable {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(instance);
        byte[] data = bs.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Object readObject = in.readObject();
        return (T)readObject;
    }

    private void awaitCountDown(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
    }

    private static class MockService
    extends VaadinServletService {
        private MockService() {
        }

        public RouteRegistry getRouteRegistry() {
            return super.getRouteRegistry();
        }
    }

    @Tag(value="div")
    @Route(value="MyRoute")
    private static class MyRoute
    extends Component {
        private MyRoute() {
        }
    }

    @Tag(value="div")
    private static class Parameter
    extends Component
    implements HasUrlParameter<String> {
        private Parameter() {
        }

        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    @Tag(value="div")
    private static class Secondary
    extends Component {
        private Secondary() {
        }
    }

    @Tag(value="div")
    @Route(value="MyRoute")
    @RouteAlias.Container(value={@RouteAlias(value="info"), @RouteAlias(value="version")})
    private static class MyRouteWithAliases
    extends Component {
        private MyRouteWithAliases() {
        }
    }

    @Tag(value="div")
    private static class MainLayout
    extends Component
    implements RouterLayout {
        private MainLayout() {
        }
    }

    @Tag(value="div")
    private static class MiddleLayout
    extends Component
    implements RouterLayout {
        private MiddleLayout() {
        }
    }

    private static class Result {
        final String value;

        Result(String value) {
            this.value = value;
        }
    }

    private static class TestSessionRouteRegistry
    extends SessionRouteRegistry {
        private final VaadinSession session;

        TestSessionRouteRegistry(VaadinSession session) {
            super(session);
            this.session = session;
        }
    }

    private static class TestService
    extends VaadinServletService {
        private ReentrantLock lock = (ReentrantLock)Mockito.mock(ReentrantLock.class);
        private RouteRegistry appRegistry = (RouteRegistry)Mockito.mock(ApplicationRouteRegistry.class);

        private TestService() {
            Mockito.when((Object)this.lock.isHeldByCurrentThread()).thenReturn((Object)true);
        }

        protected Lock getSessionLock(WrappedSession wrappedSession) {
            return this.lock;
        }

        protected RouteRegistry getRouteRegistry() {
            return this.appRegistry;
        }
    }

    @Tag(value="div")
    @Route(value="foo")
    @RouteAlias(value="")
    private static class RouteWithRootAlias
    extends Component {
        private RouteWithRootAlias() {
        }
    }

    @Tag(value="div")
    @Route(value=":foo")
    @RouteAlias(value="")
    private static class ParameterizedRouteWithRootAlias
    extends Component {
        private ParameterizedRouteWithRootAlias() {
        }
    }

    @Route(value=":first/:second")
    @Tag(value="div")
    public static class Templated
    extends Component {
    }

    @Route(value="other/view")
    @Tag(value="div")
    public static class NonTemplated
    extends Component {
    }

    @Tag(value="div")
    private static class ErrorView
    extends Component
    implements HasErrorParameter<NotFoundException> {
        private ErrorView() {
        }

        public int setErrorParameter(BeforeEnterEvent event, ErrorParameter<NotFoundException> parameter) {
            return 404;
        }
    }
}

