/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.ComponentTest;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.RouterLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RouterLayoutTest {
    private static final String NEW_ID = "newId";
    private TestRouterLayout testRouterLayout;

    @Before
    public void setup() {
        this.testRouterLayout = new TestRouterLayout();
    }

    @Test
    public void show_nonNull_childrenUpdated() {
        Assert.assertEquals((long)0L, (long)this.testRouterLayout.getElement().getChildCount());
        ComponentTest.TestDiv content = new ComponentTest.TestDiv();
        this.testRouterLayout.showRouterLayoutContent((HasElement)content);
        Assert.assertEquals((long)1L, (long)this.testRouterLayout.getElement().getChildCount());
        ComponentTest.TestDiv newContent = new ComponentTest.TestDiv();
        newContent.setId(NEW_ID);
        content.getElement().removeFromParent();
        this.testRouterLayout.showRouterLayoutContent((HasElement)newContent);
        Assert.assertEquals((long)1L, (long)this.testRouterLayout.getElement().getChildCount());
        Assert.assertSame((Object)NEW_ID, (Object)this.testRouterLayout.getElement().getChild(0).getAttribute("id"));
    }

    @Test
    public void show_null_noChildren() {
        this.testRouterLayout.showRouterLayoutContent(null);
        Assert.assertEquals((long)0L, (long)this.testRouterLayout.getElement().getChildCount());
    }

    @Test
    public void remove_removesContent() {
        ComponentTest.TestDiv content = new ComponentTest.TestDiv();
        this.testRouterLayout.element.appendChild(new Element[]{content.getElement()});
        this.testRouterLayout.removeRouterLayoutContent((HasElement)content);
        Assert.assertEquals((long)0L, (long)this.testRouterLayout.getElement().getChildCount());
    }

    private static class TestRouterLayout
    implements RouterLayout {
        private final Element element = new Element("span");

        private TestRouterLayout() {
        }

        public Element getElement() {
            return this.element;
        }
    }
}

