/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.i18n.TranslationFileRequestHandler;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.jcip.annotations.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

@NotThreadSafe
public class TranslationFileRequestHandlerTest {
    private final VaadinSession session = (VaadinSession)Mockito.mock(VaadinSession.class);
    private final VaadinRequest request = (VaadinRequest)Mockito.mock(VaadinRequest.class);
    private VaadinResponse response;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private ClassLoader urlClassLoader;
    private TranslationFileRequestHandler handler;
    private StringWriter out;
    private PrintWriter writer;
    private File translationsFolder;
    private ArgumentCaptor<String> retrievedLocaleCapture;
    private final List<Locale> providedLocales = new ArrayList<Locale>();
    private I18NProvider i18NProvider;

    @Before
    public void configure() throws IOException, NoSuchFieldException, IllegalAccessException {
        this.initTranslationsFolder();
    }

    @After
    public void cleanup() {
        ResourceBundle.clearCache(this.urlClassLoader);
    }

    @Test
    public void pathDoesNotMatch_requestNotHandled() throws IOException {
        this.configure(true);
        this.setRequestParams(null, "other", null, null);
        Assert.assertFalse((boolean)this.handler.handleRequest(this.session, this.request, this.response));
    }

    @Test
    public void withRootBundle_languageTagIsNull_responseIsRootBundle() throws IOException {
        this.configure(true);
        this.testResponseContent(null, "{\"title\":\"Root bundle lang\"}", "und");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withoutRootBundle_languageTagIsNull_responseIsEmpty() throws IOException {
        this.configure(false);
        this.testResponseContent(null, "", null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    @Test
    public void withRootBundle_languageTagIsEmpty_responseIsRootBundle() throws IOException {
        this.configure(true);
        this.testResponseContent("", "{\"title\":\"Root bundle lang\"}", "und");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withoutRootBundle_languageTagIsEmpty_responseIsEmpty() throws IOException {
        this.configure(false);
        this.testResponseContent("", "", null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    @Test
    public void languageTagWithoutCountryAvailable_responseIsCorrect() throws IOException {
        this.configure(true);
        this.testResponseContent("fi", "{\"title\":\"Suomi\"}", "fi");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void tagContainsOnlyLanguage_languageOnlyAvailableWithCountry_responseIsEmpty() throws IOException {
        this.configure(false);
        this.testResponseContent("es", "", null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    @Test
    public void languageTagWithCountryAvailable_responseIsCorrect() throws IOException {
        this.configure(false);
        this.testResponseContent("es-ES", "{\"title\":\"Espanol (Spain)\"}", "es-ES");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withRootBundle_requestedLocaleBundleNotAvailable_responseIsRootBundle() throws IOException {
        this.configure(true);
        this.testResponseContent("en-US", "{\"title\":\"Root bundle lang\"}", "en-US");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withoutRootBundle_requestedLocaleBundleNotAvailable_responseIsEmpty() throws IOException {
        this.configure(false);
        this.testResponseContent("en-US", "", null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    @Test
    public void languageTagWithUnderscoresAvailable_responseIsCorrect() throws IOException {
        this.configure(false);
        this.testResponseContent("es_ES", "{\"title\":\"Espanol (Spain)\"}", "es-ES");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withRootBundle_languageTagWithUnderscoresNotAvailable_responseIsRootBundle() throws IOException {
        this.configure(true);
        this.testResponseContent("it_IT", "{\"title\":\"Root bundle lang\"}", "it-IT");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void withoutRootBundle_languageTagWithUnderscoresNotAvailable_responseIsEmpty() throws IOException {
        this.configure(false);
        this.testResponseContent("it_IT", "", null);
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    @Test
    public void withCustomizedDefaultI18nProvider_requestedLocaleBundleAvailable_responseIsRootBundle() throws IOException {
        this.configure(true, CustomI18NProvider.class, false);
        this.testResponseContent("fi", "{\"title\":\"title-fi\"}", "fi");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    @Test
    public void productionMode_withCustomizedDefaultI18nProvider_requestedLocaleBundleAvailable_responseIsRootBundle() throws IOException {
        this.configure(true, CustomI18NProvider.class, true);
        this.testResponseContent("fi", "{\"title\":\"title-fi\"}", "fi");
        ((VaadinResponse)Mockito.verify((Object)this.response)).setStatus(HttpStatusCode.OK.getCode());
    }

    private void setUpChunkedTest() throws IOException {
        this.createTranslationFile("title=Root bundle lang\nkey1=Value1\nkey2=Value2\n".stripIndent(), "");
        this.createTranslationFile("title=Suomi\nkey1=SuomiValue1\nkey2=SuomiValue2\n".stripIndent(), "_fi");
        this.createTranslationFile("title=Espanol (Spain)\nkey1=EspanolValue1\nkey2=EspanolValue2\n".stripIndent(), "_es_ES");
        File i18nJson = new File(this.translationsFolder, "i18n.json");
        String json = "{\n    \"chunks\": {\n        \"indexhtml\": {\n            \"keys\": [\n                \"title\"\n            ]\n        },\n        \"other\": {\n            \"keys\": [\n                \"key1\",\n                \"key2\"\n            ]\n        }\n    }\n}\n".stripIndent();
        Files.writeString(i18nJson.toPath(), (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        this.mockI18nProvider(DefaultI18NProvider.class);
        this.mockService(true);
        this.handler = new TranslationFileRequestHandler(this.i18NProvider, this.urlClassLoader);
        this.mockResponse();
    }

    @Test
    public void productionMode_withChunks_filtersKeys() throws IOException {
        this.setUpChunkedTest();
        this.testResponseContent("", new String[]{"indexhtml"}, null, "{\"title\":\"Root bundle lang\"}", "und");
    }

    @Test
    public void productionMode_withKeys_onlyReturnsThose() throws IOException {
        this.setUpChunkedTest();
        this.testResponseContent("", null, new String[]{"title"}, "{\"title\":\"Root bundle lang\"}", "und");
    }

    private void testResponseContent(String requestedLanguageTag, String expectedResponseContent, String expectedResponseLanguageTag) throws IOException {
        this.testResponseContent(requestedLanguageTag, null, null, expectedResponseContent, expectedResponseLanguageTag);
    }

    private void testResponseContent(String requestedLanguageTag, String[] requestedChunks, String[] requestedKeys, String expectedResponseContent, String expectedResponseLanguageTag) throws IOException {
        this.setRequestParams(requestedLanguageTag, HandlerHelper.RequestType.TRANSLATION_FILE.getIdentifier(), requestedChunks, requestedKeys);
        Assert.assertTrue((String)"The request was not handled by the handler.", (boolean)this.handler.handleRequest(this.session, this.request, this.response));
        Assert.assertEquals((String)"The expected response content does not match the actual response content.", (Object)expectedResponseContent, (Object)this.getResponseContent());
        if (expectedResponseLanguageTag == null) {
            Assert.assertEquals((String)"The response language tag was not found.", (long)0L, (long)this.retrievedLocaleCapture.getAllValues().size());
        } else {
            Assert.assertEquals((String)"The expected response language tag does not match the actual response language tag.", (Object)expectedResponseLanguageTag, (Object)this.retrievedLocaleCapture.getValue());
        }
    }

    private String getResponseContent() {
        this.writer.flush();
        return this.out.toString();
    }

    private void setRequestParams(String langtag, String requestTypeId, String[] chunks, String[] keys) {
        Mockito.when((Object)this.request.getParameter("langtag")).thenReturn((Object)langtag);
        Mockito.when((Object)this.request.getParameter("v-r")).thenReturn((Object)requestTypeId);
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        if (chunks != null) {
            paramMap.put("chunks", chunks);
        }
        if (keys != null) {
            paramMap.put("keys", keys);
        }
        Mockito.when((Object)this.request.getParameterMap()).thenReturn(paramMap);
    }

    private void createTranslationFiles(boolean withRootBundleFile) throws IOException {
        if (withRootBundleFile) {
            this.createTranslationFile("title=Root bundle lang", "");
        }
        this.providedLocales.add(Locale.forLanguageTag("fi"));
        this.createTranslationFile("title=Suomi", "_fi");
        this.providedLocales.add(Locale.forLanguageTag("es-ES"));
        this.createTranslationFile("title=Espanol (Spain)", "_es_ES");
    }

    private void createTranslationFile(String content, String fileNameSuffix) throws IOException {
        File file = new File(this.translationsFolder, "translations" + fileNameSuffix + ".properties");
        Files.writeString(file.toPath(), (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE);
    }

    private void configure(boolean withRootBundle) throws IOException {
        this.configure(withRootBundle, DefaultI18NProvider.class, false);
    }

    private void configure(boolean withRootBundle, Class<? extends I18NProvider> i18NProviderClass, boolean isProductionMode) throws IOException {
        this.createTranslationFiles(withRootBundle);
        this.mockI18nProvider(i18NProviderClass);
        this.mockService(isProductionMode);
        this.handler = new TranslationFileRequestHandler(this.i18NProvider, this.urlClassLoader);
        this.mockResponse();
    }

    private void initTranslationsFolder() throws IOException {
        File resources = this.temporaryFolder.newFolder();
        this.translationsFolder = new File(resources, "vaadin-i18n");
        this.translationsFolder.mkdirs();
        this.urlClassLoader = new URLClassLoader(new URL[]{resources.toURI().toURL()});
    }

    private void mockI18nProvider(Class<? extends I18NProvider> i18NProviderClass) {
        if (i18NProviderClass.equals(DefaultI18NProvider.class)) {
            this.i18NProvider = (I18NProvider)Mockito.spy((Object)new DefaultI18NProvider(this.providedLocales, this.urlClassLoader));
        } else {
            this.i18NProvider = (I18NProvider)Mockito.mock(i18NProviderClass, (Answer)Mockito.CALLS_REAL_METHODS);
            Mockito.when((Object)this.i18NProvider.getProvidedLocales()).thenReturn(this.providedLocales);
        }
    }

    private void mockResponse() throws IOException {
        this.response = (VaadinResponse)Mockito.mock(VaadinResponse.class);
        this.out = new StringWriter();
        this.writer = new PrintWriter(this.out);
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)this.writer);
        this.retrievedLocaleCapture = ArgumentCaptor.forClass(String.class);
        ((VaadinResponse)Mockito.doNothing().when((Object)this.response)).setHeader((String)Mockito.eq((Object)"X-Vaadin-Retrieved-Locale"), (String)this.retrievedLocaleCapture.capture());
    }

    private void mockService(boolean isProductionMode) {
        Instantiator instantiator = (Instantiator)Mockito.mock(Instantiator.class);
        Mockito.when((Object)instantiator.getI18NProvider()).thenReturn((Object)this.i18NProvider);
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Mockito.when((Object)service.getInstantiator()).thenReturn((Object)instantiator);
        DeploymentConfiguration configuration = (DeploymentConfiguration)Mockito.mock(DeploymentConfiguration.class);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)isProductionMode);
        Mockito.when((Object)service.getDeploymentConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)this.session.getService()).thenReturn((Object)service);
    }

    private static class CustomI18NProvider
    implements I18NProvider {
        private final List<Locale> providedLocales;

        private CustomI18NProvider(List<Locale> providedLocales) {
            this.providedLocales = providedLocales;
        }

        public List<Locale> getProvidedLocales() {
            return this.providedLocales;
        }

        public String getTranslation(String key, Locale locale, Object ... params) {
            return key + "-" + String.valueOf(locale);
        }

        public Map<String, String> getAllTranslations(Locale locale) {
            return Map.of("title", this.getTranslation("title", locale, new Object[0]));
        }
    }
}

