/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.ThemeListImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class ThemeListImplTest {
    @Test
    public void themeListCreatedWithNoThemes() {
        ThemeListImpl emptyList = new ThemeListImpl((Element)new MockElement(new String[0]));
        Assert.assertTrue((String)"ThemeList created from the element without themes should be empty", (boolean)emptyList.isEmpty());
        Assert.assertEquals((String)"ThemeList created from the element without themes should be empty", (long)emptyList.size(), (long)0L);
    }

    @Test
    public void themeListCreatedWithOneThemes() {
        String themeName = "theme1";
        ThemeListImpl elementWithOneTheme = new ThemeListImpl((Element)new MockElement(themeName));
        Assert.assertEquals((String)"ThemeList created from the element with one theme should contain single element", (long)elementWithOneTheme.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList created from the element with one theme should contain this theme as its single element", (boolean)elementWithOneTheme.contains((Object)themeName));
    }

    @Test
    public void themeListCreatedWithMultipleThemes() {
        String[] themeNames = new String[]{"theme1", "theme2"};
        ThemeListImpl elementWithMultipleThemes = new ThemeListImpl((Element)new MockElement(themeNames));
        Assert.assertFalse((String)"ThemeList created from the element with multiple distinct themes should not be empty", (boolean)elementWithMultipleThemes.isEmpty());
        Assert.assertEquals((String)"ThemeList created from the element with multiple distinct themes should be of the same size as number of the themes", (long)elementWithMultipleThemes.size(), (long)themeNames.length);
        Assert.assertTrue((String)"ThemeList created from the element with multiple distinct themes should contain them all and oly them", (boolean)elementWithMultipleThemes.containsAll(Arrays.asList(themeNames)));
    }

    @Test
    public void themeListCreatedWithDuplicateThemes() {
        String[] themeNames = new String[]{"theme1", "theme1", "theme1"};
        ThemeListImpl elementWithMultipleThemes = new ThemeListImpl((Element)new MockElement(themeNames));
        Assert.assertEquals((String)"ThemeList created from the element with multiple themes should be of the same size as number of unique themes", (long)elementWithMultipleThemes.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList created from the element with multiple themes should be contain all unique themes", (boolean)elementWithMultipleThemes.contains((Object)themeNames[0]));
    }

    @Test
    public void clear() {
        MockElement element = new MockElement("theme1", "theme2");
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.clear();
        Assert.assertTrue((String)"ThemeList should be empty after it's cleared", (boolean)themeList.isEmpty());
        Assert.assertNull((String)"If corresponding ThemeList is cleared, no themes should be preset in the corresponding element", (Object)element.getAttribute("theme"));
    }

    @Test
    public void remove() {
        String themeToRemove = "theme2";
        String themeToLeave = "theme1";
        MockElement element = new MockElement(themeToLeave, themeToRemove);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.remove((Object)themeToRemove);
        Assert.assertEquals((String)"Only one theme should be present in ThemeList after removal", (long)themeList.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList should contain theme that was not removed", (boolean)themeList.contains((Object)themeToLeave));
        Assert.assertEquals((String)"Corresponding element should contain only the theme that was not removed", (Object)element.getAttribute("theme"), (Object)themeToLeave);
    }

    @Test
    public void removeAll() {
        String themeToRemove1 = "theme3";
        String themeToRemove2 = "theme2";
        String themeToLeave = "theme1";
        MockElement element = new MockElement(themeToLeave, themeToRemove1, themeToRemove2);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.removeAll(Arrays.asList(themeToRemove1, themeToRemove2));
        Assert.assertEquals((String)"Only one theme should be present in ThemeList after removal", (long)themeList.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList should contain theme that was not removed", (boolean)themeList.contains((Object)themeToLeave));
        Assert.assertEquals((String)"Corresponding element should contain only the theme that was not removed", (Object)element.getAttribute("theme"), (Object)themeToLeave);
    }

    @Test
    public void removeAllThemes() {
        String[] themeNames = new String[]{"theme1", "theme2"};
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.removeAll(Arrays.asList(themeNames));
        Assert.assertTrue((String)"ThemeList should be empty after all it's themes are removed", (boolean)themeList.isEmpty());
        Assert.assertNull((String)"If corresponding ThemeList is cleared, no themes should be preset in the corresponding element", (Object)element.getAttribute("theme"));
    }

    @Test
    public void retainAll() {
        List<String> elementsToRetain = Arrays.asList("retained", "notRetained");
        String[] themeNames = new String[]{elementsToRetain.get(0), "theme2", "theme3"};
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.retainAll(elementsToRetain);
        Assert.assertEquals((String)"ThemeList should contain one retained theme", (long)themeList.size(), (long)1L);
        Assert.assertEquals((String)"Corresponding element should contain the only element present in ThemeList", (Object)element.getAttribute("theme"), themeList.iterator().next());
    }

    @Test
    public void add() {
        String themeToAdd = "theme";
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.add(themeToAdd);
        Assert.assertEquals((String)"ThemeList should not be empty after adding a theme", (long)themeList.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList should contain theme added", (boolean)themeList.contains((Object)themeToAdd));
        Assert.assertEquals((String)"Corresponding element should contain the theme added", (Object)element.getAttribute("theme"), (Object)themeToAdd);
    }

    @Test
    public void addAll() {
        List<String> themesToAdd = Arrays.asList("theme1", "theme2", "theme3");
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.addAll(themesToAdd);
        Assert.assertFalse((String)"ThemeList should not be empty after adding themes", (boolean)themeList.isEmpty());
        Assert.assertEquals((String)"ThemeList size should be equal to number of distinct themes added if it was empty before", (long)themeList.size(), (long)themesToAdd.size());
        Assert.assertTrue((String)"ThemeList should contain all distinct themes added", (boolean)themeList.containsAll(themesToAdd));
        themesToAdd.forEach(themeName -> Assert.assertTrue((String)"Each distinct theme added to ThemeList should be present in correspondent element's 'theme' attribute", (boolean)element.getAttribute("theme").contains((CharSequence)themeName)));
    }

    @Test
    public void addDuplicates() {
        List<String> themesToAdd = Arrays.asList("theme1", "theme1", "theme1");
        MockElement element = new MockElement(new String[0]);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        themeList.addAll(themesToAdd);
        Assert.assertEquals((String)"ThemeList should not be empty after themes have been added", (long)themeList.size(), (long)1L);
        Assert.assertTrue((String)"ThemeList should contain all distinct themes added", (boolean)themeList.contains((Object)themesToAdd.get(0)));
        Assert.assertEquals((String)"Corresponding element should have all distinct themes added", (Object)element.getAttribute("theme"), (Object)themesToAdd.get(0));
    }

    @Test
    public void iteratorRemoval() {
        String[] themeNames = new String[]{"theme1", "theme2", "theme3"};
        List<String> originalThemes = Arrays.asList(themeNames);
        MockElement element = new MockElement(themeNames);
        ThemeListImpl themeList = new ThemeListImpl((Element)element);
        HashSet<String> removedElements = new HashSet<String>();
        Iterator iterator = themeList.iterator();
        removedElements.add((String)iterator.next());
        iterator.remove();
        removedElements.add((String)iterator.next());
        iterator.remove();
        Assert.assertEquals((String)"ThemeList should have one element left after removal", (long)themeList.size(), (long)1L);
        String notRemovedTheme = (String)themeList.iterator().next();
        Assert.assertTrue((String)"Themes returned by ThemeList's iterator.next() should be present in the original list of themes", (boolean)originalThemes.containsAll(removedElements));
        Assert.assertTrue((String)"Theme left in ThemeList after removal should be present in the original list of themes", (boolean)originalThemes.contains(notRemovedTheme));
        Assert.assertFalse((String)"Removed themes should not contain theme left in the ThemeList", (boolean)removedElements.contains(notRemovedTheme));
        Assert.assertEquals((String)"Theme left in ThemeList after removal should be the only theme preset in the corresponding element", (Object)element.getAttribute("theme"), (Object)notRemovedTheme);
    }

    private static class MockElement
    extends Element {
        private final Map<String, String> attributesMap = new HashMap<String, String>();

        private MockElement(String ... themeNames) {
            super("mock-element");
            if (themeNames.length > 0) {
                this.attributesMap.put("theme", Stream.of(themeNames).collect(Collectors.joining(" ")));
            }
        }

        public Element setAttribute(String attribute, String value) {
            this.attributesMap.put(attribute, value);
            return this;
        }

        public String getAttribute(String attribute) {
            return this.attributesMap.get(attribute);
        }

        public Element removeAttribute(String attribute) {
            this.attributesMap.remove(attribute);
            return this;
        }
    }
}

