/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.InertData;
import java.util.Optional;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ElementUtilTest {
    private Element parent;
    private Element child;
    private Element grandchild;
    private StateTree stateTree;

    @Test
    public void isNullValidAttribute() {
        Assert.assertFalse((boolean)ElementUtil.isValidAttributeName(null));
    }

    @Test
    public void isEmptyValidAttribute() {
        Assert.assertFalse((boolean)ElementUtil.isValidAttributeName((String)""));
    }

    @Test(expected=AssertionError.class)
    public void isUpperCaseValidAttribute() {
        ElementUtil.isValidAttributeName((String)"FOO");
    }

    @Test
    public void componentNotInitiallyAttached() {
        Element e = ElementFactory.createDiv();
        Assert.assertFalse((boolean)e.getComponent().isPresent());
    }

    @Test
    public void attachToComponent() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assert.assertEquals((Object)c, e.getComponent().get());
    }

    @Test
    public void attachComponentToTextElement() {
        Element e = Element.createText((String)"Text text");
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        Assert.assertEquals((Object)c, e.getComponent().get());
    }

    @Test(expected=IllegalStateException.class)
    public void attachTwiceToComponent() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        ElementUtil.setComponent((Element)e, (Component)c);
    }

    @Test(expected=IllegalArgumentException.class)
    public void attachToNull() {
        Element e = ElementFactory.createDiv();
        ElementUtil.setComponent((Element)e, null);
    }

    @Test(expected=IllegalStateException.class)
    public void attachTwoComponents() {
        Element e = ElementFactory.createDiv();
        Component c = (Component)Mockito.mock(Component.class);
        Component c2 = (Component)Mockito.mock(Component.class);
        ElementUtil.setComponent((Element)e, (Component)c);
        ElementUtil.setComponent((Element)e, (Component)c2);
    }

    @Test
    public void toAndFromJsoup() {
        String EXPECTED_TEXT_1 = "Some text";
        String EXPECTED_TEXT_2 = "Other text";
        Element originalElement = ElementFactory.createDiv();
        originalElement.appendChild(new Element[]{(Element)ElementFactory.createParagraph((String)"Some text").appendChild(new Element[]{ElementFactory.createDiv((String)"Other text")})});
        Document jDocument = Document.createShell((String)"http://example.com");
        Node jNode = ElementUtil.toJsoup((Document)jDocument, (Element)originalElement);
        Optional optionalElement = ElementUtil.fromJsoup((Node)jNode);
        Assert.assertTrue((String)"Element should have been created from jNode", (boolean)optionalElement.isPresent());
        Element recreatedElement = (Element)optionalElement.get();
        Assert.assertEquals((String)"Root element should be div", (Object)"div", (Object)recreatedElement.getTag());
        Assert.assertEquals((String)"Child element should be a paragraph", (Object)"p", (Object)recreatedElement.getChild(0).getTag());
        Assert.assertEquals((String)"Child element should have text", (Object)"Some text", (Object)recreatedElement.getChild(0).getText());
        Assert.assertEquals((String)"Grand-child element should be a div", (Object)"div", (Object)recreatedElement.getChild(0).getChild(1).getTag());
        Assert.assertEquals((String)"Grand-child element should have text", (Object)"Other text", (Object)recreatedElement.getChild(0).getChild(1).getText());
    }

    @Test
    public void isValidTagName_validTagNames() {
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo-bar"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo_bar"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo_bar-baz"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo12.bar3"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"foo-._"));
        Assert.assertTrue((boolean)ElementUtil.isValidTagName((String)"x"));
    }

    @Test
    public void isValidTagName_invalidTagNames() {
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)"1foo"));
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)"-foo"));
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)"_foo"));
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)".foo"));
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)"foo>"));
        Assert.assertFalse((boolean)ElementUtil.isValidTagName((String)"foo$bar"));
    }

    @Test
    public void parentIsInert_childIgnoresParentInert_allThePermutations() {
        this.setupElementHierarchy();
        Assert.assertFalse((String)"by default parent inert state is not ignored", (boolean)this.isIgnoreParentInert(this.child));
        Assert.assertFalse((String)"by default element should not be inert", (boolean)this.isInert(this.child));
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)true);
        Assert.assertFalse((boolean)this.isInert(this.child));
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertFalse((boolean)this.isInert(this.child));
        Assert.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)false);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.child, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertFalse((boolean)this.isInert(this.child));
        Assert.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setInert((Element)this.child, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setInert((Element)this.parent, (boolean)false);
        this.simulateWritingChangesToClient();
        Assert.assertFalse((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertTrue((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInert_grandChildIgnoresInert_notInert() {
        this.setupElementHierarchy();
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertTrue((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertFalse((boolean)this.isInert(this.grandchild));
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)false);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertTrue((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInertGrandChildIgnores_statesChangedAtSameTime_changesApplied() {
        this.setupElementHierarchy();
        ElementUtil.setInert((Element)this.parent, (boolean)true);
        ElementUtil.setIgnoreParentInert((Element)this.grandchild, (boolean)true);
        this.simulateWritingChangesToClient();
        Assert.assertTrue((boolean)this.isInert(this.parent));
        Assert.assertTrue((boolean)this.isInert(this.child));
        Assert.assertFalse((boolean)this.isInert(this.grandchild));
    }

    @Test
    public void parentInert_siblingIgnoresInheritingInert_siblingInert() {
        Element sibling = ElementFactory.createDiv();
    }

    @Test
    public void elementsUpdateSameData() {
        Element te = new Element("testelem");
        Element e = ElementUtil.from((StateNode)te.getNode()).orElse(null);
        Assert.assertEquals((Object)te, (Object)e);
    }

    @Test
    public void getElementFromInvalidNode() {
        StateNode node = new StateNode(new Class[]{ElementPropertyMap.class});
        Assert.assertFalse((boolean)ElementUtil.from((StateNode)node).isPresent());
    }

    private void setupElementHierarchy() {
        this.parent = ElementFactory.createDiv();
        this.child = ElementFactory.createDiv();
        this.grandchild = ElementFactory.createDiv();
        this.parent.appendChild(new Element[]{(Element)this.child.appendChild(new Element[]{this.grandchild})});
        this.stateTree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class, InertData.class});
        StateNode rootNode = this.stateTree.getRootNode();
        ((ElementChildrenList)rootNode.getFeature(ElementChildrenList.class)).add(0, this.parent.getNode());
    }

    private boolean isIgnoreParentInert(Element element) {
        return element.getNode().getFeatureIfInitialized(InertData.class).map(InertData::isIgnoreParentInert).orElse(false);
    }

    private boolean isInert(Element element) {
        return element.getNode().isInert();
    }

    private void simulateWritingChangesToClient() {
        this.stateTree.collectChanges(nodeChanges -> {});
    }
}

