/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.SyntheticState;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultInstantiatorTest {
    @Test
    public void createComponent_dontDependOnGetOrCreate() {
        DefaultInstantiator instantiator = (DefaultInstantiator)Mockito.mock(DefaultInstantiator.class);
        Mockito.when((Object)instantiator.createComponent((Class)Mockito.any())).thenCallRealMethod();
        TestComponent component = (TestComponent)instantiator.createComponent(TestComponent.class);
        Assert.assertNotNull((Object)((Object)component));
        ((DefaultInstantiator)Mockito.verify((Object)instantiator, (VerificationMode)Mockito.times((int)0))).getOrCreate((Class)Mockito.any());
    }

    @Test
    public void getOrCreate_lookupHasObject_returnObjectFromLookup() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        Lookup lookup = this.mockLookup(service);
        DefaultInstantiator instantiator = new DefaultInstantiator(service);
        Mockito.when((Object)((List)lookup.lookup(List.class))).thenReturn(new ArrayList());
        List list = (List)instantiator.getOrCreate(List.class);
        Assert.assertTrue((boolean)(list instanceof ArrayList));
    }

    @Test
    public void getOrCreate_lookupHasNoObject_createNewObject() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator instantiator = new DefaultInstantiator(service);
        TestComponent component = (TestComponent)((Object)instantiator.getOrCreate(TestComponent.class));
        Assert.assertNotNull((Object)((Object)component));
    }

    @Test
    public void getApplicationClass_regularClass_getsSameClass() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator instantiator = new DefaultInstantiator(service);
        TestComponent instance = (TestComponent)((Object)instantiator.getOrCreate(TestComponent.class));
        Assert.assertSame(TestComponent.class, (Object)instantiator.getApplicationClass((Object)instance));
        Assert.assertSame(TestComponent.class, (Object)instantiator.getApplicationClass(((Object)((Object)instance)).getClass()));
    }

    @Test
    public void getApplicationClass_syntheticClass_getsApplicationClass() throws Exception {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        this.mockLookup(service);
        DefaultInstantiator instantiator = new DefaultInstantiator(service);
        Class syntheticClass = new ByteBuddy().subclass(TestComponent.class).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, SyntheticState.SYNTHETIC}).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        TestComponent instance = (TestComponent)((Object)syntheticClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        Assert.assertNotSame(TestComponent.class, ((Object)((Object)instance)).getClass());
        Assert.assertSame(TestComponent.class, (Object)instantiator.getApplicationClass((Object)instance));
        Assert.assertSame(TestComponent.class, (Object)instantiator.getApplicationClass(((Object)((Object)instance)).getClass()));
    }

    private Lookup mockLookup(VaadinService service) {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)context);
        Lookup lookup = (Lookup)Mockito.mock(Lookup.class);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)lookup);
        return lookup;
    }

    @Tag(value="a")
    public static class TestComponent
    extends Component {
    }
}

