/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.Nullable;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.DoubleNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.NumericNode;

public class MutableTreeRevision
extends TreeRevision {
    public MutableTreeRevision(TreeRevision base) {
        super(base.ownerId(), new HashMap<Id, Node>(base.nodes()), new HashMap<Id, SignalCommand.ScopeOwnerCommand>(base.originalInserts()));
    }

    public Map<Id, CommandResult> applyAndGetResults(List<SignalCommand> commands) {
        HashMap<Id, CommandResult> results = new HashMap<Id, CommandResult>();
        for (SignalCommand command : commands) {
            this.apply(command, results::put);
        }
        return results;
    }

    public void apply(List<SignalCommand> commands) {
        for (SignalCommand command : commands) {
            this.apply(command, null);
        }
    }

    public void apply(SignalCommand command, @Nullable CommandDispatcher resultCollector) {
        CommandResult result = this.data(command.targetNodeId()).map(data -> {
            TreeManipulator manipulator = new TreeManipulator(command);
            CommandResult opResult = manipulator.handleCommand(command);
            if (manipulator.subCommandResults != null && resultCollector != null) {
                manipulator.subCommandResults.forEach(resultCollector::dispatch);
            }
            return opResult;
        }).orElseGet(() -> CommandResult.fail("Node not found"));
        if (result instanceof CommandResult.Accept) {
            CommandResult.Accept accept = (CommandResult.Accept)result;
            accept.updates().forEach((nodeId, update) -> {
                Node newNode = update.newNode();
                if (newNode == null) {
                    this.nodes().remove(nodeId);
                    this.originalInserts().remove(nodeId);
                } else {
                    this.nodes().put((Id)nodeId, newNode);
                }
            });
            this.originalInserts().putAll(accept.originalInserts());
        }
        if (resultCollector != null) {
            resultCollector.dispatch(command.commandId(), result);
        }
        assert (this.assertValidTree());
    }

    @FunctionalInterface
    static interface CommandDispatcher
    extends Serializable {
        public void dispatch(Id var1, CommandResult var2);
    }

    private class TreeManipulator
    implements Serializable {
        private final Map<Id, Node> updatedNodes = new HashMap<Id, Node>();
        private final Set<Id> detachedNodes = new HashSet<Id>();
        private final Map<Id, SignalCommand.ScopeOwnerCommand> originalInserts = new HashMap<Id, SignalCommand.ScopeOwnerCommand>();
        private final SignalCommand command;
        private @Nullable CommandResult result;
        private @Nullable Map<Id, CommandResult> subCommandResults;
        private static Map<Class<? extends SignalCommand>, SerializableBiConsumer<TreeManipulator, ? extends SignalCommand>> handlers = new HashMap<Class<? extends SignalCommand>, SerializableBiConsumer<TreeManipulator, ? extends SignalCommand>>();

        public TreeManipulator(SignalCommand command) {
            this.command = command;
        }

        private void setResult(CommandResult result) {
            assert (this.result == null);
            this.result = result;
        }

        private void fail(String reason) {
            this.setResult(CommandResult.fail(reason));
        }

        private @Nullable Id resolveAlias(@Nullable Id nodeId) {
            Node dataOrAlias = this.updatedNodes.get(nodeId);
            if (dataOrAlias == null) {
                dataOrAlias = MutableTreeRevision.this.nodes().get(nodeId);
            }
            if (dataOrAlias instanceof Node.Alias) {
                Node.Alias alias = (Node.Alias)dataOrAlias;
                return alias.target();
            }
            return nodeId;
        }

        private Optional<Node.Data> data(Id nodeId) {
            Id id = Objects.requireNonNull(this.resolveAlias(nodeId));
            if (this.detachedNodes.contains(id)) {
                return Optional.empty();
            }
            if (this.updatedNodes.containsKey(id)) {
                return Optional.ofNullable((Node.Data)this.updatedNodes.get(id));
            }
            return MutableTreeRevision.this.data(id);
        }

        private void useData(Id nodeId, BiConsumer<Node.Data, Id> consumer) {
            assert (this.result == null);
            Id id = Objects.requireNonNull(this.resolveAlias(nodeId));
            this.data(id).ifPresentOrElse(node -> consumer.accept((Node.Data)node, id), () -> this.fail("Node not found"));
        }

        private void updateData(Id nodeId, SignalUpdater<Node.Data> updater) {
            this.useData(nodeId, (node, id) -> {
                Node.Data updatedNode = updater.update((Node.Data)node);
                if (updatedNode != node) {
                    this.updatedNodes.put((Id)id, updatedNode);
                }
            });
        }

        private @Nullable JsonNode value(Id nodeId) {
            return this.data(nodeId).map(Node.Data::value).orElse(null);
        }

        private void setValue(Id nodeId, @Nullable JsonNode value) {
            this.updateData(nodeId, node -> {
                Objects.requireNonNull(node);
                return new Node.Data(node.parent(), this.command.commandId(), node.scopeOwner(), value, node.listChildren(), node.mapChildren());
            });
        }

        private Optional<List<Id>> listChildren(Id parentId) {
            return this.data(parentId).map(Node.Data::listChildren);
        }

        private boolean isChildAt(Id parentId, int index, Id expectedChild) {
            assert (expectedChild != null);
            if (index < 0) {
                return false;
            }
            Id idAtIndex = this.listChildren(parentId).map(children -> {
                if (index >= children.size()) {
                    return null;
                }
                return (Id)children.get(index);
            }).orElse(null);
            return this.isSameNode(idAtIndex, expectedChild);
        }

        private Optional<Id> mapChild(Id nodeId, String key) {
            return this.data(nodeId).map(Node.Data::mapChildren).map(children -> (Id)children.get(key));
        }

        private boolean isSameNode(@Nullable Id a, @Nullable Id b) {
            return Objects.equals(this.resolveAlias(a), this.resolveAlias(b));
        }

        private boolean detach(Id nodeId) {
            this.useData(nodeId, (node, id) -> {
                if (id.equals(Id.ZERO)) {
                    this.fail("Cannot detach the root");
                    return;
                }
                Id parentId = node.parent();
                if (parentId == null) {
                    this.fail("Node is not attached");
                    return;
                }
                Node.Data parentData = this.data(parentId).get();
                String key = parentData.mapChildren().entrySet().stream().filter(entry -> ((Id)entry.getValue()).equals(id)).findAny().map(Map.Entry::getKey).orElse(null);
                if (key != null) {
                    this.updatedNodes.put(parentId, this.updateMapChildren(parentData, map -> map.remove(key)));
                } else {
                    this.updatedNodes.put(parentId, this.updateListChildren(parentData, list -> list.remove(id)));
                }
                this.detachedNodes.add((Id)id);
            });
            return this.result == null;
        }

        private Node.Data updateMapChildren(Node.Data node, SerializableConsumer<Map<String, Id>> mapUpdater) {
            LinkedHashMap<String, Id> map = new LinkedHashMap<String, Id>(node.mapChildren());
            mapUpdater.accept(map);
            return new Node.Data(node.parent(), this.command.commandId(), node.scopeOwner(), node.value(), node.listChildren(), Collections.unmodifiableMap(map));
        }

        private Node.Data updateListChildren(Node.Data node, SerializableConsumer<List<Id>> listUpdater) {
            ArrayList<Id> list = new ArrayList<Id>(node.listChildren());
            listUpdater.accept(list);
            return new Node.Data(node.parent(), this.command.commandId(), node.scopeOwner(), node.value(), Collections.unmodifiableList(list), node.mapChildren());
        }

        private void attach(Id parentId, Id childId, ChildAttacher attacher) {
            if (this.result != null) {
                return;
            }
            Id resolvedParentId = Objects.requireNonNull(this.resolveAlias(parentId));
            Id resolvedChildId = Objects.requireNonNull(this.resolveAlias(childId));
            if (!this.detachedNodes.contains(resolvedChildId)) {
                this.fail("Node is not detached");
                return;
            }
            Id ancestor = resolvedParentId;
            while (ancestor != null) {
                if (ancestor.equals(resolvedChildId)) {
                    this.fail("Cannot attach to own descendant");
                    return;
                }
                ancestor = this.data(ancestor).map(Node.Data::parent).orElse(null);
            }
            this.useData(parentId, (node, id) -> {
                this.detachedNodes.remove(resolvedChildId);
                Node.Data updated = attacher.attach((Node.Data)node, resolvedChildId);
                if (this.result == null && updated != null) {
                    Node.Data child = this.data(resolvedChildId).get();
                    this.updatedNodes.put((Id)id, updated);
                    this.updatedNodes.put(resolvedChildId, new Node.Data((Id)id, child.lastUpdate(), child.scopeOwner(), child.value(), child.listChildren(), child.mapChildren()));
                }
            });
        }

        private void attachAs(Id parentId, String key, Id childId) {
            this.attach(parentId, childId, (parentNode, resolvedChildId) -> this.updateMapChildren(parentNode, map -> {
                Id previous = map.putIfAbsent(key, resolvedChildId);
                if (previous != null) {
                    this.fail("Key is in use");
                }
            }));
        }

        private int findInsertIndex(List<Id> children, SharedListSignal.ListPosition insertPosition) {
            Id after = this.resolveAlias(insertPosition.after());
            Id before = this.resolveAlias(insertPosition.before());
            if (after != null) {
                int position;
                if (after.equals(Id.EDGE)) {
                    position = 0;
                } else {
                    int indexOf = children.indexOf(after);
                    if (indexOf == -1) {
                        return -1;
                    }
                    position = indexOf + 1;
                }
                if (before != null) {
                    Id atPosition;
                    Id id = atPosition = position < children.size() ? children.get(position) : Id.EDGE;
                    if (!atPosition.equals(before)) {
                        return -1;
                    }
                }
                return position;
            }
            if (before == null) {
                return -1;
            }
            if (before.equals(Id.EDGE)) {
                return children.size();
            }
            return children.indexOf(before);
        }

        private void attachAt(Id parentId, SharedListSignal.ListPosition position, Id childId) {
            this.attach(parentId, childId, (node, resolvedChildId) -> {
                int insertIndex = this.findInsertIndex(node.listChildren(), position);
                if (insertIndex == -1) {
                    this.fail("Insert position not matched");
                    return null;
                }
                return this.updateListChildren(node, list -> list.add(insertIndex, resolvedChildId));
            });
        }

        private void createNode(Id nodeId, @Nullable JsonNode value, @Nullable Id scopeOwner) {
            if (this.data(nodeId).isPresent()) {
                this.fail("Node already exists");
                return;
            }
            this.detachedNodes.add(nodeId);
            this.updatedNodes.put(nodeId, new Node.Data(null, this.command.commandId(), scopeOwner, value, List.of(), Map.of()));
            if (MutableTreeRevision.this.ownerId().equals(scopeOwner)) {
                this.originalInserts.put(nodeId, (SignalCommand.ScopeOwnerCommand)this.command);
            }
        }

        private CommandResult.NodeModification createModification(Id id, @Nullable Node newNode) {
            Node.Data original = MutableTreeRevision.this.data(id).orElse(null);
            return new CommandResult.NodeModification(original, newNode);
        }

        private static <T extends SignalCommand> void addHandler(Class<T> commandType, SerializableBiConsumer<TreeManipulator, T> handler) {
            handlers.put(commandType, handler);
        }

        private static <T extends SignalCommand.ConditionCommand> void addConditionHandler(Class<T> commandType, SerializableBiFunction<TreeManipulator, T, CommandResult> handler) {
            TreeManipulator.addHandler(commandType, (manipulator, command) -> manipulator.setResult((CommandResult)handler.apply((TreeManipulator)manipulator, (Object)command)));
        }

        public CommandResult handleCommand(SignalCommand command) {
            SerializableBiConsumer<TreeManipulator, ? extends SignalCommand> handler = handlers.get(command.getClass());
            if (handler == null) {
                throw new IllegalStateException("No handler for " + command.getClass().getName());
            }
            handler.accept(this, command);
            if (this.result != null) {
                return this.result;
            }
            HashMap<Id, CommandResult.NodeModification> updates = new HashMap<Id, CommandResult.NodeModification>();
            this.updatedNodes.forEach((id, newNode) -> {
                if (!this.detachedNodes.contains(id)) {
                    updates.put((Id)id, this.createModification((Id)id, (Node)newNode));
                }
            });
            if (!this.detachedNodes.isEmpty()) {
                HashMap reverseAliases = new HashMap();
                MutableTreeRevision.this.nodes().forEach((signalId, nodeOrAlias) -> {
                    if (nodeOrAlias instanceof Node.Alias) {
                        Node.Alias alias = (Node.Alias)nodeOrAlias;
                        reverseAliases.computeIfAbsent(alias.target(), ignore -> new ArrayList()).add(signalId);
                    }
                });
                LinkedList<Id> toDetach = new LinkedList<Id>(this.detachedNodes);
                while (!toDetach.isEmpty()) {
                    Id removed = toDetach.removeLast();
                    updates.put(removed, this.createModification(removed, null));
                    reverseAliases.getOrDefault(removed, List.of()).forEach(aliasToRemove -> updates.put((Id)aliasToRemove, this.createModification((Id)aliasToRemove, null)));
                    Node.Data node = MutableTreeRevision.this.data(removed).get();
                    toDetach.addAll(node.listChildren());
                    toDetach.addAll(node.mapChildren().values());
                }
            }
            return new CommandResult.Accept(updates, this.originalInserts);
        }

        private CommandResult handleValueCondition(SignalCommand.ValueCondition test) {
            JsonNode expectedValue;
            JsonNode value = this.value(test.targetNodeId());
            if (value == null) {
                value = NullNode.getInstance();
            }
            if ((expectedValue = test.expectedValue()) == null) {
                expectedValue = NullNode.getInstance();
            }
            return CommandResult.conditional(value.equals((Object)expectedValue), "Unexpected value");
        }

        private CommandResult handlePositionCondition(SignalCommand.PositionCondition test) {
            Id before;
            Id nodeId = test.targetNodeId();
            Id resolvedChild = this.resolveAlias(test.childId());
            int indexOf = this.listChildren(nodeId).map(list -> list.indexOf(resolvedChild)).orElseGet(() -> -1);
            if (indexOf == -1) {
                return CommandResult.fail("Not a child");
            }
            SharedListSignal.ListPosition position = test.position();
            Id after = position.after();
            if (after != null) {
                if (after.equals(Id.EDGE)) {
                    if (indexOf != 0) {
                        return CommandResult.fail("Not the first child");
                    }
                } else if (!this.isChildAt(nodeId, indexOf - 1, after)) {
                    return CommandResult.fail("Not after the provided child");
                }
            }
            if ((before = position.before()) != null) {
                if (before.equals(Id.EDGE)) {
                    int childCount = this.listChildren(nodeId).map(List::size).orElse(0);
                    if (indexOf != childCount - 1) {
                        return CommandResult.fail("Not the last child");
                    }
                } else if (!this.isChildAt(nodeId, indexOf + 1, before)) {
                    return CommandResult.fail("Not before the provided child");
                }
            }
            return CommandResult.ok();
        }

        private CommandResult handleKeyCondition(SignalCommand.KeyCondition keyTest) {
            Id nodeId = keyTest.targetNodeId();
            String key = keyTest.key();
            Id expectedChild = keyTest.expectedChild();
            Id actualChildId = this.mapChild(nodeId, key).orElse(null);
            if (expectedChild == null) {
                return CommandResult.conditional(actualChildId != null, "Key not present");
            }
            if (Id.ZERO.equals(expectedChild)) {
                return CommandResult.conditional(actualChildId == null, "A key is present");
            }
            return CommandResult.conditional(this.isSameNode(actualChildId, expectedChild), "Unexpected child");
        }

        private CommandResult handleLastUpdateCondition(SignalCommand.LastUpdateCondition lastUpdateTest) {
            Id lastUpdate = this.data(lastUpdateTest.targetNodeId()).map(Node.Data::lastUpdate).orElse(null);
            return CommandResult.conditional(Objects.equals(lastUpdate, lastUpdateTest.expectedLastUpdate()), "Unexpected last update");
        }

        private void handleAdoptAs(SignalCommand.AdoptAsCommand adoptAs) {
            Id nodeId = adoptAs.targetNodeId();
            String key = adoptAs.key();
            Id childId = adoptAs.childId();
            if (this.detach(childId)) {
                this.attachAs(nodeId, key, childId);
            }
        }

        private void handleAdoptAt(SignalCommand.AdoptAtCommand adoptAt) {
            Id nodeId = adoptAt.targetNodeId();
            SharedListSignal.ListPosition position = adoptAt.position();
            Id childId = adoptAt.childId();
            if (this.detach(childId)) {
                this.attachAt(nodeId, position, childId);
            }
        }

        private void handleIncrement(SignalCommand.IncrementCommand increment) {
            double newValue;
            Id nodeId = increment.targetNodeId();
            double delta = increment.delta();
            JsonNode oldValue = this.value(nodeId);
            if (oldValue instanceof NumericNode) {
                NumericNode value = (NumericNode)oldValue;
                newValue = value.doubleValue() + delta;
            } else if (oldValue == null || oldValue instanceof NullNode) {
                newValue = delta;
            } else {
                this.fail("Value is not numeric");
                return;
            }
            this.setValue(nodeId, (JsonNode)new DoubleNode(newValue));
        }

        private void handleClear(SignalCommand.ClearCommand clear) {
            this.updateData(clear.targetNodeId(), node -> {
                Objects.requireNonNull(node);
                this.detachedNodes.addAll(node.listChildren());
                this.detachedNodes.addAll(node.mapChildren().values());
                if (this.detachedNodes.isEmpty()) {
                    return node;
                }
                return new Node.Data(node.parent(), this.command.commandId(), node.scopeOwner(), node.value(), List.of(), Map.of());
            });
        }

        private void handleRemoveByKey(SignalCommand.RemoveByKeyCommand removeByKey) {
            this.mapChild(removeByKey.targetNodeId(), removeByKey.key()).ifPresentOrElse(this::detach, () -> this.fail("Key not present"));
        }

        private void handlePut(SignalCommand.PutCommand put) {
            Id commandId = put.commandId();
            Id nodeId = put.targetNodeId();
            String key = put.key();
            JsonNode value = put.value();
            this.mapChild(nodeId, key).ifPresentOrElse(childId -> this.setValue((Id)childId, value), () -> {
                this.createNode(commandId, value, null);
                this.attachAs(nodeId, key, commandId);
            });
        }

        private void handlePutIfAbsent(SignalCommand.PutIfAbsentCommand putIfAbsent) {
            Id commandId = putIfAbsent.commandId();
            Id nodeId = putIfAbsent.targetNodeId();
            String key = putIfAbsent.key();
            this.mapChild(nodeId, key).ifPresentOrElse(childId -> this.useData(nodeId, (node, id) -> this.updatedNodes.put((Id)id, (Node)node)), () -> {
                this.createNode(commandId, putIfAbsent.value(), putIfAbsent.scopeOwner());
                this.attachAs(nodeId, key, commandId);
            });
        }

        private void handleInsert(SignalCommand.InsertCommand insert) {
            Id commandId = insert.commandId();
            this.createNode(commandId, insert.value(), insert.scopeOwner());
            this.attachAt(insert.targetNodeId(), insert.position(), commandId);
        }

        private void handleSet(SignalCommand.SetCommand set) {
            this.setValue(set.targetNodeId(), set.value());
        }

        private void handleRemove(SignalCommand.RemoveCommand remove) {
            Id parentId;
            Id nodeId = remove.targetNodeId();
            Id expectedParentId = remove.expectedParentId();
            if (expectedParentId != null && !this.isSameNode(expectedParentId, parentId = (Id)this.data(nodeId).map(Node.Data::parent).orElse(null))) {
                this.fail("Not a child");
                return;
            }
            this.detach(nodeId);
        }

        private void handleClearOwner(SignalCommand.ClearOwnerCommand clearOwner) {
            Id ownerId = clearOwner.ownerId();
            MutableTreeRevision.this.nodes().forEach((id, nodeOrAlias) -> {
                Node.Data node;
                if (nodeOrAlias instanceof Node.Data && ownerId.equals((node = (Node.Data)nodeOrAlias).scopeOwner())) {
                    this.detach((Id)id);
                }
            });
        }

        private void handleTransaction(SignalCommand.TransactionCommand transaction) {
            List<SignalCommand> commands = transaction.commands();
            MutableTreeRevision scratchpad = new MutableTreeRevision(MutableTreeRevision.this);
            this.subCommandResults = new HashMap<Id, CommandResult>();
            CommandResult.Reject firstReject = null;
            for (SignalCommand command : commands) {
                CommandResult.Reject reject;
                scratchpad.apply(command, this.subCommandResults::put);
                CommandResult childResult = this.subCommandResults.get(command.commandId());
                if (!(childResult instanceof CommandResult.Reject)) continue;
                firstReject = reject = (CommandResult.Reject)childResult;
                break;
            }
            if (firstReject == null) {
                HashMap<Id, CommandResult.NodeModification> updates = new HashMap<Id, CommandResult.NodeModification>();
                HashMap<Id, SignalCommand.ScopeOwnerCommand> originalInserts = new HashMap<Id, SignalCommand.ScopeOwnerCommand>();
                for (SignalCommand command : commands) {
                    CommandResult.Accept op = (CommandResult.Accept)this.subCommandResults.get(command.commandId());
                    if (op == null) {
                        throw new IllegalStateException("Missing result for command " + String.valueOf(command.commandId()));
                    }
                    op.updates().forEach((nodeId, modification) -> {
                        if (updates.containsKey(nodeId)) {
                            updates.put((Id)nodeId, new CommandResult.NodeModification(((CommandResult.NodeModification)updates.get(nodeId)).oldNode(), modification.newNode()));
                        } else {
                            updates.put((Id)nodeId, (CommandResult.NodeModification)modification);
                        }
                    });
                    originalInserts.putAll(op.originalInserts());
                }
                this.setResult(new CommandResult.Accept(updates, originalInserts));
            } else {
                for (SignalCommand command : commands) {
                    CommandResult originalResult = this.subCommandResults.get(command.commandId());
                    if (originalResult != null && !(originalResult instanceof CommandResult.Accept)) continue;
                    this.subCommandResults.put(command.commandId(), firstReject);
                }
                this.setResult(firstReject);
            }
        }

        private void handleSnapshot(SignalCommand.SnapshotCommand snapshot) {
            assert (this.updatedNodes.isEmpty());
            assert (this.detachedNodes.isEmpty());
            this.updatedNodes.putAll(snapshot.nodes());
        }

        static {
            TreeManipulator.addConditionHandler(SignalCommand.ValueCondition.class, TreeManipulator::handleValueCondition);
            TreeManipulator.addConditionHandler(SignalCommand.PositionCondition.class, TreeManipulator::handlePositionCondition);
            TreeManipulator.addConditionHandler(SignalCommand.KeyCondition.class, TreeManipulator::handleKeyCondition);
            TreeManipulator.addConditionHandler(SignalCommand.LastUpdateCondition.class, TreeManipulator::handleLastUpdateCondition);
            TreeManipulator.addHandler(SignalCommand.AdoptAsCommand.class, TreeManipulator::handleAdoptAs);
            TreeManipulator.addHandler(SignalCommand.AdoptAtCommand.class, TreeManipulator::handleAdoptAt);
            TreeManipulator.addHandler(SignalCommand.IncrementCommand.class, TreeManipulator::handleIncrement);
            TreeManipulator.addHandler(SignalCommand.ClearCommand.class, TreeManipulator::handleClear);
            TreeManipulator.addHandler(SignalCommand.RemoveByKeyCommand.class, TreeManipulator::handleRemoveByKey);
            TreeManipulator.addHandler(SignalCommand.PutCommand.class, TreeManipulator::handlePut);
            TreeManipulator.addHandler(SignalCommand.PutIfAbsentCommand.class, TreeManipulator::handlePutIfAbsent);
            TreeManipulator.addHandler(SignalCommand.InsertCommand.class, TreeManipulator::handleInsert);
            TreeManipulator.addHandler(SignalCommand.SetCommand.class, TreeManipulator::handleSet);
            TreeManipulator.addHandler(SignalCommand.RemoveCommand.class, TreeManipulator::handleRemove);
            TreeManipulator.addHandler(SignalCommand.ClearOwnerCommand.class, TreeManipulator::handleClearOwner);
            TreeManipulator.addHandler(SignalCommand.TransactionCommand.class, TreeManipulator::handleTransaction);
            TreeManipulator.addHandler(SignalCommand.SnapshotCommand.class, TreeManipulator::handleSnapshot);
        }
    }

    @FunctionalInterface
    static interface ChildAttacher
    extends Serializable {
        public @Nullable Node.Data attach(Node.Data var1, Id var2);
    }
}

