/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.operations;

import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.jspecify.annotations.Nullable;

public class SignalOperation<T>
implements Serializable {
    private final CompletableFuture<ResultOrError<T>> result;

    public SignalOperation() {
        this.result = new CompletableFuture();
    }

    public SignalOperation(ResultOrError<T> resultOrError) {
        assert (resultOrError != null);
        this.result = CompletableFuture.completedFuture(resultOrError);
    }

    public CompletableFuture<ResultOrError<T>> result() {
        return this.result;
    }

    public <R> SignalOperation<R> map(SerializableFunction<T, R> mapper) {
        SignalOperation<T> mapped = new SignalOperation<T>();
        this.forwardMappedResult(mapped, mapper);
        return mapped;
    }

    protected <R> void forwardMappedResult(SignalOperation<R> target, SerializableFunction<T, R> mapper) {
        this.result.thenAccept(resultOrError -> {
            if (resultOrError.successful()) {
                @Nullable T value = ((Result)resultOrError).value();
                Object mapped = mapper.apply(value);
                target.result().complete(new Result(mapped));
            } else {
                target.result().complete(new Error(((Error)resultOrError).reason()));
            }
        });
    }

    public static sealed interface ResultOrError<T>
    extends Serializable
    permits Result, Error {
        public boolean successful();
    }

    public record Result<T>(@Nullable T value) implements ResultOrError<T>
    {
        @Override
        public boolean successful() {
            return true;
        }
    }

    public record Error<T>(String reason) implements ResultOrError<T>
    {
        @Override
        public boolean successful() {
            return false;
        }
    }
}

