/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.operations.TransactionOperation;
import com.vaadin.flow.signals.shared.impl.MutableTreeRevision;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.StagedTransaction;
import com.vaadin.flow.signals.shared.impl.TreeRevision;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public abstract class Transaction
implements Serializable {
    private static final Transaction ROOT = new DirectReadTransaction();
    private static final Transaction EXPLICITLY_NO_TRANSACTION = new DirectReadTransaction();
    private static final ThreadLocal<Transaction> currentTransaction = new ThreadLocal();
    private static volatile @Nullable SerializableSupplier<@Nullable Transaction> transactionFallback;

    public static void setTransactionFallback(@Nullable SerializableSupplier<@Nullable Transaction> fallback) {
        transactionFallback = fallback;
    }

    private static @Nullable Transaction getFallback() {
        SerializableSupplier<@Nullable Transaction> fallback = transactionFallback;
        return fallback != null ? (Transaction)fallback.get() : null;
    }

    public static Transaction getCurrent() {
        Transaction transaction = currentTransaction.get();
        if (transaction != null) {
            return transaction == EXPLICITLY_NO_TRANSACTION ? ROOT : transaction;
        }
        Transaction fallback = Transaction.getFallback();
        if (fallback != null) {
            return fallback;
        }
        return ROOT;
    }

    public static boolean inTransaction() {
        Transaction transaction = currentTransaction.get();
        if (transaction != null) {
            return transaction != EXPLICITLY_NO_TRANSACTION;
        }
        return Transaction.getFallback() != null;
    }

    public static boolean inExplicitTransaction() {
        Transaction transaction = currentTransaction.get();
        return transaction != null && transaction != EXPLICITLY_NO_TRANSACTION;
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask, Type.STAGED);
    }

    public static <T> TransactionOperation<T> runInTransaction(ValueSupplier<T> transactionTask, Type transactionType) {
        Transaction previousThreadLocal = currentTransaction.get();
        Transaction outer = Transaction.getCurrent();
        Transaction inner = transactionType.create(outer);
        currentTransaction.set(inner);
        try {
            T value = transactionTask.supply();
            TransactionOperation<T> op = new TransactionOperation<T>(value);
            inner.commit(op.result()::complete);
            TransactionOperation<T> transactionOperation = op;
            return transactionOperation;
        }
        catch (RuntimeException e) {
            inner.rollback();
            throw e;
        }
        finally {
            if (previousThreadLocal == null) {
                currentTransaction.remove();
            } else {
                currentTransaction.set(previousThreadLocal);
            }
        }
    }

    private static ValueSupplier<Void> asSupplier(TransactionTask task) {
        return () -> {
            task.execute();
            return null;
        };
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask, Type transactionType) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask), transactionType);
    }

    public static TransactionOperation<Void> runInTransaction(TransactionTask transactionTask) {
        return Transaction.runInTransaction(Transaction.asSupplier(transactionTask));
    }

    public static <T> T runWithoutTransaction(ValueSupplier<T> task) {
        Transaction previousTransaction = currentTransaction.get();
        try {
            currentTransaction.set(EXPLICITLY_NO_TRANSACTION);
            T t = task.supply();
            return t;
        }
        finally {
            if (previousTransaction == null) {
                currentTransaction.remove();
            } else {
                currentTransaction.set(previousTransaction);
            }
        }
    }

    public static void runWithoutTransaction(TransactionTask task) {
        Transaction.runWithoutTransaction(Transaction.asSupplier(task));
    }

    public static Transaction createWriteThrough() {
        return Type.WRITE_THROUGH.create(ROOT);
    }

    public abstract void include(SignalTree var1, SignalCommand var2,  @Nullable CommandsAndHandlers.CommandResultHandler var3, boolean var4);

    public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler) {
        this.include(tree, command, resultHandler, true);
    }

    public abstract TreeRevision read(SignalTree var1);

    protected abstract void commit(Consumer<SignalOperation.ResultOrError<Void>> var1);

    protected abstract void rollback();

    public static enum Type {
        STAGED{

            @Override
            Transaction create(Transaction outer) {
                return new StagedTransaction(outer);
            }
        }
        ,
        WRITE_THROUGH{

            @Override
            Transaction create(Transaction outer) {
                return new RepeatableReadTransaction(outer);
            }
        };


        abstract Transaction create(Transaction var1) throws IllegalStateException;
    }

    private static class DirectReadTransaction
    extends ImmediateTransaction {
        private DirectReadTransaction() {
        }

        @Override
        public TreeRevision read(SignalTree tree) {
            return tree.submitted();
        }
    }

    private static class RepeatableReadTransaction
    extends ImmediateTransaction {
        private final Map<SignalTree, MutableTreeRevision> trees = new HashMap<SignalTree, MutableTreeRevision>();
        private final Transaction outer;

        public RepeatableReadTransaction(Transaction outer) {
            assert (outer != null);
            this.outer = outer;
        }

        private MutableTreeRevision getOrCreateReadRevision(SignalTree tree) {
            return this.trees.computeIfAbsent(tree, newTree -> new MutableTreeRevision(this.outer.read((SignalTree)newTree)));
        }

        @Override
        public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler, boolean applyToTree) {
            this.getOrCreateReadRevision(tree).apply(command, null);
            super.include(tree, command, resultHandler, applyToTree);
            this.outer.include(tree, command, null, false);
        }

        @Override
        public TreeRevision read(SignalTree tree) {
            return this.getOrCreateReadRevision(tree);
        }
    }

    private static abstract class ImmediateTransaction
    extends Transaction {
        private ImmediateTransaction() {
        }

        @Override
        public void include(SignalTree tree, SignalCommand command,  @Nullable CommandsAndHandlers.CommandResultHandler resultHandler, boolean applyToTree) {
            if (applyToTree) {
                tree.commitSingleCommand(command, resultHandler);
            }
        }

        @Override
        protected void commit(Consumer<SignalOperation.ResultOrError<Void>> resultHandler) {
            resultHandler.accept(new SignalOperation.Result<Object>(null));
        }

        @Override
        protected void rollback() {
        }
    }
}

