/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.signals.Signal;

public interface HasStyle
extends HasElement {
    default public void addClassName(String className) {
        this.getClassNames().add(className);
    }

    default public boolean removeClassName(String className) {
        return this.getClassNames().remove(className);
    }

    default public void setClassName(String className) {
        if (className == null) {
            this.getElement().removeAttribute("class");
        } else {
            this.getElement().setAttribute("class", className);
        }
    }

    default public String getClassName() {
        return this.getElement().getAttribute("class");
    }

    default public ClassList getClassNames() {
        return this.getElement().getClassList();
    }

    default public void setClassName(String className, boolean set) {
        this.getClassNames().set(className, set);
    }

    default public boolean hasClassName(String className) {
        return this.getClassNames().contains(className);
    }

    default public Style getStyle() {
        return this.getElement().getStyle();
    }

    default public void addClassNames(String ... classNames) {
        for (String rawClassName : classNames) {
            String[] parts;
            if (rawClassName == null) {
                throw new IllegalArgumentException("CSS class names cannot include a null element");
            }
            if ((rawClassName = rawClassName.trim()).isEmpty()) {
                throw new IllegalArgumentException("CSS class names cannot include an empty class name");
            }
            for (String part : parts = rawClassName.split(" +")) {
                this.getClassNames().add(part);
            }
        }
    }

    default public void bindClassName(String className, Signal<Boolean> signal) {
        this.getClassNames().bind(className, signal);
    }

    default public void removeClassNames(String ... classNames) {
        for (String rawClassName : classNames) {
            String[] parts;
            if (rawClassName == null) {
                throw new IllegalArgumentException("CSS class names cannot include a null element");
            }
            if ((rawClassName = rawClassName.trim()).isEmpty()) {
                throw new IllegalArgumentException("CSS class names cannot include an empty class name");
            }
            for (String part : parts = rawClassName.split(" +")) {
                this.getClassNames().remove(part);
            }
        }
    }
}

