/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.operations.TransactionOperation;
import com.vaadin.flow.signals.shared.impl.AsynchronousSignalTreeTest;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlers;
import com.vaadin.flow.signals.shared.impl.CommandsAndHandlersTest;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import com.vaadin.flow.signals.shared.impl.StagedTransaction;
import com.vaadin.flow.signals.shared.impl.SynchronousSignalTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.StringNode;

public class StagedTransactionTest {
    @Test
    void resultCollector_unregisteredDependency_throws() {
        StagedTransaction.ResultCollector collector = new StagedTransaction.ResultCollector(List.of(new Object()), ignore -> {});
        Assertions.assertThrows(AssertionError.class, () -> collector.registerDependency(new Object()));
    }

    @Test
    void resultCollector_allOk_successfulResult() {
        Object d1 = new Object();
        Object d2 = new Object();
        Object d3 = new Object();
        AtomicReference resultHolder = new AtomicReference();
        StagedTransaction.ResultCollector collector = new StagedTransaction.ResultCollector(List.of(d1, d2, d3), resultHolder::set);
        CommandsAndHandlers.CommandResultHandler c2 = collector.registerDependency(d2);
        CommandsAndHandlers.CommandResultHandler c3 = collector.registerDependency(d3);
        c2.handle((CommandResult)CommandResult.ok());
        collector.registerDependency(d1).handle((CommandResult)CommandResult.ok());
        Assertions.assertNull(resultHolder.get());
        c3.handle((CommandResult)CommandResult.ok());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)resultHolder.get()).successful());
    }

    @Test
    void resultCollector_oneRejected_unsuccessfulResult() {
        Object d1 = new Object();
        Object d2 = new Object();
        Object d3 = new Object();
        AtomicReference resultHolder = new AtomicReference();
        StagedTransaction.ResultCollector collector = new StagedTransaction.ResultCollector(List.of(d1, d2, d3), resultHolder::set);
        CommandsAndHandlers.CommandResultHandler c2 = collector.registerDependency(d2);
        CommandsAndHandlers.CommandResultHandler c3 = collector.registerDependency(d3);
        c2.handle((CommandResult)CommandResult.ok());
        Assertions.assertNull(resultHolder.get());
        collector.registerDependency(d1).handle((CommandResult)CommandResult.fail((String)"reason"));
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)resultHolder.get()).successful());
        c3.handle((CommandResult)CommandResult.ok());
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)resultHolder.get()).successful(), (String)"Completing last dependency should not make the result successful");
    }

    @Test
    void resultCollector_resolveTwice_throws() {
        Object d1 = new Object();
        Object d2 = new Object();
        Object d3 = new Object();
        AtomicReference resultHolder = new AtomicReference();
        StagedTransaction.ResultCollector collector = new StagedTransaction.ResultCollector(List.of(d1, d2, d3), resultHolder::set);
        CommandsAndHandlers.CommandResultHandler c2 = collector.registerDependency(d2);
        c2.handle((CommandResult)CommandResult.ok());
        collector.registerDependency(d1).handle((CommandResult)CommandResult.ok());
        Assertions.assertThrows(AssertionError.class, () -> c2.handle((CommandResult)CommandResult.ok()));
    }

    @Test
    void transaction_goodThenFailingCommands_goodRevertedFromTransactionRead() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction tx = Transaction.getCurrent();
            tx.include((SignalTree)tree, TestUtil.writeRootValueCommand(), null);
            Assertions.assertNotNull((Object)((Node.Data)tx.read((SignalTree)tree).data(Id.ZERO).get()).value());
            tx.include((SignalTree)tree, TestUtil.failingCommand(), null);
            Assertions.assertNull((Object)((Node.Data)tx.read((SignalTree)tree).data(Id.ZERO).get()).value());
        });
    }

    @Test
    void commit_twoSyncTreesWithGoodCommands_changesApplied() throws InterruptedException, ExecutionException {
        SynchronousSignalTree t1 = new SynchronousSignalTree(false);
        SynchronousSignalTree t2 = new SynchronousSignalTree(false);
        CommandsAndHandlersTest.ResultHandler h1 = new CommandsAndHandlersTest.ResultHandler();
        CommandsAndHandlersTest.ResultHandler h2 = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction tx = Transaction.getCurrent();
            tx.include((SignalTree)t1, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)h1);
            tx.include((SignalTree)t2, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)h2);
            Assertions.assertNull((Object)h1.result);
            Assertions.assertNull((Object)h2.result);
        });
        Assertions.assertNotNull((Object)h1.result);
        Assertions.assertTrue((boolean)h1.result.accepted());
        Assertions.assertNotNull((Object)h2.result);
        Assertions.assertTrue((boolean)h2.result.accepted());
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)t1));
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)t2));
    }

    @Test
    void commit_twoSyncTreesWithOneBadCommand_noChangeApplied() throws InterruptedException, ExecutionException {
        SynchronousSignalTree t1 = new SynchronousSignalTree(false);
        SynchronousSignalTree t2 = new SynchronousSignalTree(false);
        CommandsAndHandlersTest.ResultHandler h1 = new CommandsAndHandlersTest.ResultHandler();
        CommandsAndHandlersTest.ResultHandler h2 = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction tx = Transaction.getCurrent();
            tx.include((SignalTree)t1, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)h1);
            tx.include((SignalTree)t2, TestUtil.failingCommand(), (CommandsAndHandlers.CommandResultHandler)h2);
            Assertions.assertNull((Object)TestUtil.readTransactionRootValue((SignalTree)t1), (String)"Reading should take expected failure into account");
            Assertions.assertNull((Object)h1.result);
            Assertions.assertNull((Object)h2.result);
        });
        Assertions.assertNotNull((Object)h1.result);
        Assertions.assertFalse((boolean)h1.result.accepted());
        Assertions.assertNotNull((Object)h2.result);
        Assertions.assertFalse((boolean)h2.result.accepted());
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertNull((Object)((Node.Data)t1.confirmed().data(Id.ZERO).get()).value());
        Assertions.assertNull((Object)((Node.Data)t2.confirmed().data(Id.ZERO).get()).value());
    }

    @Test
    void commit_asyncTreeWithGoodCommand_submittedOnCommitAndConfirmedWhenConfirmed() throws InterruptedException, ExecutionException {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        CommandsAndHandlersTest.ResultHandler handler = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)handler);
            Assertions.assertNull((Object)handler.result);
        });
        Assertions.assertNull((Object)handler.result);
        Assertions.assertFalse((boolean)operation.result().isDone());
        Assertions.assertNotNull((Object)((Node.Data)tree.submitted().data(Id.ZERO).get()).value());
        Assertions.assertNull((Object)((Node.Data)tree.confirmed().data(Id.ZERO).get()).value());
        tree.confirmSubmitted();
        Assertions.assertNotNull((Object)handler.result);
        Assertions.assertTrue((boolean)handler.result.accepted());
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertNotNull((Object)((Node.Data)tree.submitted().data(Id.ZERO).get()).value());
        Assertions.assertNotNull((Object)((Node.Data)tree.confirmed().data(Id.ZERO).get()).value());
    }

    @Test
    void commit_asyncTreeWithGoodAndBadCommands_nothingChanged() throws InterruptedException, ExecutionException {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        CommandsAndHandlersTest.ResultHandler h1 = new CommandsAndHandlersTest.ResultHandler();
        CommandsAndHandlersTest.ResultHandler h2 = new CommandsAndHandlersTest.ResultHandler();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction tx = Transaction.getCurrent();
            tx.include((SignalTree)tree, TestUtil.writeRootValueCommand(), (CommandsAndHandlers.CommandResultHandler)h1);
            tx.include((SignalTree)tree, TestUtil.failingCommand(), (CommandsAndHandlers.CommandResultHandler)h2);
            Assertions.assertNull((Object)h1.result);
            Assertions.assertNull((Object)h2.result);
        });
        Assertions.assertNull((Object)h1.result);
        Assertions.assertNull((Object)h2.result);
        Assertions.assertFalse((boolean)operation.result().isDone());
        Assertions.assertNull((Object)((Node.Data)tree.submitted().data(Id.ZERO).get()).value());
        Assertions.assertNull((Object)((Node.Data)tree.confirmed().data(Id.ZERO).get()).value());
        tree.confirmSubmitted();
        Assertions.assertNotNull((Object)h1.result);
        Assertions.assertFalse((boolean)h1.result.accepted());
        Assertions.assertFalse((boolean)h1.result.accepted());
        Assertions.assertTrue((boolean)operation.result().isDone());
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        Assertions.assertNull((Object)((Node.Data)tree.submitted().data(Id.ZERO).get()).value());
        Assertions.assertNull((Object)((Node.Data)tree.confirmed().data(Id.ZERO).get()).value());
    }

    @Test
    void commit_outerStagedTransaction_transactionCommandInOuter() {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        SignalCommand command = TestUtil.writeRootValueCommand();
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, command, null));
            Assertions.assertTrue((boolean)tree.submitted.isEmpty());
            Assertions.assertNotNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree));
        });
        Assertions.assertEquals((int)1, (int)tree.submitted.size());
        Assertions.assertEquals((int)1, (int)tree.submitted.get(0).size());
        Assertions.assertInstanceOf(SignalCommand.TransactionCommand.class, (Object)tree.submitted.get(0).get(0));
        SignalCommand.TransactionCommand outerTransaction = (SignalCommand.TransactionCommand)tree.submitted.get(0).get(0);
        Assertions.assertEquals((int)1, (int)outerTransaction.commands().size());
        Assertions.assertInstanceOf(SignalCommand.TransactionCommand.class, outerTransaction.commands().get(0));
        SignalCommand.TransactionCommand innerTransaction = (SignalCommand.TransactionCommand)outerTransaction.commands().get(0);
        Assertions.assertEquals(List.of(command), (Object)innerTransaction.commands());
    }

    @Test
    void commit_outerWriteThroughTransaction_immediatelyAppliedAndVisible() {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        SignalCommand command = TestUtil.writeRootValueCommand();
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, command, null));
            Assertions.assertEquals((int)1, (int)tree.submitted.size());
            Assertions.assertNotNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree));
        }, (Transaction.Type)Transaction.Type.WRITE_THROUGH);
    }

    @Test
    void commit_writeThroughInsideStaged_immediatelyAppliedAndVisible() {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        SignalCommand command = TestUtil.writeRootValueCommand();
        Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, command, null), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            Assertions.assertEquals((int)1, (int)tree.submitted.size());
            Assertions.assertNotNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree));
        });
    }

    @Test
    void commit_failingTransactionSavedBySyncWrite_seemsFailingButIsAccepted() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, (JsonNode)new StringNode("expected")), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
            tree.commitSingleCommand(TestUtil.writeRootValueCommand("expected"));
            Assertions.assertNull((Object)TestUtil.readTransactionRootValue((SignalTree)tree));
        });
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        JsonNode confirmedValue = TestUtil.readConfirmedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)confirmedValue);
        Assertions.assertEquals((Object)"update", (Object)confirmedValue.asString());
    }

    @Test
    void commit_failingTransactionSavedByNestedWriteThroughWrite_seemsFineAndIsAccepted() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, (JsonNode)new StringNode("expected")), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
            Assertions.assertNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("expected"), null), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            JsonNode transactionValue = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNotNull((Object)transactionValue);
            Assertions.assertEquals((Object)"update", (Object)transactionValue.asString(), (String)"Should take inner transaction changes into account");
        });
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        JsonNode confirmedValue = TestUtil.readConfirmedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)confirmedValue);
        Assertions.assertEquals((Object)"update", (Object)confirmedValue.asString());
    }

    @Test
    void commit_goodTransactionRuinedBySyncWrite_seemsFineButFails() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, null), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
            tree.commitSingleCommand(TestUtil.writeRootValueCommand("unexpected"));
            JsonNode transactionValue = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNotNull((Object)transactionValue);
            Assertions.assertEquals((Object)"update", (Object)transactionValue.asString());
        });
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        JsonNode confirmedValue = TestUtil.readConfirmedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)confirmedValue);
        Assertions.assertEquals((Object)"unexpected", (Object)confirmedValue.asString());
    }

    @Test
    void commit_goodTransactionRuinedByNestedWriteThroughWrite_seemsFailingAndFails() throws InterruptedException, ExecutionException {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, null), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("unexpected"), null), (Transaction.Type)Transaction.Type.WRITE_THROUGH);
            JsonNode transactionValue = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNotNull((Object)transactionValue);
            Assertions.assertEquals((Object)"unexpected", (Object)transactionValue.asString());
        });
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
        JsonNode confirmedValue = TestUtil.readConfirmedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)confirmedValue);
        Assertions.assertEquals((Object)"unexpected", (Object)confirmedValue.asString());
    }

    @Test
    void commit_failingTransactionSavedByAsyncConfirm_seemsFailingButIsAccepted() throws InterruptedException, ExecutionException {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, (JsonNode)new StringNode("expected")), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
        });
        Assertions.assertNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
        tree.confirm(List.of(TestUtil.writeRootValueCommand("expected")));
        JsonNode submittedValue = TestUtil.readSubmittedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)submittedValue);
        Assertions.assertEquals((Object)"update", (Object)submittedValue.asString());
        tree.confirmSubmitted();
        Assertions.assertTrue((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
    }

    @Test
    void commit_goodTransactionRuinedByAsyncConfirm_seemsFineButfails() throws InterruptedException, ExecutionException {
        AsynchronousSignalTreeTest.AsyncTestTree tree = new AsynchronousSignalTreeTest.AsyncTestTree();
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            Transaction.getCurrent().include((SignalTree)tree, (SignalCommand)new SignalCommand.ValueCondition(Id.random(), Id.ZERO, null), null);
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("update"), null);
        });
        JsonNode submittedValue = TestUtil.readSubmittedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)submittedValue);
        Assertions.assertEquals((Object)"update", (Object)submittedValue.asString());
        tree.confirm(List.of(TestUtil.writeRootValueCommand("unexpected")));
        JsonNode submittedValueAfterConfirm = TestUtil.readSubmittedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)submittedValueAfterConfirm);
        Assertions.assertEquals((Object)"unexpected", (Object)submittedValueAfterConfirm.asString());
        tree.confirmSubmitted();
        Assertions.assertFalse((boolean)((SignalOperation.ResultOrError)operation.result().get()).successful());
    }

    @Test
    void commit_treeWithoutChanges_resultResolved() {
        SynchronousSignalTree t1 = new SynchronousSignalTree(false);
        SynchronousSignalTree t2 = new SynchronousSignalTree(false);
        TransactionOperation operation = Transaction.runInTransaction((TransactionTask & Serializable)() -> {
            TestUtil.readTransactionRootValue((SignalTree)t1);
            Transaction.getCurrent().include((SignalTree)t2, TestUtil.writeRootValueCommand(), null);
        });
        TestUtil.assertSuccess(operation);
    }

    @Test
    void commit_readAndWriteInChangeHandler_bypassesTransaction() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        AtomicReference valueInObserver = new AtomicReference();
        tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
            Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("observer"), null);
            JsonNode transactionValue = TestUtil.readTransactionRootValue((SignalTree)tree);
            Assertions.assertNotNull((Object)transactionValue);
            String value = transactionValue.asString();
            valueInObserver.set(value);
            return false;
        });
        Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("tx"), null));
        Assertions.assertEquals((Object)"observer", valueInObserver.get());
        JsonNode confirmedValue = TestUtil.readConfirmedRootValue((SignalTree)tree);
        Assertions.assertNotNull((Object)confirmedValue);
        Assertions.assertEquals((Object)"observer", (Object)confirmedValue.asString());
    }

    @Test
    void treeMixing_multipleSyncAndComputed_allIsFine() {
        SynchronousSignalTree d1 = new SynchronousSignalTree(false);
        SynchronousSignalTree d2 = new SynchronousSignalTree(false);
        SynchronousSignalTree c1 = new SynchronousSignalTree(true);
        SynchronousSignalTree c2 = new SynchronousSignalTree(true);
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_multipleSyncAndComputed_allIsFine$e67f3f65$1((SignalTree)d1, (SignalTree)d2, (SignalTree)c1, (SignalTree)c2));
    }

    @Test
    void treeMixing_singleAsyncAndMultipleComputed_allIsFine() {
        AsynchronousSignalTreeTest.AsyncTestTree a1 = new AsynchronousSignalTreeTest.AsyncTestTree();
        SynchronousSignalTree c1 = new SynchronousSignalTree(true);
        SynchronousSignalTree c2 = new SynchronousSignalTree(true);
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_singleAsyncAndMultipleComputed_allIsFine$bb10c0d7$1((SignalTree)a1, (SignalTree)c1, (SignalTree)c2));
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_singleAsyncAndMultipleComputed_allIsFine$55820557$1((SignalTree)c1, (SignalTree)c2, (SignalTree)a1));
    }

    @Test
    void treeMixing_multipleAsync_throws() {
        AsynchronousSignalTreeTest.AsyncTestTree a1 = new AsynchronousSignalTreeTest.AsyncTestTree();
        AsynchronousSignalTreeTest.AsyncTestTree a2 = new AsynchronousSignalTreeTest.AsyncTestTree();
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_multipleAsync_throws$61eb7ea$1((SignalTree)a1, (SignalTree)a2));
    }

    @Test
    void treeMixing_asyncAndSync_throws() {
        AsynchronousSignalTreeTest.AsyncTestTree a1 = new AsynchronousSignalTreeTest.AsyncTestTree();
        SynchronousSignalTree d1 = new SynchronousSignalTree(false);
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_asyncAndSync_throws$61ec30e$1((SignalTree)a1, (SignalTree)d1));
        Transaction.runInTransaction(() -> StagedTransactionTest.lambda$treeMixing_asyncAndSync_throws$821bb78e$1((SignalTree)d1, (SignalTree)a1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void commit_withRepeatableReadFallback_changeObserverSeesUpdatedValue() {
        SynchronousSignalTree tree = new SynchronousSignalTree(false);
        Transaction fallback = Transaction.createWriteThrough();
        Transaction.setTransactionFallback((SerializableSupplier & Serializable)() -> fallback);
        try {
            AtomicReference valueInObserver = new AtomicReference();
            tree.observeNextChange(Id.ZERO, (TransientListener & Serializable)immediate -> {
                JsonNode transactionValue = TestUtil.readTransactionRootValue((SignalTree)tree);
                Assertions.assertNotNull((Object)transactionValue);
                valueInObserver.set(transactionValue);
                return false;
            });
            Transaction.runInTransaction((TransactionTask & Serializable)() -> Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand("updated"), null));
            Assertions.assertNotNull(valueInObserver.get(), (String)"Change observer should see updated value via outer transaction");
        }
        finally {
            Transaction.setTransactionFallback(null);
        }
    }

    @Test
    void commitLocking_multipleTrees_lockOrderConsistent() {
        class LockOrderTree
        extends SynchronousSignalTree {
            static Set<LockOrderTree> lockedTrees = new HashSet<LockOrderTree>();
            private Set<LockOrderTree> previouslyLocked;
            private ReentrantLock lockSpy;

            public LockOrderTree() {
                super(false);
                this.previouslyLocked = new HashSet<LockOrderTree>();
                this.lockSpy = new ReentrantLock(){

                    @Override
                    public void lock() {
                        super.lock();
                        previouslyLocked.addAll(lockedTrees);
                        lockedTrees.add(this);
                    }

                    @Override
                    public void unlock() {
                        lockedTrees.remove((Object)this);
                        super.unlock();
                    }
                };
            }

            public ReentrantLock getLock() {
                return this.lockSpy;
            }

            protected boolean hasLock() {
                return this.lockSpy.isHeldByCurrentThread();
            }
        }
        List trees = Stream.generate(() -> new LockOrderTree()).limit(10L).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < 10; ++i) {
            Collections.shuffle(trees);
            Transaction.runInTransaction((TransactionTask & Serializable)() -> {
                for (LockOrderTree tree : trees) {
                    Transaction.getCurrent().include((SignalTree)tree, TestUtil.writeRootValueCommand(), null);
                }
            });
        }
        for (LockOrderTree tree : trees) {
            for (LockOrderTree previous : tree.previouslyLocked) {
                Assertions.assertFalse((boolean)previous.previouslyLocked.contains((Object)tree));
            }
        }
    }

    private static /* synthetic */ void lambda$treeMixing_asyncAndSync_throws$821bb78e$1(SignalTree d1, SignalTree a1) {
        TestUtil.readTransactionRootValue(d1);
        Assertions.assertThrows(IllegalStateException.class, () -> TestUtil.readTransactionRootValue(a1));
    }

    private static /* synthetic */ void lambda$treeMixing_asyncAndSync_throws$61ec30e$1(SignalTree a1, SignalTree d1) {
        TestUtil.readTransactionRootValue(a1);
        Assertions.assertThrows(IllegalStateException.class, () -> TestUtil.readTransactionRootValue(d1));
    }

    private static /* synthetic */ void lambda$treeMixing_multipleAsync_throws$61eb7ea$1(SignalTree a1, SignalTree a2) {
        TestUtil.readTransactionRootValue(a1);
        Assertions.assertThrows(IllegalStateException.class, () -> TestUtil.readTransactionRootValue(a2));
    }

    private static /* synthetic */ void lambda$treeMixing_singleAsyncAndMultipleComputed_allIsFine$55820557$1(SignalTree c1, SignalTree c2, SignalTree a1) {
        TestUtil.readTransactionRootValue(c1);
        TestUtil.readTransactionRootValue(c2);
        TestUtil.readTransactionRootValue(a1);
    }

    private static /* synthetic */ void lambda$treeMixing_singleAsyncAndMultipleComputed_allIsFine$bb10c0d7$1(SignalTree a1, SignalTree c1, SignalTree c2) {
        TestUtil.readTransactionRootValue(a1);
        TestUtil.readTransactionRootValue(c1);
        TestUtil.readTransactionRootValue(c2);
    }

    private static /* synthetic */ void lambda$treeMixing_multipleSyncAndComputed_allIsFine$e67f3f65$1(SignalTree d1, SignalTree d2, SignalTree c1, SignalTree c2) {
        TestUtil.readTransactionRootValue(d1);
        TestUtil.readTransactionRootValue(d2);
        TestUtil.readTransactionRootValue(c1);
        TestUtil.readTransactionRootValue(c2);
    }
}

