/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared.impl;

import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.LocalAsynchronousSignalTree;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalAsynchronousSignalTreeTest
extends SignalTestBase {
    @Test
    void type_isAsynchronous() {
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        Assertions.assertEquals((Object)SignalTree.Type.ASYNCHRONOUS, (Object)tree.type());
    }

    @Test
    void submit_singleCommand_immediatelyConfirmed() {
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        AtomicReference result = new AtomicReference();
        SignalCommand command = TestUtil.writeRootValueCommand();
        tree.commitSingleCommand(command, result::set);
        Assertions.assertTrue((boolean)((CommandResult)result.get()).accepted());
    }

    @Test
    void submitted_afterCommand_immediatelyUpdated() {
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        tree.commitSingleCommand(TestUtil.writeRootValueCommand());
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
    }

    @Test
    void confirmed_afterCommand_immediatelyUpdated() {
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        tree.commitSingleCommand(TestUtil.writeRootValueCommand());
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }

    @Test
    void multipleCommands_allImmediatelyConfirmed() {
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        for (int i = 0; i < 3; ++i) {
            AtomicReference result = new AtomicReference();
            tree.commitSingleCommand(TestUtil.writeRootValueCommand("value" + i), result::set);
            Assertions.assertTrue((boolean)((CommandResult)result.get()).accepted());
        }
    }

    @Test
    void submit_withAsyncDispatcher_confirmedOnlyAfterDispatch() {
        SignalTestBase.TestExecutor dispatcher = this.useTestEffectDispatcher();
        LocalAsynchronousSignalTree tree = new LocalAsynchronousSignalTree();
        tree.commitSingleCommand(TestUtil.writeRootValueCommand());
        Assertions.assertNotNull((Object)TestUtil.readSubmittedRootValue((SignalTree)tree));
        Assertions.assertNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
        dispatcher.runPendingTasks();
        Assertions.assertNotNull((Object)TestUtil.readConfirmedRootValue((SignalTree)tree));
    }
}

