/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedValueSignalNullabilityTest
extends SignalTestBase {
    @Test
    void get_returnsNullable() {
        SharedValueSignal signal = new SharedValueSignal((Object)"hello");
        @Nullable String value = (String)signal.peek();
        if (value != null) {
            Assertions.assertEquals((int)5, (int)value.length());
        }
    }

    @Test
    void set_nonNull_requiresNonNull() {
        SharedValueSignal signal = new SharedValueSignal((Object)"hello");
        signal.set((Object)"world");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void set_nullable_acceptsNull() {
        @Nullable SharedValueSignal signal = new SharedValueSignal(String.class);
        signal.set(null);
        Assertions.assertNull((Object)signal.peek());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void replace_nullable_acceptsNull() {
        @Nullable SharedValueSignal signal = new SharedValueSignal(String.class);
        signal.set((Object)"hello");
        signal.replace(null, (Object)"world");
        signal.replace((Object)"world", null);
    }
}

