/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.local.ValueSignal;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ValueSignalNullabilityTest
extends SignalTestBase {
    @Test
    void get_returnsNullable() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        @Nullable String value = (String)signal.peek();
        if (value != null) {
            Assertions.assertEquals((int)5, (int)value.length());
        }
    }

    @Test
    void set_nonNull_requiresNonNull() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        signal.set((Object)"world");
        Assertions.assertEquals((Object)"world", (Object)signal.peek());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void set_nullable_acceptsNull() {
        @Nullable ValueSignal signal = new ValueSignal((Object)"hello");
        signal.set(null);
        Assertions.assertNull((Object)signal.peek());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void replace_nullable_acceptsNull() {
        @Nullable ValueSignal signal = new ValueSignal((Object)"hello");
        signal.replace(null, (Object)"world");
        signal.replace((Object)"world", null);
    }
}

