/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.local.AbstractLocalSignal;
import com.vaadin.flow.signals.local.ListSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListSignalTest
extends SignalTestBase {
    @Test
    void constructor_empty_emptyList() {
        ListSignal signal = new ListSignal();
        List value = signal.peek();
        Assertions.assertTrue((boolean)value.isEmpty());
    }

    @Test
    void insertFirst_singleValue_valueAtStart() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertFirst((Object)"first");
        Assertions.assertEquals((Object)"first", (Object)entry.peek());
        ListSignalTest.assertValues((ListSignal<String>)signal, "first");
    }

    @Test
    void insertFirst_twoValues_insertedInOrder() {
        ListSignal signal = new ListSignal();
        signal.insertFirst((Object)"a");
        signal.insertFirst((Object)"b");
        ListSignalTest.assertValues((ListSignal<String>)signal, "b", "a");
    }

    @Test
    void insertLast_singleValue_valueAtEnd() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertLast((Object)"last");
        Assertions.assertEquals((Object)"last", (Object)entry.peek());
        ListSignalTest.assertValues((ListSignal<String>)signal, "last");
    }

    @Test
    void insertLast_twoValues_insertedInOrder() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"a");
        signal.insertLast((Object)"b");
        ListSignalTest.assertValues((ListSignal<String>)signal, "a", "b");
    }

    @Test
    void insertAt_validIndex_valueInserted() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"first");
        signal.insertLast((Object)"last");
        ValueSignal entry = signal.insertAt(1, (Object)"middle");
        Assertions.assertEquals((Object)"middle", (Object)entry.peek());
        ListSignalTest.assertValues((ListSignal<String>)signal, "first", "middle", "last");
    }

    @Test
    void insertAt_atZero_valueInsertedAtStart() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"existing");
        signal.insertAt(0, (Object)"first");
        ListSignalTest.assertValues((ListSignal<String>)signal, "first", "existing");
    }

    @Test
    void insertAt_atEnd_valueInsertedAtEnd() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"existing");
        signal.insertAt(1, (Object)"last");
        ListSignalTest.assertValues((ListSignal<String>)signal, "existing", "last");
    }

    @Test
    void insertAt_negativeIndex_throwsException() {
        ListSignal signal = new ListSignal();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> signal.insertAt(-1, (Object)"value"));
    }

    @Test
    void insertAt_indexTooLarge_throwsException() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"existing");
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> signal.insertAt(2, (Object)"value"));
    }

    @Test
    void insert_returnsEntrySignal() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertLast((Object)"value");
        Assertions.assertEquals((Object)"value", (Object)entry.peek());
        entry.set((Object)"updated");
        Assertions.assertEquals((Object)"updated", (Object)entry.peek());
    }

    @Test
    void remove_existingEntry_entryRemoved() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"first");
        ValueSignal toRemove = signal.insertLast((Object)"second");
        signal.insertLast((Object)"third");
        signal.remove(toRemove);
        ListSignalTest.assertValues((ListSignal<String>)signal, "first", "third");
    }

    @Test
    void remove_nonExistentEntry_noChange() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        ValueSignal other = new ValueSignal((Object)"other");
        signal.remove(other);
        ListSignalTest.assertValues((ListSignal<String>)signal, "value");
    }

    @Test
    void clear_listWithEntries_listCleared() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"a");
        signal.insertLast((Object)"b");
        signal.insertLast((Object)"c");
        signal.clear();
        Assertions.assertTrue((boolean)signal.peek().isEmpty());
    }

    @Test
    void value_returnsImmutableList() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        List value = signal.peek();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.add(new ValueSignal((Object)"new")));
    }

    @Test
    void peek_returnsValueWithoutTracking() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.peek());
        Assertions.assertSame((Object)UsageTracker.NO_USAGE, (Object)usage);
    }

    @Test
    void value_changeAfterSnapshot_snapshotUnchanged() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"first");
        List snapshot = signal.peek();
        signal.insertFirst((Object)"second");
        Assertions.assertEquals((int)1, (int)snapshot.size());
        Assertions.assertEquals((Object)"first", (Object)((ValueSignal)snapshot.get(0)).peek());
    }

    @Test
    void modifyEntry_onlyThatEntryNotified() {
        ListSignal signal = new ListSignal();
        ValueSignal entry1 = signal.insertLast((Object)"a");
        ValueSignal entry2 = signal.insertLast((Object)"b");
        AtomicBoolean entry1Changed = new AtomicBoolean(false);
        AtomicBoolean entry2Changed = new AtomicBoolean(false);
        AtomicBoolean listChanged = new AtomicBoolean(false);
        UsageTracker.Usage usage1 = UsageTracker.track(() -> ((ValueSignal)entry1).get());
        UsageTracker.Usage usage2 = UsageTracker.track(() -> ((ValueSignal)entry2).get());
        UsageTracker.Usage listUsage = UsageTracker.track(() -> ((ListSignal)signal).get());
        usage1.onNextChange((TransientListener & Serializable)initial -> {
            entry1Changed.set(true);
            return false;
        });
        usage2.onNextChange((TransientListener & Serializable)initial -> {
            entry2Changed.set(true);
            return false;
        });
        listUsage.onNextChange((TransientListener & Serializable)initial -> {
            listChanged.set(true);
            return false;
        });
        entry1.set((Object)"updated");
        Assertions.assertTrue((boolean)entry1Changed.get());
        Assertions.assertFalse((boolean)entry2Changed.get());
        Assertions.assertFalse((boolean)listChanged.get());
    }

    @Test
    void usageTracker_insertValue_changeDetected() {
        ListSignal signal = new ListSignal();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        Assertions.assertFalse((boolean)usage.hasChanges());
        AtomicBoolean invoked = new AtomicBoolean(false);
        usage.onNextChange((TransientListener & Serializable)initial -> {
            Assertions.assertFalse((boolean)initial);
            invoked.set(true);
            return false;
        });
        signal.insertLast((Object)"value");
        Assertions.assertTrue((boolean)usage.hasChanges());
        Assertions.assertTrue((boolean)invoked.get());
    }

    @Test
    void usageTracker_removeValue_changeDetected() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertLast((Object)"value");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.remove(entry);
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void usageTracker_clear_changeDetected() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.clear();
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void usageTracker_modifyEntry_listNotChanged() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertLast((Object)"value");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        entry.set((Object)"updated");
        Assertions.assertFalse((boolean)usage.hasChanges());
    }

    @Test
    void usageTracker_peek_noUsageDetected() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.peek());
        Assertions.assertSame((Object)UsageTracker.NO_USAGE, (Object)usage);
    }

    @Test
    void usageTracker_listener_keepListening() {
        ListSignal signal = new ListSignal();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.insertLast((Object)"update1");
        AtomicInteger count = new AtomicInteger();
        usage.onNextChange((TransientListener & Serializable)ignore -> {
            count.incrementAndGet();
            return true;
        });
        signal.insertLast((Object)"update2");
        Assertions.assertEquals((int)2, (int)count.get());
        signal.insertLast((Object)"update3");
        Assertions.assertEquals((int)3, (int)count.get());
    }

    @Test
    void usageTracker_listener_stopAfterFirst() {
        ListSignal signal = new ListSignal();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.insertLast((Object)"update1");
        AtomicInteger count = new AtomicInteger();
        usage.onNextChange((TransientListener & Serializable)ignore -> {
            count.incrementAndGet();
            return false;
        });
        Assertions.assertEquals((int)1, (int)count.intValue());
        signal.insertLast((Object)"update2");
        Assertions.assertEquals((int)1, (int)count.intValue());
    }

    @Test
    void toString_includesValue() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"one");
        signal.insertLast((Object)"two");
        Assertions.assertEquals((Object)"ListSignal[one, two]", (Object)signal.toString());
    }

    @Test
    void get_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.get()));
    }

    @Test
    void peek_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.peek()));
    }

    @Test
    void insertFirst_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.insertFirst((Object)"value")));
    }

    @Test
    void insertLast_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.insertLast((Object)"value")));
    }

    @Test
    void insertAt_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.insertAt(0, (Object)"value")));
    }

    @Test
    void remove_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        ValueSignal entry = signal.insertLast((Object)"value");
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.remove(entry)));
    }

    @Test
    void clear_insideExplicitTransaction_throwsException() {
        ListSignal signal = new ListSignal();
        signal.insertLast((Object)"value");
        Assertions.assertThrows(IllegalStateException.class, () -> Transaction.runInTransaction((TransactionTask & Serializable)() -> signal.clear()));
    }

    private static void assertValues(ListSignal<String> signal, String ... expectedValues) {
        List<String> values = signal.peek().stream().map(AbstractLocalSignal::peek).toList();
        Assertions.assertEquals(List.of(expectedValues), values);
    }
}

