/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.impl;

import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.function.SignalComputation;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ComputedSignalNullabilityTest
extends SignalTestBase {
    @Test
    void map_returnsNullable() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        Signal mapped = signal.map(String::length);
        @Nullable Integer length = (Integer)mapped.peek();
        if (length != null) {
            Assertions.assertEquals((int)5, (int)length);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    void map_nonNullToNullable_resultIsNullable() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        @Nullable Signal mapped = signal.map((SignalMapper & Serializable)s -> s.isEmpty() ? null : s);
        @Nullable String value = (String)mapped.peek();
        if (value != null) {
            Assertions.assertEquals((Object)"hello", (Object)value);
        }
    }

    @Test
    void computed_returnsNullable() {
        ValueSignal signal = new ValueSignal((Object)"hello");
        Signal computed = Signal.computed((SignalComputation & Serializable)() -> {
            @Nullable String value = (String)signal.get();
            return value != null ? value.length() : 0;
        });
        @Nullable Integer length = (Integer)computed.peek();
        if (length != null) {
            Assertions.assertEquals((int)5, (int)length);
        }
    }

    @Test
    void not_returnsNullable() {
        ValueSignal signal = new ValueSignal((Object)true);
        Signal negated = Signal.not((Signal)signal);
        @Nullable Boolean value = (Boolean)negated.peek();
        if (value != null) {
            Assertions.assertFalse((boolean)value);
        }
    }
}

