/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SignalUtils;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.util.concurrent.ExecutionException;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.StringNode;

public class TestUtil {
    public static SignalCommand writeRootValueCommand(String value) {
        return new SignalCommand.SetCommand(Id.random(), Id.ZERO, (JsonNode)new StringNode(value));
    }

    public static SignalCommand writeRootValueCommand() {
        return TestUtil.writeRootValueCommand("value");
    }

    public static SignalCommand failingCommand() {
        return new SignalCommand.SetCommand(Id.random(), Id.random(), null);
    }

    public static @Nullable JsonNode readConfirmedRootValue(SignalTree tree) {
        return ((Node.Data)tree.confirmed().data(Id.ZERO).get()).value();
    }

    public static @Nullable JsonNode readSubmittedRootValue(SignalTree tree) {
        return ((Node.Data)tree.submitted().data(Id.ZERO).get()).value();
    }

    public static @Nullable JsonNode readTransactionRootValue(SignalTree tree) {
        return ((Node.Data)Transaction.getCurrent().read(tree).data(Id.ZERO).get()).value();
    }

    public static <T> T assertSuccess(SignalOperation<T> operation) {
        SignalOperation.ResultOrError<T> resultOrError = TestUtil.assertCompleted(operation);
        if (resultOrError instanceof SignalOperation.Result) {
            SignalOperation.Result result = (SignalOperation.Result)resultOrError;
            return (T)result.value();
        }
        throw new AssertionError();
    }

    public static void assertFailure(SignalOperation<?> operation) {
        SignalOperation.ResultOrError<?> resultOrError = TestUtil.assertCompleted(operation);
        Assertions.assertFalse((boolean)resultOrError.successful());
    }

    private static <T> SignalOperation.ResultOrError<T> assertCompleted(SignalOperation<T> operation) {
        Assertions.assertTrue((boolean)operation.result().isDone());
        try {
            return (SignalOperation.ResultOrError)operation.result().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static SignalTree tree(AbstractSignal<?> signal) {
        return SignalUtils.treeOf(signal);
    }
}

