/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals;

import com.vaadin.flow.signals.SignalEnvironment;
import com.vaadin.flow.signals.local.ValueSignal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class SignalTestBase {
    private static final ThreadLocal<Executor> currentResultNotifier = new ThreadLocal();
    private static final ThreadLocal<Executor> currentEffectDispatcher = new ThreadLocal();
    private final List<Throwable> uncaughtExceptions = new ArrayList<Throwable>();
    private static Runnable environmentRegistration;

    @BeforeAll
    static void setupEnvironment() {
        environmentRegistration = SignalEnvironment.register((SignalEnvironment)new SignalEnvironment(){

            public boolean isActive() {
                return true;
            }

            public Executor getResultNotifier() {
                return currentResultNotifier.get();
            }

            public Executor getEffectDispatcher() {
                return currentEffectDispatcher.get();
            }
        });
    }

    @AfterAll
    static void closeEnvironment() {
        environmentRegistration.run();
    }

    protected TestExecutor useTestResultNotifier() {
        TestExecutor dispatcher = new TestExecutor(this);
        currentResultNotifier.set(dispatcher);
        return dispatcher;
    }

    protected static ValueSignal<Integer> createDependency() {
        return new ValueSignal((Object)0);
    }

    protected TestExecutor useTestEffectDispatcher() {
        TestExecutor dispatcher = new TestExecutor(this);
        currentEffectDispatcher.set(dispatcher);
        return dispatcher;
    }

    protected void assertNoUncaughtException() {
        Assertions.assertEquals(List.of(), this.uncaughtExceptions);
    }

    protected void assertUncaughtException(Throwable exception) {
        this.assertUncaughtException((Throwable lastCaught) -> lastCaught == exception);
    }

    protected void assertUncaughtException(Class<? extends Throwable> expectedType) {
        this.assertUncaughtException(expectedType::isInstance);
    }

    protected void assertUncaughtException(Predicate<Throwable> predicate) {
        Assertions.assertFalse((boolean)this.uncaughtExceptions.isEmpty());
        int lastIndex = this.uncaughtExceptions.size() - 1;
        Throwable lastUncaught = this.uncaughtExceptions.get(lastIndex);
        if (predicate.test(lastUncaught)) {
            this.uncaughtExceptions.remove(lastIndex);
        } else {
            Assertions.fail((String)("Last uncaught exception did not pass test: " + String.valueOf(lastUncaught)));
        }
    }

    @BeforeEach
    void setupExceptionHandler() {
        Thread currentThread = Thread.currentThread();
        Assertions.assertSame((Object)currentThread.getUncaughtExceptionHandler(), (Object)currentThread.getThreadGroup(), (String)"Adjustments are needed if a non-standard exception handler is present");
        currentThread.setUncaughtExceptionHandler((thread, throwable) -> {
            Throwable patt0$temp = throwable.getCause();
            if (patt0$temp instanceof AssertionError) {
                AssertionError ae = (AssertionError)((Object)patt0$temp);
                throw ae;
            }
            this.uncaughtExceptions.add(throwable);
        });
    }

    @AfterEach
    void clear() {
        Thread.currentThread().setUncaughtExceptionHandler(null);
        Assertions.assertEquals(List.of(), this.uncaughtExceptions, (String)"Exceptions passed to the uncaught exception handler have not been asserted");
        currentResultNotifier.remove();
        currentEffectDispatcher.remove();
    }

    protected class TestExecutor
    implements Executor {
        private final ArrayList<Runnable> tasks = new ArrayList();

        protected TestExecutor(SignalTestBase this$0) {
        }

        @Override
        public void execute(Runnable task) {
            this.tasks.add(task);
        }

        public int countPendingTasks() {
            return this.tasks.size();
        }

        public int runPendingTasks() {
            List<Runnable> pending = List.copyOf(this.tasks);
            this.tasks.clear();
            pending.forEach(Runnable::run);
            return pending.size();
        }
    }
}

