/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.UIInternals;
import com.vaadin.flow.di.DefaultInstantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.MockServletContext;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinSession;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.menu.MenuConfiguration;
import com.vaadin.flow.server.menu.MenuEntry;
import com.vaadin.flow.server.menu.MenuRegistryTest;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@NotThreadSafe
class MenuConfigurationTest {
    @TempDir
    Path tmpDir;
    private ApplicationRouteRegistry registry;
    @Mock
    private MenuRegistryTest.MockService vaadinService;
    private VaadinSession session;
    private ServletContext servletContext;
    private VaadinServletContext vaadinContext;
    @Mock
    private DeploymentConfiguration deploymentConfiguration;
    @Mock
    private VaadinRequest request;
    private AutoCloseable closeable;
    public static String testPageHeaderClientRouteFile = "[\n  {\n    \"route\": \"\",\n    \"params\": {},\n    \"title\": \"Layout\",\n    \"children\": [\n      {\n        \"route\": \"\",\n        \"params\": {},\n        \"title\": \"Public\"\n      },\n      {\n        \"route\": \"about\",\n        \"menu\": { \"exclude\": true },\n        \"title\": \"About\"\n      },\n      {\n        \"route\": \"other\",\n        \"menu\": { \"title\": \"Other\" },\n        \"title\": \"Other\"\n      },\n      {\n        \"route\": \"hilla\",\n        \"title\": \"Hilla\",\n        \"flowLayout\": false\n      }\n    ]\n  },\n  {\n    \"route\": \"flow\",\n    \"params\": {},\n    \"children\": [\n      {\n        \"route\": \"hello\",\n        \"menu\": {\n          \"title\": \"Hello For Flow Layout\"\n        },\n        \"title\": \"Hello\"\n      }\n    ]\n  }\n]\n";

    MenuConfigurationTest() {
    }

    @BeforeEach
    public void init() {
        this.closeable = MockitoAnnotations.openMocks((Object)this);
        this.servletContext = new MockServletContext();
        this.vaadinContext = new MockVaadinContext(this.servletContext);
        this.registry = ApplicationRouteRegistry.getInstance((VaadinContext)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getRouteRegistry()).thenReturn((Object)this.registry);
        Mockito.when((Object)this.vaadinService.getContext()).thenReturn((Object)this.vaadinContext);
        Mockito.when((Object)this.vaadinService.getInstantiator()).thenReturn((Object)new DefaultInstantiator((VaadinService)this.vaadinService));
        Mockito.when((Object)this.vaadinService.getDeploymentConfiguration()).thenReturn((Object)this.deploymentConfiguration);
        Mockito.when((Object)this.deploymentConfiguration.getFrontendFolder()).thenReturn((Object)this.tmpDir.toFile());
        Mockito.when((Object)this.deploymentConfiguration.getProjectFolder()).thenReturn((Object)this.tmpDir.toFile());
        Mockito.when((Object)this.deploymentConfiguration.getBuildFolder()).thenReturn((Object)"build");
        VaadinService.setCurrent((VaadinService)this.vaadinService);
        this.session = new MockVaadinSession((VaadinService)this.vaadinService){

            public VaadinService getService() {
                return MenuConfigurationTest.this.vaadinService;
            }
        };
        VaadinSession.setCurrent((VaadinSession)this.session);
        Mockito.when((Object)this.request.getService()).thenReturn((Object)this.vaadinService);
        CurrentInstance.set(VaadinRequest.class, (Object)this.request);
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.closeable.close();
        CurrentInstance.clearAll();
    }

    @Test
    public void testWithLoggedInUser_userHasRoles() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)true);
        File generated = Files.createDirectories(this.tmpDir.resolve("generated/"), new FileAttribute[0]).toFile();
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)MenuRegistryTest.testClientRouteFile, new OpenOption[0]);
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assertions.assertEquals((int)7, (int)menuEntries.size(), (String)"List of menu items has incorrect size. Excluded menu item like /login is not expected.");
        this.assertOrder(menuEntries, new String[]{"/", "/about", "/hilla", "/hilla/sub", "/opt_params", "/params_with_opt_children", "/wc_params"});
    }

    @Test
    public void getMenuItemsList_returnsCorrectPaths() throws IOException {
        File generated = Files.createDirectories(this.tmpDir.resolve("generated/"), new FileAttribute[0]).toFile();
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)MenuRegistryTest.testClientRouteFile, new OpenOption[0]);
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MenuRegistryTest.MyRoute.class, MenuRegistryTest.MyInfo.class, MenuRegistryTest.MyRequiredParamRoute.class, MenuRegistryTest.MyRequiredAndOptionalParamRoute.class, MenuRegistryTest.MyOptionalParamRoute.class, MenuRegistryTest.MyVarargsParamRoute.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assertions.assertEquals((int)8, (int)menuEntries.size());
        this.assertOrder(menuEntries, new String[]{"/", "/home", "/info", "/opt_params", "/param", "/param/varargs", "/params_with_opt_children", "/wc_params"});
        Map<String, MenuEntry> mapMenuItems = menuEntries.stream().collect(Collectors.toMap(MenuEntry::path, item -> item));
        this.assertClientRoutes(mapMenuItems, false, false);
        this.assertServerRoutes(mapMenuItems);
        this.assertServerRoutesWithParameters(mapMenuItems, true);
    }

    @Test
    public void getMenuItemsList_assertOrder() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(MenuRegistryTest.TestRouteA.class, MenuRegistryTest.TestRouteB.class, MenuRegistryTest.TestRouteC.class, MenuRegistryTest.TestRouteD.class, MenuRegistryTest.TestRouteDA.class, MenuRegistryTest.TestRouteDB.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        List menuEntries = MenuConfiguration.getMenuEntries();
        Assertions.assertEquals((int)4, (int)menuEntries.size());
        this.assertOrder(menuEntries, new String[]{"/d", "/c", "/a", "/b", "/d/a", "/d/b"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getPageHeader_serverSideRoutes_withContentComponent_pageHeadersFromAnnotationAndName() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(NormalRoute.class, NormalRouteWithPageTitle.class, MandatoryParameterRouteWithPageTitle.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/normal-route");
            Optional header = MenuConfiguration.getPageHeader((Component)new NormalRoute());
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"NormalRoute", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"normal-route-with-page-title");
            header = MenuConfiguration.getPageHeader((Component)new NormalRouteWithPageTitle());
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"My Normal Route", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(List.of(new RouteOrLayoutWithDynamicTitle()));
            header = MenuConfiguration.getPageHeader((Component)new NormalRoute());
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"My Route with dynamic title", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"mandatory-parameter-route");
            header = MenuConfiguration.getPageHeader((Component)new MandatoryParameterRouteWithPageTitle());
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"MandatoryParameterRouteWithPageTitle", header.get());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getPageHeader_serverSideRoutes_noContentComponent_pageHeadersOnlyForMenuEntries() {
        RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry((RouteRegistry)this.registry);
        Arrays.asList(NormalRoute.class, NormalRouteWithPageTitle.class, OptionalParameterRouteWithPageTitle.class, MandatoryParameterRouteWithPageTitle.class).forEach(arg_0 -> ((RouteConfiguration)routeConfiguration).setAnnotatedRoute(arg_0));
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/normal-route");
            Optional header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"NormalRoute", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"normal-route-with-page-title");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertFalse((boolean)header.isPresent());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"mandatory-parameter-route");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertFalse((boolean)header.isPresent());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"optional-parameter-route");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"OptionalParameterRouteWithPageTitle", header.get());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetPageHeader_clientViews_pageHeaderFromTitle() throws IOException {
        Mockito.when((Object)this.request.getUserPrincipal()).thenReturn((Object)((Principal)Mockito.mock(Principal.class)));
        Mockito.when((Object)this.request.isUserInRole(Mockito.anyString())).thenReturn((Object)true);
        File generated = Files.createDirectories(this.tmpDir.resolve("generated/"), new FileAttribute[0]).toFile();
        File clientFiles = new File(generated, "file-routes.json");
        Files.writeString(clientFiles.toPath(), (CharSequence)testPageHeaderClientRouteFile, new OpenOption[0]);
        UI mockUi = (UI)Mockito.mock(UI.class);
        UIInternals uiInternals = (UIInternals)Mockito.mock(UIInternals.class);
        Location location = (Location)Mockito.mock(Location.class);
        Mockito.when((Object)mockUi.getInternals()).thenReturn((Object)uiInternals);
        Mockito.when((Object)uiInternals.getActiveViewLocation()).thenReturn((Object)location);
        UI currentUi = UI.getCurrent();
        try {
            UI.setCurrent((UI)mockUi);
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/");
            Optional header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"Public", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/about");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"About", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/other");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"Other", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/hilla");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"Hilla", header.get());
            Mockito.when((Object)location.getPath()).thenReturn((Object)"/flow/hello");
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"Hello", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(List.of(new RouteOrLayoutWithDynamicTitle()));
            header = MenuConfiguration.getPageHeader();
            Assertions.assertTrue((boolean)header.isPresent());
            Assertions.assertEquals((Object)"My Route with dynamic title", header.get());
            Mockito.when((Object)uiInternals.getActiveRouterTargetsChain()).thenReturn(Collections.emptyList());
        }
        finally {
            UI.setCurrent((UI)currentUi);
        }
    }

    private void assertOrder(List<MenuEntry> menuEntries, String[] expectedOrder) {
        for (int i = 0; i < menuEntries.size(); ++i) {
            Assertions.assertEquals((Object)expectedOrder[i], (Object)menuEntries.get(i).path());
        }
    }

    private void assertClientRoutes(Map<String, MenuEntry> menuOptions, boolean authenticated, boolean hasRole) {
        Assertions.assertTrue((boolean)menuOptions.containsKey("/"), (String)"Client route '' missing");
        Assertions.assertEquals((Object)"Public", (Object)menuOptions.get("/").title());
        if (authenticated) {
            Assertions.assertTrue((boolean)menuOptions.containsKey("/about"), (String)"Client route 'about' missing");
            Assertions.assertEquals((Object)"About", (Object)menuOptions.get("/about").title());
            if (hasRole) {
                Assertions.assertTrue((boolean)menuOptions.containsKey("/hilla"), (String)"Client route 'hilla' missing");
                Assertions.assertEquals((Object)"Hilla", (Object)menuOptions.get("/hilla").title());
                Assertions.assertTrue((boolean)menuOptions.containsKey("/hilla/sub"), (String)"Client child route 'hilla/sub' missing");
                Assertions.assertEquals((Object)"Hilla Sub", (Object)menuOptions.get("/hilla/sub").title());
            } else {
                Assertions.assertFalse((boolean)menuOptions.containsKey("/hilla"), (String)"Roles do not match no hilla should be available");
            }
        } else {
            Assertions.assertFalse((boolean)menuOptions.containsKey("/about"), (String)"Not authenticated about view should not be available");
            Assertions.assertFalse((boolean)menuOptions.containsKey("/hilla"), (String)"Not authenticated hilla view should not be available");
        }
        Assertions.assertFalse((boolean)menuOptions.containsKey("/login"), (String)"Client route 'login' should be excluded");
    }

    private void assertServerRoutes(Map<String, MenuEntry> menuItems) {
        Assertions.assertTrue((boolean)menuItems.containsKey("/home"), (String)"Server route 'home' missing");
        Assertions.assertEquals((Object)"Home", (Object)menuItems.get("/home").title());
        Assertions.assertEquals(MenuRegistryTest.MyRoute.class, (Object)menuItems.get("/home").menuClass());
        Assertions.assertTrue((boolean)menuItems.containsKey("/info"), (String)"Server route 'info' missing");
        Assertions.assertEquals((Object)"MyInfo", (Object)menuItems.get("/info").title());
        Assertions.assertEquals(MenuRegistryTest.MyInfo.class, (Object)menuItems.get("/info").menuClass());
    }

    private void assertServerRoutesWithParameters(Map<String, MenuEntry> menuItems, boolean excludeExpected) {
        if (excludeExpected) {
            Assertions.assertFalse((boolean)menuItems.containsKey("/param/:param"), (String)"Server route '/param/:param' should be excluded");
            Assertions.assertFalse((boolean)menuItems.containsKey("/param/:param1"), (String)"Server route '/param/:param1' should be excluded");
        }
        Assertions.assertTrue((boolean)menuItems.containsKey("/param"), (String)"Server route with optional parameters '/param' missing");
        Assertions.assertTrue((boolean)menuItems.containsKey("/param/varargs"), (String)"Server route with optional parameters '/param/varargs' missing");
    }

    @Tag(value="some-tag")
    @Route(value="normal-route")
    @Menu(title="Normal Route")
    public static class NormalRoute
    extends Component {
    }

    @Tag(value="some-tag")
    @PageTitle(value="My Normal Route")
    @Route(value="normal-route-with-page-title")
    public static class NormalRouteWithPageTitle
    extends Component {
    }

    @Tag(value="some-tag")
    @Route(value="mandatory-parameter-route")
    @Menu(title="Mandatory Param route")
    public static class MandatoryParameterRouteWithPageTitle
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, String parameter) {
        }
    }

    public static class RouteOrLayoutWithDynamicTitle
    implements HasDynamicTitle,
    HasElement {
        public String getPageTitle() {
            return "My Route with dynamic title";
        }

        public Element getElement() {
            return null;
        }
    }

    @Tag(value="some-tag")
    @Route(value="optional-parameter-route")
    @Menu(title="Optional Param route")
    public static class OptionalParameterRouteWithPageTitle
    extends Component
    implements HasUrlParameter<String> {
        public void setParameter(BeforeEvent event, @OptionalParameter String parameter) {
        }
    }
}

