/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequestInterceptor;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.dau.DAUCustomizer;
import com.vaadin.flow.server.dau.DAUVaadinRequestInterceptor;
import com.vaadin.flow.server.dau.UserIdentitySupplier;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.dau.DauIntegration;
import com.vaadin.tests.util.MockDeploymentConfiguration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class VaadinServiceDauTest {
    private static final Predicate<VaadinRequestInterceptor> IS_DAU_INTERCEPTOR = interceptor -> {
        if (interceptor instanceof DAUVaadinRequestInterceptor) return true;
        if (!(interceptor instanceof VaadinService.VaadinSessionOnRequestStartInterceptorWrapper)) return false;
        VaadinService.VaadinSessionOnRequestStartInterceptorWrapper wrapper = (VaadinService.VaadinSessionOnRequestStartInterceptorWrapper)interceptor;
        if (!(wrapper.delegate instanceof DAUVaadinRequestInterceptor)) return false;
        return true;
    };
    private String subscriptionKey;
    private MockedStatic<DauIntegration> dauIntegrationMock;

    @BeforeEach
    public void setUp() throws Exception {
        this.subscriptionKey = System.getProperty("vaadin.subscriptionKey");
        System.setProperty("vaadin.subscriptionKey", "sub-1234");
        this.dauIntegrationMock = Mockito.mockStatic(DauIntegration.class);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.subscriptionKey != null) {
            System.setProperty("vaadin.subscriptionKey", this.subscriptionKey);
        } else {
            System.clearProperty("vaadin.subscriptionKey");
        }
        this.dauIntegrationMock.close();
    }

    @Test
    public void init_developmentMode_dauNotEnabled() {
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        config.setProductionMode(false);
        config.setApplicationOrSystemProperty("dau.enable", "true");
        MockVaadinServletService service = new MockVaadinServletService((DeploymentConfiguration)config);
        Assertions.assertTrue((boolean)this.vaadinInterceptors((VaadinService)service).noneMatch(IS_DAU_INTERCEPTOR), (String)"Expecting DAU interceptor not to be installed");
        this.dauIntegrationMock.verifyNoInteractions();
    }

    @Test
    public void init_productionMode_notDauBuild_dauNotEnabled() {
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        config.setProductionMode(true);
        config.setApplicationOrSystemProperty("dau.enable", "false");
        MockVaadinServletService service = new MockVaadinServletService((DeploymentConfiguration)config);
        Assertions.assertTrue((boolean)this.vaadinInterceptors((VaadinService)service).noneMatch(IS_DAU_INTERCEPTOR), (String)"Expecting DAU interceptor not to be installed");
        this.dauIntegrationMock.verifyNoInteractions();
    }

    @Test
    public void init_productionMode_dauBuild_dauEnabled() {
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        config.setProductionMode(true);
        config.setApplicationOrSystemProperty("dau.enable", "true");
        MockVaadinServletService service = new MockVaadinServletService((DeploymentConfiguration)config);
        Assertions.assertTrue((boolean)this.vaadinInterceptors((VaadinService)service).anyMatch(IS_DAU_INTERCEPTOR), (String)"Expecting DAU interceptor to be installed");
        this.dauIntegrationMock.verify(() -> DauIntegration.startTracking((String)ArgumentMatchers.anyString()));
    }

    @Test
    public void init_productionMode_dauBuild_subscriptionKeyNotAvailable_throws() {
        this.dauIntegrationMock.reset();
        this.dauIntegrationMock.when(() -> DauIntegration.startTracking((String)ArgumentMatchers.anyString())).thenCallRealMethod();
        System.clearProperty("vaadin.subscriptionKey");
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        config.setProductionMode(true);
        config.setApplicationOrSystemProperty("dau.enable", "true");
        Assertions.assertThrows(LicenseException.class, () -> new MockVaadinServletService((DeploymentConfiguration)config));
    }

    @Test
    public void init_dauEnabled_lookupCustomIdentitySupplier() {
        final UserIdentitySupplier & Serializable providedIdentitySupplier = (UserIdentitySupplier & Serializable)userIdentityContext -> Optional.of("user1");
        DAUCustomizer customizer = new DAUCustomizer(){

            public UserIdentitySupplier getUserIdentitySupplier() {
                return providedIdentitySupplier;
            }
        };
        VaadinService service = VaadinServiceDauTest.vaadinServiceWithDau(customizer);
        VaadinRequestInterceptor interceptor = this.vaadinInterceptors(service).filter(IS_DAU_INTERCEPTOR).findFirst().orElseThrow(() -> new AssertionError((Object)"DAU interceptor not installed"));
        UserIdentitySupplier userIdentitySupplier = this.extractUserIdentitySupplierFromDauInterceptor(interceptor);
        Assertions.assertSame((Object)providedIdentitySupplier, (Object)userIdentitySupplier);
    }

    public static VaadinService vaadinServiceWithDau(DAUCustomizer customizer) {
        MockDeploymentConfiguration config = new MockDeploymentConfiguration();
        config.setProductionMode(true);
        config.setApplicationOrSystemProperty("dau.enable", "true");
        final Lookup lookup = customizer != null ? Lookup.of((Object)customizer, (Class[])new Class[]{DAUCustomizer.class}) : null;
        return new MockVaadinServletService((DeploymentConfiguration)config){

            public VaadinContext getContext() {
                VaadinContext context = super.getContext();
                if (context.getAttribute(Lookup.class) == null) {
                    context.setAttribute(Lookup.class, (Object)lookup);
                }
                return context;
            }
        };
    }

    private Stream<VaadinRequestInterceptor> vaadinInterceptors(VaadinService service) {
        return StreamSupport.stream(service.getVaadinRequestInterceptors().spliterator(), false);
    }

    private UserIdentitySupplier extractUserIdentitySupplierFromDauInterceptor(VaadinRequestInterceptor interceptor) {
        if (interceptor instanceof VaadinService.VaadinSessionOnRequestStartInterceptorWrapper) {
            VaadinService.VaadinSessionOnRequestStartInterceptorWrapper wrapper = (VaadinService.VaadinSessionOnRequestStartInterceptorWrapper)interceptor;
            interceptor = wrapper.delegate;
        }
        if (interceptor instanceof DAUVaadinRequestInterceptor) {
            try {
                Field identitySupplierField = DAUVaadinRequestInterceptor.class.getDeclaredField("userIdentitySupplier");
                identitySupplierField.setAccessible(true);
                return (UserIdentitySupplier)identitySupplierField.get(interceptor);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new AssertionError("Cannot access userIdentitySupplier field", e);
            }
        }
        throw new AssertionError((Object)(String.valueOf(interceptor.getClass()) + " is not a DAUVaadinRequestInterceptor nor a wrapped instance"));
    }
}

