/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.DeploymentConfigurationFactory;
import com.vaadin.flow.server.InitParameters;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.VaadinConfig;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServlet;
import com.vaadin.flow.server.VaadinServletConfig;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

class DeploymentConfigurationFactoryTest {
    @TempDir
    Path temporaryFolder;
    private File tokenFile;
    private ServletContext contextMock;
    private ApplicationConfiguration appConfiguration;
    private Map<String, String> defaultServletParams = new HashMap<String, String>();
    private static String globalUserDirValue;

    DeploymentConfigurationFactoryTest() {
    }

    @BeforeEach
    public void setup() throws IOException {
        System.setProperty("user.dir", this.temporaryFolder.toFile().getAbsolutePath());
        this.tokenFile = new File(this.temporaryFolder.toFile(), "META-INF/VAADIN/config/flow-build-info.json");
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "}"));
        this.appConfiguration = this.mockApplicationConfiguration();
        this.contextMock = (ServletContext)Mockito.mock(ServletContext.class);
        this.defaultServletParams.put("vaadin.frontend.token.file", this.tokenFile.getPath());
    }

    @AfterEach
    public void tearDown() {
        this.tokenFile.delete();
    }

    @BeforeAll
    public static void setupBeforeClass() {
        globalUserDirValue = System.getProperty("user.dir");
    }

    @AfterAll
    public static void tearDownAfterClass() {
        if (globalUserDirValue != null) {
            System.setProperty("user.dir", globalUserDirValue);
        }
    }

    @Test
    public void servletWithEnclosingUI_hasItsNameInConfig() throws Exception {
        Class<TestUI.ServletWithEnclosingUi> servlet = TestUI.ServletWithEnclosingUi.class;
        HashMap<String, String> servletConfigParams = new HashMap<String, String>(new HashMap<String, String>(this.defaultServletParams));
        DeploymentConfiguration config = new DeploymentConfigurationFactory().createDeploymentConfiguration(servlet, this.createVaadinConfigMock(servletConfigParams, Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath())));
        Class<?> customUiClass = servlet.getEnclosingClass();
        Assertions.assertTrue((boolean)UI.class.isAssignableFrom(customUiClass), (String)String.format("Servlet '%s' should have its enclosing class to be UI subclass, but got: '%s'", customUiClass, servlet));
        Assertions.assertEquals((Object)customUiClass.getName(), (Object)config.getUIClassName(), (String)String.format("Expected DeploymentConfiguration for servlet '%s' to have its enclosing UI class", servlet));
    }

    @Test
    public void servletWithNoEnclosingUI_hasDefaultUiInConfig() throws Exception {
        Class<NoSettings> servlet = NoSettings.class;
        HashMap<String, String> servletConfigParams = new HashMap<String, String>(this.defaultServletParams);
        DeploymentConfiguration config = new DeploymentConfigurationFactory().createDeploymentConfiguration(servlet, this.createVaadinConfigMock(servletConfigParams, Collections.emptyMap()));
        Class<?> notUiClass = servlet.getEnclosingClass();
        Assertions.assertFalse((boolean)UI.class.isAssignableFrom(notUiClass), (String)String.format("Servlet '%s' should not have its enclosing class to be UI subclass, but got: '%s'", notUiClass, servlet));
        Assertions.assertEquals((Object)UI.class.getName(), (Object)config.getUIClassName(), (String)String.format("Expected DeploymentConfiguration for servlet '%s' to have its enclosing UI class", servlet));
    }

    @Test
    public void servletConfigParametersOverrideServletContextParameters() throws Exception {
        Class<NoSettings> servlet = NoSettings.class;
        boolean servletConfigProductionModeValue = true;
        int servletConfigHeartbeatIntervalValue = 333;
        HashMap<String, String> servletConfigParams = new HashMap<String, String>(this.defaultServletParams);
        servletConfigParams.put("productionMode", Boolean.toString(servletConfigProductionModeValue));
        servletConfigParams.put("heartbeatInterval", Integer.toString(servletConfigHeartbeatIntervalValue));
        boolean servletContextProductionModeValue = false;
        int servletContextHeartbeatIntervalValue = 444;
        HashMap<String, String> servletContextParams = new HashMap<String, String>();
        servletContextParams.put("productionMode", Boolean.toString(servletContextProductionModeValue));
        servletContextParams.put("heartbeatInterval", Integer.toString(servletContextHeartbeatIntervalValue));
        DeploymentConfiguration config = new DeploymentConfigurationFactory().createDeploymentConfiguration(servlet, this.createVaadinConfigMock(servletConfigParams, servletContextParams));
        Assertions.assertEquals((Object)servletConfigProductionModeValue, (Object)config.isProductionMode(), (String)"Unexpected value for production mode, should be the same as in servlet context parameters");
        Assertions.assertEquals((int)servletConfigHeartbeatIntervalValue, (int)config.getHeartbeatInterval(), (String)"Unexpected value for heartbeat interval, should be the same as in servlet context parameters");
    }

    @Test
    public void servletConfigParameters_nullValues_ignored() throws Exception {
        Class<NoSettings> servlet = NoSettings.class;
        HashMap<String, String> servletConfigParams = new HashMap<String, String>(this.defaultServletParams);
        servletConfigParams.put("someKey", null);
        servletConfigParams.put("someNotNullKey", "NOT_NULL");
        HashMap<String, String> servletContextParams = new HashMap<String, String>();
        DeploymentConfiguration config = new DeploymentConfigurationFactory().createDeploymentConfiguration(servlet, this.createVaadinConfigMock(servletConfigParams, servletContextParams));
        Assertions.assertFalse((boolean)config.getInitParameters().containsKey("someKey"), (String)"Expecting null parameter to be ignored, but was in configuration");
        Assertions.assertTrue((boolean)config.getInitParameters().containsKey("someNotNullKey"), (String)"Expecting not null parameter to be in configuration, but was not");
    }

    @Test
    public void should_readConfigurationFromTokenFile() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": true", "}"));
        DeploymentConfiguration config = this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
        Assertions.assertTrue((boolean)config.isProductionMode());
    }

    @Test
    public void shouldThrow_tokenFileContainsNonExistingNpmFolderInDevMode() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": false,", "\"npmFolder\": \"npm\",", "\"generatedFolder\": \"generated\",", "\"frontendFolder\": \"frontend\"", "}"));
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath())));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/latest/flow/production/overview", "npm")));
    }

    @Test
    public void shouldThrow_tokenFileContainsNonExistingFrontendFolderNoNpmFolder() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": false,", "\"frontendFolder\": \"frontend\"", "}"));
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath())));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/latest/flow/production/overview", "frontend")));
    }

    @Test
    public void shouldThrow_tokenFileContainsNonExistingFrontendFolderOutsideNpmSubFolder() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("npm"), new FileAttribute[0]);
        String tempFolder = this.temporaryFolder.toFile().getAbsolutePath().replace("\\", "/");
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": false,", "\"npmFolder\": \"" + tempFolder + "/npm\",", "\"frontendFolder\": \"frontend\"", "}"));
        IllegalStateException thrown = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath())));
        Assertions.assertTrue((boolean)thrown.getMessage().contains(String.format("Running project in development mode with no access to folder '%s'.%nBuild project in production mode instead, see https://vaadin.com/docs/latest/flow/production/overview", "frontend")));
    }

    @Test
    public void shouldNotThrow_tokenFileFrontendFolderInDevMode() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("npm"), new FileAttribute[0]).toFile();
        String tempFolder = this.temporaryFolder.toFile().getAbsolutePath().replace("\\", "/");
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": false,", "\"npmFolder\": \"" + tempFolder + "/npm\",", "\"frontendFolder\": \"" + tempFolder + "/npm/frontend\"", "}"));
        this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
    }

    @Test
    public void shouldNotThrow_tokenFileFoldersExist() throws Exception {
        Files.createDirectories(this.temporaryFolder.resolve("npm"), new FileAttribute[0]).toFile();
        Files.createDirectories(this.temporaryFolder.resolve("frontend"), new FileAttribute[0]).toFile();
        String tempFolder = this.temporaryFolder.toFile().getAbsolutePath().replace("\\", "/");
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"productionMode\": false,", "\"npmFolder\": \"" + tempFolder + "/npm\",", "\"frontendFolder\": \"" + tempFolder + "/frontend\"", "}"));
        this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
    }

    @Test
    public void createInitParameters_valuesFromContextAreIgnored_valuesAreTakenFromservletConfig() {
        DeploymentConfigurationFactory factory = new DeploymentConfigurationFactory();
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)((Lookup)Mockito.mock(Lookup.class)));
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.getConfigParameterNames()).thenReturn(Collections.enumeration(Collections.singleton("foo")));
        Mockito.when((Object)context.getContextParameterNames()).thenReturn(Collections.enumeration(Collections.singleton("bar")));
        Mockito.when((Object)config.getConfigParameter("foo")).thenReturn((Object)"baz");
        Mockito.when((Object)context.getContextParameter("bar")).thenReturn((Object)"foobar");
        Mockito.when((Object)((ApplicationConfiguration)context.getAttribute((Class)Mockito.eq(ApplicationConfiguration.class), (Supplier)Mockito.any()))).thenReturn((Object)appConfig);
        Properties parameters = factory.createInitParameters(Object.class, config);
        Assertions.assertEquals((Object)"baz", (Object)parameters.get("foo"));
        Assertions.assertFalse((boolean)parameters.contains("bar"));
    }

    @Test
    public void createInitParameters_valuesAreTakenFromservletConfigAndTokenFile_valuesFromTokenFileOverridenByServletConfig() throws Exception {
        DeploymentConfigurationFactory factory = new DeploymentConfigurationFactory();
        HashSet<String> stringParams = new HashSet<String>(Arrays.asList("UI", "requestTiming", "heartbeatInterval", "pushServletMapping", "pushLongPollingSuspendTimeout", "maxMessageSuspendTimeout", "statistics.file.path", "devmode.vite.options", "compiled.web.components.path", "node.version", "node.download.root", "build.folder", "applicationIdentifier", "devmode.frontendExtraFileExtensions"));
        Field[] initParamFields = InitParameters.class.getDeclaredFields();
        Object mockTokenJsonString = this.generateJsonStringFromFields(initParamFields, stringParams);
        VaadinConfig config = this.mockTokenFileViaContextParam((String)mockTokenJsonString);
        List<String> allParamsList = this.mockParamsFromFields(initParamFields, config, stringParams);
        allParamsList.add("vaadin.frontend.token.file");
        allParamsList.removeIf(paramString -> paramString.equals("productionMode"));
        Mockito.when((Object)config.getConfigParameterNames()).thenReturn(Collections.enumeration(allParamsList));
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)((Lookup)Mockito.mock(Lookup.class)));
        Properties parameters = factory.createInitParameters(Object.class, config);
        for (int i = 0; i < initParamFields.length; ++i) {
            String paramName = (String)initParamFields[i].get(null);
            mockTokenJsonString = (String)mockTokenJsonString + "'" + paramName + "': ";
            if (!stringParams.contains(paramName)) {
                if (paramName.equals("productionMode")) {
                    Assertions.assertEquals((Object)"true", (Object)parameters.get(paramName), (String)"productionMode (boolean parameter) does not have expected value set from token file");
                    continue;
                }
                Assertions.assertEquals((Object)"false", (Object)parameters.get(paramName), (String)(paramName + " (boolean parameter) does not have expected value set from servlet config"));
                continue;
            }
            Assertions.assertEquals((Object)"foo", (Object)parameters.get(paramName), (String)(paramName + "(string parameter) does not have expected value set from servlet config"));
        }
    }

    private List<String> mockParamsFromFields(Field[] fields, VaadinConfig config, Set<String> stringParams) {
        ArrayList<String> allParamsList = new ArrayList<String>();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String paramName = (String)fields[i].get(null);
                if (!stringParams.contains(paramName)) {
                    Mockito.when((Object)config.getConfigParameter(paramName)).thenReturn((Object)"false");
                } else {
                    Mockito.when((Object)config.getConfigParameter(paramName)).thenReturn((Object)"foo");
                }
                allParamsList.add(paramName);
                continue;
            }
            catch (IllegalAccessException illegalAccess) {
                Assertions.fail((String)("Illegal access to InitParameters class: " + illegalAccess.getMessage()));
            }
        }
        return allParamsList;
    }

    private String generateJsonStringFromFields(Field[] fields, Set<String> stringParams) {
        Object mockTokenJsonString = "{";
        for (int i = 0; i < fields.length; ++i) {
            try {
                String paramName = (String)fields[i].get(null);
                mockTokenJsonString = (String)mockTokenJsonString + "\"" + paramName + "\": ";
                mockTokenJsonString = !stringParams.contains(paramName) ? (String)mockTokenJsonString + "true" : (String)mockTokenJsonString + " \"bar\"";
            }
            catch (IllegalAccessException illegalAccess) {
                Assertions.fail((String)("Illegal access to InitParameters class: " + illegalAccess.getMessage()));
            }
            if (i >= fields.length - 1) continue;
            mockTokenJsonString = (String)mockTokenJsonString + ",";
        }
        mockTokenJsonString = (String)mockTokenJsonString + " }";
        return mockTokenJsonString;
    }

    @Test
    public void createInitParameters_tokenFileIsSetViaContext_externalStatsUrlIsReadFromTokenFile_predefinedProperties() throws Exception {
        DeploymentConfigurationFactory factory = new DeploymentConfigurationFactory();
        VaadinConfig config = this.mockTokenFileViaContextParam("{ \"externalStatsUrl\": \"http://my.server/static/stats.json\"}");
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)((Lookup)Mockito.mock(Lookup.class)));
        Properties parameters = factory.createInitParameters(Object.class, config);
        Assertions.assertEquals((Object)"http://my.server/static/stats.json", (Object)parameters.get("external.stats.url"));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)parameters.get("external.stats.file"));
    }

    @Test
    public void createInitParameters_tokenFileIsSetViaContext_externalStatsFileIsReadFromTokenFile_predefinedProperties() throws Exception {
        DeploymentConfigurationFactory factory = new DeploymentConfigurationFactory();
        VaadinConfig config = this.mockTokenFileViaContextParam("{ \"externalStatsFile\": true}");
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)((Lookup)Mockito.mock(Lookup.class)));
        Properties parameters = factory.createInitParameters(Object.class, config);
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)parameters.get("external.stats.file"));
    }

    @Test
    public void createInitParameters_tokenFileIsSetViaContext_setPropertyFromTokenFile() throws Exception {
        DeploymentConfigurationFactory factory = new DeploymentConfigurationFactory();
        VaadinConfig config = this.mockTokenFileViaContextParam("{ \"productionMode\": true}");
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        Mockito.when((Object)((Lookup)context.getAttribute(Lookup.class))).thenReturn((Object)((Lookup)Mockito.mock(Lookup.class)));
        Properties parameters = factory.createInitParameters(Object.class, config);
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)parameters.get("productionMode"));
    }

    private VaadinConfig mockTokenFileViaContextParam(String content) throws IOException {
        VaadinContext context = (VaadinContext)Mockito.mock(VaadinContext.class);
        VaadinConfig config = (VaadinConfig)Mockito.mock(VaadinConfig.class);
        ApplicationConfiguration appConfig = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.getConfigParameterNames()).thenReturn(Collections.enumeration(Collections.singleton("vaadin.frontend.token.file")));
        Mockito.when((Object)context.getContextParameterNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)config.getVaadinContext()).thenReturn((Object)context);
        File tmpFile = Files.createTempFile(this.temporaryFolder, "tmp", null, new FileAttribute[0]).toFile();
        Files.write(tmpFile.toPath(), Collections.singletonList(content), new OpenOption[0]);
        Mockito.when((Object)context.getContextParameter("vaadin.frontend.token.file")).thenReturn((Object)tmpFile.getPath());
        Mockito.when((Object)config.getConfigParameter("vaadin.frontend.token.file")).thenReturn((Object)tmpFile.toString());
        Mockito.when((Object)((ApplicationConfiguration)context.getAttribute((Class)Mockito.eq(ApplicationConfiguration.class), (Supplier)Mockito.any()))).thenReturn((Object)appConfig);
        return config;
    }

    @Test
    public void externalStatsFileTrue_predefinedValuesAreNotOverridden_productionMode() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"frontend.hotdeploy\": true,", "\"productionMode\": true,", "\"externalStatsFile\": true", "}"));
        DeploymentConfiguration config = this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
        Assertions.assertTrue((boolean)config.isProductionMode());
        Assertions.assertTrue((boolean)config.isStatsExternal());
        Assertions.assertEquals((Object)"/vaadin-static/VAADIN/config/stats.json", (Object)config.getExternalStatsUrl());
    }

    @Test
    public void createInitParameters_readDevModeProperties() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"pnpm.enable\": true,", "\"require.home.node\": true", "}"));
        DeploymentConfiguration config = this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)config.getInitParameters().getProperty("pnpm.enable"));
        Assertions.assertEquals((Object)Boolean.TRUE.toString(), (Object)config.getInitParameters().getProperty("require.home.node"));
    }

    @Test
    public void createInitParameters_initParamtersAreSet_tokenDevModePropertiesAreNotSet() throws Exception {
        FileUtils.writeLines((File)this.tokenFile, Arrays.asList("{", "\"pnpm.enable\": true,", "\"require.home.node\": true", "}"));
        DeploymentConfiguration config = this.createConfig(Collections.singletonMap("vaadin.frontend.token.file", this.tokenFile.getPath()));
        config.getInitParameters().setProperty("pnpm.enable", Boolean.FALSE.toString());
        config.getInitParameters().setProperty("require.home.node", Boolean.FALSE.toString());
        config.getInitParameters().setProperty("devmode.optimizeBundle", Boolean.FALSE.toString());
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)config.getInitParameters().getProperty("pnpm.enable"));
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)config.getInitParameters().getProperty("require.home.node"));
        Assertions.assertEquals((Object)Boolean.FALSE.toString(), (Object)config.getInitParameters().getProperty("devmode.optimizeBundle"));
    }

    private DeploymentConfiguration createConfig(Map<String, String> map) throws Exception {
        return new DeploymentConfigurationFactory().createDeploymentConfiguration(VaadinServlet.class, this.createVaadinConfigMock(map, Collections.emptyMap()));
    }

    private VaadinConfig createVaadinConfigMock(Map<String, String> servletConfigParameters, Map<String, String> servletContextParameters) throws Exception {
        return new VaadinServletConfig(this.createServletConfigMock(servletConfigParameters, servletContextParameters));
    }

    private ApplicationConfiguration mockApplicationConfiguration() {
        MockVaadinContext context = new MockVaadinContext();
        ApplicationConfiguration configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)configuration.isProductionMode()).thenReturn((Object)true);
        Mockito.when((Object)configuration.getContext()).thenReturn((Object)context);
        Mockito.when((Object)configuration.getStringProperty(Mockito.anyString(), Mockito.anyString())).thenReturn(null);
        Mockito.when((Object)configuration.isXsrfProtectionEnabled()).thenReturn((Object)false);
        Mockito.when((Object)configuration.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        return configuration;
    }

    private ServletConfig createServletConfigMock(final Map<String, String> servletConfigParameters, Map<String, String> servletContextParameters) throws Exception {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{this.temporaryFolder.toFile().toURI().toURL()});
        Mockito.when((Object)this.contextMock.getAttribute(ApplicationConfiguration.class.getName())).thenReturn((Object)this.appConfiguration);
        Mockito.when((Object)this.contextMock.getInitParameterNames()).thenReturn(Collections.enumeration(servletContextParameters.keySet()));
        Mockito.when((Object)this.contextMock.getClassLoader()).thenReturn((Object)classLoader);
        Mockito.when((Object)this.contextMock.getInitParameter(Mockito.anyString())).thenAnswer(answer -> {
            String name = (String)answer.getArgument(0);
            return servletContextParameters.get(name);
        });
        final ResourceProvider provider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Lookup lookup = new Lookup(){

            public <T> Collection<T> lookupAll(Class<T> serviceClass) {
                return null;
            }

            public <T> T lookup(Class<T> serviceClass) {
                if (ResourceProvider.class.equals(serviceClass)) {
                    return serviceClass.cast(provider);
                }
                return null;
            }
        };
        Mockito.when((Object)provider.getApplicationResources("META-INF/VAADIN/config/flow-build-info.json")).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.contextMock.getAttribute(Lookup.class.getName())).thenReturn((Object)lookup);
        return new ServletConfig(){

            public String getServletName() {
                return "whatever";
            }

            public ServletContext getServletContext() {
                return DeploymentConfigurationFactoryTest.this.contextMock;
            }

            public String getInitParameter(String name) {
                return (String)servletConfigParameters.get(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(servletConfigParameters.keySet());
            }
        };
    }

    private static class TestUI
    extends UI {
        private TestUI() {
        }

        private static class ServletWithEnclosingUi
        extends VaadinServlet {
            private ServletWithEnclosingUi() {
            }
        }
    }

    private static class NoSettings
    extends VaadinServlet {
        private NoSettings() {
        }
    }
}

