/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.DefaultErrorHandler;
import com.vaadin.flow.server.ErrorEvent;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultErrorHandlerTest {
    MockedStatic<LoggerFactory> loggerFactory;
    Logger logger;

    DefaultErrorHandlerTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.logger = (Logger)Mockito.spy((Object)LoggerFactory.getLogger(DefaultErrorHandler.class));
        this.loggerFactory = Mockito.mockStatic(LoggerFactory.class);
        this.loggerFactory.when(() -> LoggerFactory.getLogger((String)DefaultErrorHandler.class.getName())).thenReturn((Object)this.logger);
        Mockito.when((Object)this.logger.isDebugEnabled()).thenReturn((Object)false);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.loggerFactory.close();
    }

    @Test
    public void error_acceptedException_errorHandled() {
        DefaultErrorHandler errorHandler = (DefaultErrorHandler)Mockito.spy((Object)new DefaultErrorHandler(Set.of(IOException.class.getName(), MalformedURLException.class.getName())));
        RuntimeException throwable = new RuntimeException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
        throwable = new IllegalArgumentException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
    }

    @Test
    public void error_ignoredException_notHandled() {
        DefaultErrorHandler errorHandler = (DefaultErrorHandler)Mockito.spy((Object)new DefaultErrorHandler(Set.of(IOException.class.getName(), MalformedURLException.class.getName(), "com.vaadin.flow.server.DefaultErrorHandlerTest$InnerException")));
        errorHandler.error(new ErrorEvent((Throwable)new IOException()));
        errorHandler.error(new ErrorEvent((Throwable)new MalformedURLException()));
        errorHandler.error(new ErrorEvent((Throwable)new InnerException()));
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error(ArgumentMatchers.anyString(), (Throwable)ArgumentMatchers.any(Throwable.class));
    }

    @Test
    public void error_subclassOfIgnoredException_errorHandled() {
        DefaultErrorHandler errorHandler = (DefaultErrorHandler)Mockito.spy((Object)new DefaultErrorHandler(Set.of(IOException.class.getName())));
        MalformedURLException throwable = new MalformedURLException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
    }

    @Test
    public void error_loggerAtDebugLevel_errorHandled() {
        Mockito.reset((Object[])new Logger[]{this.logger});
        ((Logger)Mockito.doReturn((Object)true).when((Object)this.logger)).isDebugEnabled();
        DefaultErrorHandler errorHandler = (DefaultErrorHandler)Mockito.spy((Object)new DefaultErrorHandler(Set.of(IOException.class.getName(), MalformedURLException.class.getName(), "com.vaadin.flow.server.DefaultErrorHandlerTest$InnerException")));
        Exception throwable = new RuntimeException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
        throwable = new IOException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
        throwable = new MalformedURLException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
        throwable = new InnerException();
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", null, (Object)throwable);
        throwable = new UncheckedIOException(new IOException());
        errorHandler.error(new ErrorEvent((Throwable)throwable));
        ((Logger)Mockito.verify((Object)this.logger)).error("Unexpected error: {}", (Object)"java.io.IOException", (Object)throwable);
    }

    public static class InnerException
    extends Exception {
    }
}

