/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.DefaultDeploymentConfiguration;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.MockVaadinServletService;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.tests.util.AlwaysLockedVaadinSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CustomUIClassLoaderTest {
    CustomUIClassLoaderTest() {
    }

    @Test
    public void testWithDefaultClassLoader() throws Exception {
        VaadinSession application = this.createStubApplication();
        Class uiClass = BootstrapHandler.getUIClass((VaadinRequest)CustomUIClassLoaderTest.createRequestMock(this.getClass().getClassLoader()));
        Assertions.assertEquals(MyUI.class, (Object)uiClass);
    }

    private static DeploymentConfiguration createConfigurationMock() {
        Properties properties = new Properties();
        properties.put("UI", MyUI.class.getName());
        MockVaadinContext context = new MockVaadinContext();
        ApplicationConfiguration config = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)config.getPropertyNames()).thenReturn(Collections.emptyEnumeration());
        Mockito.when((Object)config.getBuildFolder()).thenReturn((Object)".");
        Mockito.when((Object)config.getContext()).thenReturn((Object)context);
        return new DefaultDeploymentConfiguration(config, CustomUIClassLoaderTest.class, properties);
    }

    private static VaadinRequest createRequestMock(ClassLoader classloader) {
        VaadinService configurationMock = (VaadinService)Mockito.mock(VaadinService.class);
        DeploymentConfiguration deploymentConfiguration = CustomUIClassLoaderTest.createConfigurationMock();
        Mockito.when((Object)configurationMock.getDeploymentConfiguration()).thenReturn((Object)deploymentConfiguration);
        Mockito.when((Object)configurationMock.getClassLoader()).thenReturn((Object)classloader);
        VaadinRequest requestMock = (VaadinRequest)Mockito.mock(VaadinRequest.class);
        Mockito.when((Object)requestMock.getService()).thenReturn((Object)configurationMock);
        Mockito.when((Object)requestMock.getService()).thenReturn((Object)configurationMock);
        Mockito.when((Object)requestMock.getService()).thenReturn((Object)configurationMock);
        return requestMock;
    }

    @Test
    public void testWithClassLoader() throws Exception {
        LoggingClassLoader loggingClassLoader = new LoggingClassLoader(this);
        Class uiClass = BootstrapHandler.getUIClass((VaadinRequest)CustomUIClassLoaderTest.createRequestMock(loggingClassLoader));
        Assertions.assertEquals(MyUI.class, (Object)uiClass);
        Assertions.assertEquals((int)1, (int)loggingClassLoader.requestedClasses.size());
        Assertions.assertEquals((Object)MyUI.class.getName(), (Object)loggingClassLoader.requestedClasses.get(0));
    }

    private VaadinSession createStubApplication() {
        return new AlwaysLockedVaadinSession((VaadinService)new MockVaadinServletService()){

            public DeploymentConfiguration getConfiguration() {
                return CustomUIClassLoaderTest.createConfigurationMock();
            }
        };
    }

    public static class MyUI
    extends UI {
        protected void init(VaadinRequest request) {
        }
    }

    public class LoggingClassLoader
    extends ClassLoader {
        private List<String> requestedClasses = new ArrayList<String>();

        public LoggingClassLoader(CustomUIClassLoaderTest this$0) {
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            this.requestedClasses.add(name);
            return super.loadClass(name, resolve);
        }
    }
}

