/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.HighlightCondition;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.RouterLink;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class HighlightConditionsTest {
    HighlightConditionsTest() {
    }

    @Test
    public void locationPrefix_defaultRoute_emptyLocationMatches() {
        HighlightCondition condition = HighlightConditions.locationPrefix();
        RouterLink link = (RouterLink)Mockito.mock(RouterLink.class);
        AfterNavigationEvent event = (AfterNavigationEvent)Mockito.mock(AfterNavigationEvent.class);
        Mockito.when((Object)link.getHref()).thenReturn((Object)"");
        Location location = new Location("");
        Mockito.when((Object)event.getLocation()).thenReturn((Object)location);
        Assertions.assertTrue((boolean)condition.shouldHighlight((Object)link, event));
    }

    @Test
    public void locationPrefix_defaultRoute_nonEmptyLocationDoesNotMatch() {
        HighlightCondition condition = HighlightConditions.locationPrefix();
        RouterLink link = (RouterLink)Mockito.mock(RouterLink.class);
        AfterNavigationEvent event = (AfterNavigationEvent)Mockito.mock(AfterNavigationEvent.class);
        Mockito.when((Object)link.getHref()).thenReturn((Object)"");
        Location location = new Location("foo");
        Mockito.when((Object)event.getLocation()).thenReturn((Object)location);
        Assertions.assertFalse((boolean)condition.shouldHighlight((Object)link, event));
    }

    @Test
    public void locationPrefix_notDefaultRoute_prefixMatches() {
        HighlightCondition condition = HighlightConditions.locationPrefix();
        RouterLink link = (RouterLink)Mockito.mock(RouterLink.class);
        AfterNavigationEvent event = (AfterNavigationEvent)Mockito.mock(AfterNavigationEvent.class);
        Mockito.when((Object)link.getHref()).thenReturn((Object)"foo");
        Location location = new Location("foobar");
        Mockito.when((Object)event.getLocation()).thenReturn((Object)location);
        Assertions.assertTrue((boolean)condition.shouldHighlight((Object)link, event));
    }

    @Test
    public void locationPrefix_notDefaultRoute_nonPrefixDoesNotMatch() {
        HighlightCondition condition = HighlightConditions.locationPrefix();
        RouterLink link = (RouterLink)Mockito.mock(RouterLink.class);
        AfterNavigationEvent event = (AfterNavigationEvent)Mockito.mock(AfterNavigationEvent.class);
        Mockito.when((Object)link.getHref()).thenReturn((Object)"foo");
        Location location = new Location("bar");
        Mockito.when((Object)event.getLocation()).thenReturn((Object)location);
        Assertions.assertFalse((boolean)condition.shouldHighlight((Object)link, event));
    }
}

