/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListClearChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.AbstractNodeFeatureTest;
import com.vaadin.flow.internal.nodefeature.ElementChildrenList;
import com.vaadin.flow.internal.nodefeature.ElementClassList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NodeListAddRemoveTest
extends AbstractNodeFeatureTest<ElementClassList> {
    protected ElementClassList nodeList = (ElementClassList)this.createFeature();

    NodeListAddRemoveTest() {
    }

    private List<String> resetToRemoveAfterAddCase() {
        this.nodeList.clear();
        this.collectChanges((NodeFeature)this.nodeList);
        return this.addOriginalItems(4);
    }

    @Test
    void clear_onlyListClearChange() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.clear();
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        this.verifyCleared(changes);
        Assertions.assertEquals((int)0, (int)this.nodeList.size());
    }

    @Test
    void remove_add_changesAreNotAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.remove(items.size() - 2);
        String removed = items.get(items.size() - 2);
        this.nodeList.add((Serializable)((Object)removed));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        Assertions.assertTrue((boolean)(changes.get(1) instanceof ListAddChange));
        ListRemoveChange remove = (ListRemoveChange)changes.get(0);
        Assertions.assertEquals((int)(items.size() - 2), (int)remove.getIndex());
        Assertions.assertEquals((Object)removed, (Object)remove.getRemovedItem());
        ListAddChange add = (ListAddChange)changes.get(1);
        Assertions.assertEquals((int)(items.size() - 1), (int)add.getIndex());
        Assertions.assertEquals((int)1, (int)add.getNewItems().size());
        Assertions.assertEquals((Object)removed, add.getNewItems().get(0));
    }

    @Test
    void add_immediatelyRemove_changesDiscarded() {
        List<String> items = this.resetToRemoveAfterAddCase();
        String newItem = "foo";
        this.nodeList.add((Serializable)((Object)newItem));
        int index = items.size();
        this.nodeList.remove(index);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)0, (int)changes.size());
    }

    @Test
    void addAll_immediatelyRemove_changeIsAdjusted() {
        this.resetToRemoveAfterAddCase();
        ArrayList<String> items = new ArrayList<String>();
        this.addItemsAll(items, 3);
        this.nodeList.remove(this.nodeList.size() - 2);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        ListAddChange add = (ListAddChange)changes.get(0);
        Assertions.assertEquals((int)(this.nodeList.size() - 2), (int)add.getIndex());
        Assertions.assertEquals((int)2, (int)add.getNewItems().size());
        items.remove(1);
        Assertions.assertEquals(items, (Object)add.getNewItems());
    }

    @Test
    void add_addInBetweenAndRemove_changesAreAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        String newItem = "foo";
        this.nodeList.add((Serializable)((Object)newItem));
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.add((Serializable)((Object)"bar1"));
        int index = items.size();
        String item = (String)((Object)this.nodeList.get(index));
        this.nodeList.remove(index);
        Optional<AbstractListChange> optionalChange = this.nodeList.getChangeTracker().stream().filter(change -> {
            ListAddChange addChange = (ListAddChange)change;
            return addChange.getNewItems().contains(item);
        }).findFirst();
        Assertions.assertFalse((boolean)optionalChange.isPresent());
        Assertions.assertEquals((int)2, (int)this.nodeList.getChangeTracker().size());
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)2, (int)changes.size());
        this.verifyAdded(changes, Arrays.asList("bar", "bar1"), index, index + 1);
    }

    @Test
    void insertBefore_addAndRemove_changesAreDiscarded() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = this.nodeList.size() - 1;
        this.nodeList.add(index, (Serializable)((Object)"bar"));
        this.nodeList.remove(this.nodeList.size() - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        this.verifyAdded(changes, Arrays.asList("bar"), index);
    }

    @Test
    void insertAfter_addAllAndRemove_changesAreAdjusted() {
        this.resetToRemoveAfterAddCase();
        ArrayList<String> items = new ArrayList<String>();
        this.addItemsAll(items, 3);
        int index = this.nodeList.size() - 1;
        this.nodeList.add(index, (Serializable)((Object)"bar"));
        this.nodeList.remove(index - 2);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        Assertions.assertTrue((boolean)(changes.get(1) instanceof ListAddChange));
        ListAddChange add = (ListAddChange)changes.get(0);
        Assertions.assertEquals((int)(index - 2), (int)add.getIndex());
        Assertions.assertEquals((int)2, (int)add.getNewItems().size());
        items.remove(0);
        Assertions.assertEquals(items, (Object)add.getNewItems());
        add = (ListAddChange)changes.get(1);
        Assertions.assertEquals((int)(index - 1), (int)add.getIndex());
        Assertions.assertEquals((int)1, (int)add.getNewItems().size());
        Assertions.assertEquals((Object)"bar", add.getNewItems().get(0));
    }

    @Test
    void addOperationAfterDelete_addRemove_subsequentOoperationsAreNotAffected() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = items.size();
        this.nodeList.remove(index);
        String newItem = "bar";
        this.nodeList.add((Serializable)((Object)newItem));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
        this.verifyAdded(changes, Arrays.asList(newItem), index);
    }

    @Test
    void removeOperationAfterDelete_addRemove_subsequentOperationsAreNotAffected() {
        List<String> items = this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        int index = items.size();
        this.nodeList.remove(index);
        this.nodeList.remove(index - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        this.verifyRemoved(changes, Arrays.asList(items.get(index - 1)), index - 1);
    }

    @Test
    void removeInBetween_addRemove_removeIsNotAdjusted() {
        List<String> items = this.resetToRemoveAfterAddCase();
        int index = items.size();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.remove(index - 1);
        this.nodeList.remove(index - 1);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListRemoveChange));
        this.verifyRemoved(changes, Arrays.asList(items.get(index - 1)), index - 1);
    }

    @Test
    void clearInBetween_addRemove_removeIsAdjustedProperly() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.remove(0);
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals(ListClearChange.class, changes.get(0).getClass());
    }

    @Test
    void clear_collectChanges_allPreviousEventsAreRemoved() {
        List<String> items = this.resetToRemoveAfterAddCase();
        int index = items.size();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.add((Serializable)((Object)"bar"));
        this.nodeList.remove(index);
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"baz"));
        List<NodeChange> changes = this.collectChanges((NodeFeature)this.nodeList);
        Assertions.assertEquals((int)2, (int)changes.size());
        MatcherAssert.assertThat((Object)changes.get(0), (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
        MatcherAssert.assertThat((Object)changes.get(1), (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
        Assertions.assertEquals((int)1, (int)this.nodeList.size());
        Assertions.assertEquals((Object)"baz", (Object)this.nodeList.get(0));
    }

    @Test
    void clear_collectChanges_resetChangeTracker_clearEventIsCollected() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.add((Serializable)((Object)"bar"));
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)3, (int)changes.size());
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(0)), (Matcher)CoreMatchers.instanceOf(NodeAttachChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(1)), (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
        MatcherAssert.assertThat((Object)((NodeChange)changes.get(2)), (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
        this.nodeList.add((Serializable)((Object)"baz"));
        changes.clear();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }

    @Test
    void clear_collectChanges_resetChangeTracker_reattach_clearEventIsCollected() {
        this.resetToRemoveAfterAddCase();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.add((Serializable)((Object)"bar"));
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).remove(0);
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)3, (int)changes.size());
        Assertions.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assertions.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
        Assertions.assertEquals(ListAddChange.class, ((NodeChange)changes.get(2)).getClass());
        changes.clear();
        this.nodeList.add((Serializable)((Object)"baz"));
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertTrue((boolean)(changes.get(0) instanceof ListAddChange));
    }

    @Test
    void clearNodeList_clearChanges_generateChangesFromEmpty_clearChangeIsCollected() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assertions.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
    }

    @Test
    void clearNodeList_clearChanges_reatach_generateChangesFromEmpty_clearChangeIsCollected() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).remove(0);
        this.nodeList.getNode().collectChanges(change -> {});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)2, (int)changes.size());
        Assertions.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assertions.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
    }

    @Test
    void collectChanges_clearNodeListIsDoneFirst_noClearEventinCollectedChanges() {
        this.nodeList.clear();
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        changes.clear();
        this.nodeList.add((Serializable)((Object)"foo"));
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)1, (int)changes.size());
        Assertions.assertEquals(ListAddChange.class, ((NodeChange)changes.get(0)).getClass());
    }

    @Test
    void clear_modifyList_collectChanges_clearChangeIsCollected() {
        this.nodeList.clear();
        this.nodeList.add((Serializable)((Object)"foo"));
        StateTree tree = new StateTree(new UI().getInternals(), new Class[]{ElementChildrenList.class});
        ((ElementChildrenList)tree.getRootNode().getFeature(ElementChildrenList.class)).add((Serializable)this.nodeList.getNode());
        ArrayList changes = new ArrayList();
        this.nodeList.getNode().collectChanges(changes::add);
        Assertions.assertEquals((int)3, (int)changes.size());
        Assertions.assertEquals(NodeAttachChange.class, ((NodeChange)changes.get(0)).getClass());
        Assertions.assertEquals(ListClearChange.class, ((NodeChange)changes.get(1)).getClass());
        Assertions.assertEquals(ListAddChange.class, ((NodeChange)changes.get(2)).getClass());
    }

    private List<String> addOriginalItems(int numberOfOriginalItems) {
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < numberOfOriginalItems; ++i) {
            String item = "o-" + i;
            this.nodeList.add((Serializable)((Object)item));
            items.add(item);
        }
        this.collectChanges((NodeFeature)this.nodeList);
        this.verifyNodeListContent(items.toArray());
        return items;
    }

    private void addItemsAll(List<String> listCaptureAdded, int numberOfItems) {
        ArrayList<CallSite> items = new ArrayList<CallSite>();
        int indexInList = listCaptureAdded.size();
        for (int i = 0; i < numberOfItems; ++i) {
            String item = "a-" + indexInList + ":" + i + "/" + numberOfItems;
            items.add((CallSite)((Object)item));
            ++indexInList;
        }
        this.nodeList.addAll(items);
        listCaptureAdded.addAll(items);
    }

    private void verifyNodeListContent(Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Assertions.assertEquals((Object)items[i], (Object)this.nodeList.get(i));
        }
    }

    private void verifyCleared(List<NodeChange> changes) {
        Assertions.assertEquals((int)1, (int)changes.size());
        NodeChange nodeChange = changes.get(0);
        MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListClearChange.class));
    }

    private void verifyRemoved(List<NodeChange> changes, List<String> items, Integer ... indexes) {
        Assertions.assertTrue((changes.size() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < indexes.length; ++i) {
            NodeChange nodeChange = changes.get(i);
            MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListRemoveChange.class));
            ListRemoveChange change = (ListRemoveChange)nodeChange;
            Assertions.assertEquals((int)indexes[i], (int)change.getIndex());
            Assertions.assertEquals((Object)items.get(i), (Object)change.getRemovedItem());
        }
    }

    private void verifyAdded(List<NodeChange> changes, List<String> items, Integer ... indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            NodeChange nodeChange = changes.get(i);
            MatcherAssert.assertThat((Object)nodeChange, (Matcher)CoreMatchers.instanceOf(ListAddChange.class));
            ListAddChange change = (ListAddChange)nodeChange;
            Assertions.assertEquals((int)indexes[i], (int)change.getIndex());
            Assertions.assertEquals((int)1, (int)change.getNewItems().size());
            Assertions.assertEquals((Object)items.get(i), change.getNewItems().get(0));
        }
    }
}

