/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.open.OSUtils;
import java.io.File;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class FileIOUtilsTest {
    FileIOUtilsTest() {
    }

    @Test
    public void projectFolderOnWindows() throws Exception {
        Assumptions.assumeTrue((boolean)OSUtils.isWindows());
        URL url = new URL("file:/C:/Users/John%20Doe/Downloads/my-app%20(21)/my-app/target/classes/");
        Assertions.assertEquals((Object)new File("C:\\Users\\John Doe\\Downloads\\my-app (21)\\my-app"), (Object)FileIOUtils.getProjectFolderFromClasspath((URL)url));
    }

    @Test
    public void projectFolderOnMacOrLinux() throws Exception {
        Assumptions.assumeFalse((boolean)OSUtils.isWindows());
        URL url = new URL("file:/Users/John%20Doe/Downloads/my-app%20(21)/my-app/target/classes/");
        Assertions.assertEquals((Object)new File("/Users/John Doe/Downloads/my-app (21)/my-app"), (Object)FileIOUtils.getProjectFolderFromClasspath((URL)url));
    }

    @Test
    public void tempFilesAreTempFiles() {
        Assertions.assertTrue((boolean)FileIOUtils.isProbablyTemporaryFile((File)new File("foo.txt~")));
        Assertions.assertFalse((boolean)FileIOUtils.isProbablyTemporaryFile((File)new File("foo.txt")));
    }
}

