/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.i18n.I18NUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class I18NUtilTest {
    @TempDir
    Path temporaryFolder;
    private File resources;
    @Mock
    private ClassLoader mockLoader;

    I18NUtilTest() {
    }

    @BeforeEach
    public void init() throws IOException {
        MockitoAnnotations.openMocks((Object)this);
        this.resources = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
    }

    @Test
    public void foundResourceFolder_returnsExpectedLocales() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        File file = new File(this.resources, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_en_GB.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=English", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_fi_FI.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Suomi", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        file = new File(this.resources, "translations_de.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=deutsch", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assertions.assertEquals((int)3, (int)defaultTranslationLocales.size());
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("de")), (String)"Missing German bundle");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("en", "GB")), (String)"Missing English bundle");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")), (String)"Missing Finnish bundle");
    }

    @Test
    public void noTranslationFiles_returnsEmptyList() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assertions.assertTrue((boolean)defaultTranslationLocales.isEmpty(), (String)"Nothing should be returned for empty folder");
    }

    @Test
    public void onlyDefaultTranslationFile_returnsEmptyList() throws IOException {
        Mockito.when((Object)this.mockLoader.getResource("vaadin-i18n")).thenReturn((Object)this.resources.toURI().toURL());
        File file = new File(this.resources, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)this.mockLoader);
        Assertions.assertTrue((boolean)defaultTranslationLocales.isEmpty(), (String)"Nothing should be returned for empty folder");
    }

    @Test
    public void onlyDefaultTranslationFile_returnsTrueForDefault() throws IOException {
        File translations = new File(this.resources, "vaadin-i18n");
        translations.mkdirs();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.resources.toURI().toURL()});
        File file = new File(translations, "translations.properties");
        Files.writeString(file.toPath(), (CharSequence)"title=Default lang", StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        Assertions.assertTrue((boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader), (String)"Default file should return true");
    }

    @Test
    public void noTranslationFilesInExistingFolder_returnsFalseForDefault() throws IOException {
        File translations = new File(this.resources, "vaadin-i18n");
        translations.mkdirs();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{this.resources.toURI().toURL()});
        Assertions.assertFalse((boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader), (String)"Nothing should be returned for empty folder");
    }

    @Test
    public void translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{path.toUri().toURL()});
        Assertions.assertTrue((boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader), (String)"Default file should return true");
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assertions.assertEquals((int)2, (int)defaultTranslationLocales.size(), (String)"Translation files with locale inside JAR should be resolved");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")), (String)"Finnish locale translation should have been found");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")), (String)"Japan locale translation should have been found");
    }

    @Test
    public void openliberty_translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        final URLStreamHandler wsjarMockHandler = new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                url = new URL("jar", url.getPath(), url.getFile());
                return url.openConnection();
            }
        };
        URLStreamHandlerFactory wsjarMockHandlerFactory = protocol -> {
            if ("wsjar".equals(protocol)) {
                return wsjarMockHandler;
            }
            return null;
        };
        URLClassLoader urlClassLoader = new URLClassLoader(this, new URL[]{path.toUri().toURL()}, ClassLoader.getSystemClassLoader(), wsjarMockHandlerFactory){

            @Override
            public URL getResource(String name) {
                URL url = super.getResource(name);
                if (url != null && url.getProtocol().equals("jar")) {
                    try {
                        return new URL("wsjar", url.getHost(), url.getPort(), url.getFile(), wsjarMockHandler);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return url;
            }
        };
        Assertions.assertTrue((boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader), (String)"Default file should return true");
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assertions.assertEquals((int)2, (int)defaultTranslationLocales.size(), (String)"Translation files with locale inside JAR should be resolved");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")), (String)"Finnish locale translation should have been found");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")), (String)"Japan locale translation should have been found");
    }

    @Test
    public void jbossVfs_translationFilesInJar_returnsTrueForDefault_findsLanguages() throws IOException {
        Path path = this.generateZipArchive(this.temporaryFolder);
        JarFile jarFile = new JarFile(path.toFile());
        final URLConnection urlConnection = (URLConnection)Mockito.mock(URLConnection.class);
        Mockito.when((Object)urlConnection.getContent()).thenReturn((Object)new MockVirtualFile(jarFile, jarFile.getJarEntry("vaadin-i18n/")));
        final URLStreamHandler vfsMockHandler = new URLStreamHandler(this){

            @Override
            protected URLConnection openConnection(URL url) throws IOException {
                if (url.getFile().endsWith("/vaadin-i18n")) {
                    return urlConnection;
                }
                return null;
            }
        };
        URLStreamHandlerFactory vfsMockHandlerFactory = protocol -> {
            if ("vfs".equals(protocol)) {
                return vfsMockHandler;
            }
            return null;
        };
        URLClassLoader urlClassLoader = new URLClassLoader(this, new URL[]{path.toUri().toURL()}, ClassLoader.getSystemClassLoader(), vfsMockHandlerFactory){

            @Override
            public URL getResource(String name) {
                URL url = super.getResource(name);
                if (url != null && url.getProtocol().equals("jar") && url.getFile().contains("fake.jar!")) {
                    try {
                        return new URL("vfs", null, 0, "/content/my.war/WEB-INF/lib/fake.jar" + url.getFile().replaceFirst(".*fake.jar!", ""), vfsMockHandler);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                return url;
            }
        };
        Assertions.assertTrue((boolean)I18NUtil.containsDefaultTranslation((ClassLoader)urlClassLoader), (String)"Default file should return true");
        List defaultTranslationLocales = I18NUtil.getDefaultTranslationLocales((ClassLoader)urlClassLoader);
        Assertions.assertEquals((int)2, (int)defaultTranslationLocales.size(), (String)"Translation files with locale inside JAR should be resolved");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("fi", "FI")), (String)"Finnish locale translation should have been found");
        Assertions.assertTrue((boolean)defaultTranslationLocales.contains(new Locale("ja", "JP")), (String)"Japan locale translation should have been found");
    }

    private Path generateZipArchive(Path folder) throws IOException {
        File archiveFile = folder.resolve("fake.jar").toFile();
        archiveFile.createNewFile();
        Path tempArchive = archiveFile.toPath();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(tempArchive, new OpenOption[0]));){
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations.properties"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations_fi_FI.properties"));
            zipOutputStream.closeEntry();
            zipOutputStream.putNextEntry(new ZipEntry("vaadin-i18n/translations_ja_JP.properties"));
            zipOutputStream.closeEntry();
        }
        return tempArchive;
    }

    public static class MockVirtualFile {
        private final JarEntry entry;
        private final JarFile jarFile;

        private MockVirtualFile(JarFile jarFile, JarEntry entry) {
            this.jarFile = jarFile;
            this.entry = entry;
        }

        public List<MockVirtualFile> getChildren() {
            return this.jarFile.stream().filter(e -> !e.getName().equals(this.entry.getName()) && e.getName().startsWith(this.entry.getName()) && (e.getName().endsWith("/") || !e.getName().substring(this.entry.getName().length()).contains("/"))).map(e -> new MockVirtualFile(this.jarFile, (JarEntry)e)).toList();
        }

        public File getPhysicalFile() {
            return new File(this.entry.getName());
        }
    }
}

