/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.SignalsUnitTest;
import com.vaadin.flow.internal.nodefeature.SignalBindingFeature;
import com.vaadin.flow.signals.BindingActiveException;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalMapper;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.Serializable;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThemeListBindTest
extends SignalsUnitTest {
    ThemeListBindTest() {
    }

    @Test
    public void bindingMirrorsSignalWhileAttached_toggleAddsRemovesTheme() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("light", (Signal)signal);
        Assertions.assertFalse((boolean)component.hasThemeName("light"));
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.hasThemeName("light"));
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.hasThemeName("light"));
    }

    @Test
    public void bindingInactiveWhenDetached_reactivatedOnAttach_appliesCurrentValue() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("active", (Signal)signal);
        UI.getCurrent().remove(new Component[]{component});
        signal.set((Object)true);
        Assertions.assertFalse((boolean)component.hasThemeName("active"));
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertTrue((boolean)component.hasThemeName("active"));
    }

    @Test
    public void manualAddRemoveForBoundName_throwsBindingActiveException() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindThemeName("locked", (Signal)signal);
        Assertions.assertThrows(BindingActiveException.class, () -> component.addThemeName("locked"));
        Assertions.assertThrows(BindingActiveException.class, () -> component.removeThemeName("locked"));
        Assertions.assertThrows(BindingActiveException.class, () -> component.setThemeName("locked", true));
        Assertions.assertThrows(BindingActiveException.class, () -> component.setThemeName("locked", false));
        Assertions.assertThrows(BindingActiveException.class, () -> component.addThemeNames(new String[]{"locked", "open"}));
        Assertions.assertThrows(BindingActiveException.class, () -> component.removeThemeNames(new String[]{"locked", "open"}));
        Assertions.assertThrows(BindingActiveException.class, () -> component.getThemeNames().retainAll(Set.of("open")));
        component.addThemeName("open");
        Assertions.assertTrue((boolean)component.getThemeNames().retainAll(Set.of("locked")));
    }

    @Test
    public void clear_clearsBindingsSilently_andClearsThemes() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal a = new ValueSignal((Object)true);
        ValueSignal b = new ValueSignal((Object)true);
        component.bindThemeName("a", (Signal)a);
        component.bindThemeName("b", (Signal)b);
        Assertions.assertTrue((boolean)component.hasThemeName("a"));
        Assertions.assertTrue((boolean)component.hasThemeName("b"));
        component.getThemeNames().clear();
        Assertions.assertFalse((boolean)component.hasThemeName("a"));
        Assertions.assertFalse((boolean)component.hasThemeName("b"));
        a.set((Object)false);
        b.set((Object)false);
        a.set((Object)true);
        b.set((Object)true);
        Assertions.assertFalse((boolean)component.hasThemeName("a"));
        Assertions.assertFalse((boolean)component.hasThemeName("b"));
        Assertions.assertFalse((boolean)component.getThemeNames().iterator().hasNext());
    }

    @Test
    public void setThemeName_bulkReplacement_clearsBindingsSilently() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal bound = new ValueSignal((Object)true);
        component.bindThemeName("flag", (Signal)bound);
        Assertions.assertTrue((boolean)component.hasThemeName("flag"));
        component.setThemeName("foo");
        Assertions.assertTrue((boolean)component.hasThemeName("foo"));
        Assertions.assertFalse((boolean)component.hasThemeName("flag"));
        bound.set((Object)false);
        bound.set((Object)true);
        Assertions.assertFalse((boolean)component.hasThemeName("flag"));
    }

    @Test
    public void bind_removeBindingViaFeature_stopsUpdatesAndAllowsManualSet() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)true);
        component.bindThemeName("badge", (Signal)signal);
        Assertions.assertTrue((boolean)component.hasThemeName("badge"));
        SignalBindingFeature feature = (SignalBindingFeature)component.getElement().getNode().getFeature(SignalBindingFeature.class);
        feature.removeBinding("themes/badge");
        signal.set((Object)false);
        Assertions.assertTrue((boolean)component.hasThemeName("badge"));
        component.removeThemeName("badge");
        Assertions.assertFalse((boolean)component.hasThemeName("badge"));
    }

    @Test
    public void bind_nullSignal_throwsNPE() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        Assertions.assertThrows(NullPointerException.class, () -> component.bindThemeName("badge", null));
    }

    @Test
    public void rebinding_alreadyBound_throws() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal s1 = new ValueSignal((Object)true);
        ValueSignal s2 = new ValueSignal((Object)false);
        component.bindThemeName("tag", (Signal)s1);
        Assertions.assertTrue((boolean)component.hasThemeName("tag"));
        Assertions.assertThrows(BindingActiveException.class, () -> component.bindThemeName("tag", (Signal)s2));
    }

    @Test
    public void internalUpdatesDoNotThrowOrRecurse() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        ValueSignal signal = new ValueSignal((Object)false);
        component.bindThemeName("spin", (Signal)signal);
        signal.set((Object)true);
        signal.set((Object)true);
        Assertions.assertTrue((boolean)component.hasThemeName("spin"));
        Assertions.assertEquals((long)1L, (long)component.getThemeNames().stream().filter("spin"::equals).count());
        signal.set((Object)false);
        signal.set((Object)false);
        Assertions.assertFalse((boolean)component.hasThemeName("spin"));
    }

    @Test
    public void bindMultipleSignals() {
        TestComponent component = new TestComponent();
        UI.getCurrent().add(new Component[]{component});
        static enum DummyEnum {
            ONE,
            TWO,
            THREE;

        }
        ValueSignal signal = new ValueSignal((Object)DummyEnum.ONE);
        Signal a = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.ONE);
        Signal b = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.TWO);
        Signal c = signal.map((SignalMapper & Serializable)v -> v == DummyEnum.THREE);
        component.bindThemeName("a", a);
        component.bindThemeName("b", b);
        component.bindThemeName("c", c);
        Assertions.assertTrue((boolean)component.hasThemeName("a"));
        Assertions.assertFalse((boolean)component.hasThemeName("b"));
        Assertions.assertFalse((boolean)component.hasThemeName("b"));
        signal.set((Object)DummyEnum.TWO);
        Assertions.assertFalse((boolean)component.hasThemeName("a"));
        Assertions.assertTrue((boolean)component.hasThemeName("b"));
        Assertions.assertFalse((boolean)component.hasThemeName("c"));
        signal.set((Object)DummyEnum.THREE);
        Assertions.assertFalse((boolean)component.hasThemeName("a"));
        Assertions.assertFalse((boolean)component.hasThemeName("b"));
        Assertions.assertTrue((boolean)component.hasThemeName("c"));
    }

    @Tag(value="span")
    private static class TestComponent
    extends Component
    implements HasTheme {
        private TestComponent() {
        }
    }
}

