/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.WebComponentExporterTest;
import com.vaadin.flow.component.webcomponent.WebComponent;
import com.vaadin.flow.component.webcomponent.WebComponentConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class WebComponentConfigurationFactoryTest {
    private WebComponentExporter.WebComponentConfigurationFactory factory = new WebComponentExporter.WebComponentConfigurationFactory();

    WebComponentConfigurationFactoryTest() {
    }

    @Test
    public void create_constructsValidConfiguration() {
        WebComponentConfiguration config1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration config2 = this.factory.create((WebComponentExporter)new MyComponentExporter());
        Assertions.assertNotNull((Object)config1, (String)"create() from class should have been successful");
        Assertions.assertNotNull((Object)config2, (String)"create() from instance should have been successful");
    }

    @Test
    public void create_instance_throwsOnNullArgument() {
        NullPointerException ex = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> this.factory.create(null));
        Assertions.assertTrue((boolean)ex.getMessage().contains("'exporter'"));
    }

    @Test
    public void create_configuration_hashCode() {
        WebComponentConfiguration myComponentConfig = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration similarConfig1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter1.class).create());
        WebComponentConfiguration similarConfig2 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter2.class).create());
        WebComponentConfiguration similarConfig3 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter3.class).create());
        Assertions.assertNotEquals((int)myComponentConfig.hashCode(), (int)similarConfig1.hashCode(), (String)"Configurations with different tags should have not have same hashCodes");
        Assertions.assertNotEquals((int)similarConfig1.hashCode(), (int)similarConfig2.hashCode(), (String)"Configurations with same tag, but different properties should not have same hashCodes");
        Assertions.assertEquals((int)similarConfig2.hashCode(), (int)similarConfig3.hashCode(), (String)"Configurations with same tag and same properties but different defaults should have the same hashCode");
    }

    @Test
    public void create_configuration_equals() {
        WebComponentConfiguration myComponentConfig = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(MyComponentExporter.class).create());
        WebComponentConfiguration similarConfig1 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter1.class).create());
        WebComponentConfiguration similarConfig2 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter2.class).create());
        WebComponentConfiguration similarConfig3 = this.factory.create(new WebComponentExporterFactory.DefaultWebComponentExporterFactory(SimilarExporter3.class).create());
        Assertions.assertNotEquals((Object)myComponentConfig, (Object)similarConfig1, (String)"Configurations with different tags should not be equal");
        Assertions.assertNotEquals((Object)similarConfig1, (Object)similarConfig2, (String)"Configurations with same tag, but different properties should not be equal");
        Assertions.assertEquals((Object)similarConfig2, (Object)similarConfig3, (String)"Configurations with same tag and same properties but different defaults should be equal");
    }

    public static class MyComponentExporter
    extends WebComponentExporter<WebComponentExporterTest.MyComponent> {
        public MyComponentExporter() {
            super("my-component");
        }

        public void configureInstance(WebComponent<WebComponentExporterTest.MyComponent> webComponent, WebComponentExporterTest.MyComponent component) {
        }
    }

    public static class SimilarExporter1
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter1() {
            super("tag");
            this.addProperty("string", "dog");
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class SimilarExporter2
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter2() {
            super("tag");
            this.addProperty("int", 0);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class SimilarExporter3
    extends WebComponentExporter<MyComponent> {
        public SimilarExporter3() {
            super("tag");
            this.addProperty("int", 1);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class NoDefaultConstructorExporter
    extends WebComponentExporter<MyComponent> {
        public NoDefaultConstructorExporter(String tag) {
            super(tag);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class NullTagExporter
    extends WebComponentExporter<MyComponent> {
        public NullTagExporter() {
            super(null);
        }

        public void configureInstance(WebComponent<MyComponent> webComponent, MyComponent component) {
        }
    }

    public static class MyComponent
    extends Component {
    }
}

