/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasAriaLabel;
import com.vaadin.flow.component.Tag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HasAriaLabelTest {
    HasAriaLabelTest() {
    }

    @Test
    public void withoutAriaLabelComponent_getAriaLabelReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        Assertions.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void withNullAriaLabel_getAriaLabelReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        component.setAriaLabel(null);
        Assertions.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void withEmptyAriaLabel_getAriaLabelReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("");
        Assertions.assertEquals((Object)"", component.getAriaLabel().get());
    }

    @Test
    public void withAriaLabel_setAriaLabelToNullClearsAriaLabel() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("test AriaLabel");
        component.setAriaLabel(null);
        Assertions.assertFalse((boolean)component.getAriaLabel().isPresent());
    }

    @Test
    public void setAriaLabel() {
        TestComponent component = new TestComponent();
        component.setAriaLabel("test AriaLabel");
        Assertions.assertEquals((Object)"test AriaLabel", component.getAriaLabel().get());
    }

    @Test
    public void withoutAriaLabelledByComponent_getAriaLabelledByReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        Assertions.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void withNullAriaLabelledBy_getAriaLabelledByReturnsEmptyOptional() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy(null);
        Assertions.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void withEmptyAriaLabelledBy_getAriaLabelledByReturnsEmptyString() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("");
        Assertions.assertEquals((Object)"", component.getAriaLabelledBy().get());
    }

    @Test
    public void withAriaLabelledBy_setAriaLabelledByToNullClearsAriaLabelledBy() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("test AriaLabelledBy");
        component.setAriaLabelledBy(null);
        Assertions.assertFalse((boolean)component.getAriaLabelledBy().isPresent());
    }

    @Test
    public void setAriaLabelledBy() {
        TestComponent component = new TestComponent();
        component.setAriaLabelledBy("test AriaLabelledBy");
        Assertions.assertEquals((Object)"test AriaLabelledBy", component.getAriaLabelledBy().get());
    }

    @Tag(value="main")
    private static class TestComponent
    extends Component
    implements HasAriaLabel {
        private TestComponent() {
        }
    }
}

