/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusOption;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.internal.PendingJavaScriptInvocation;
import com.vaadin.tests.util.MockUI;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FocusableTest {
    private final MockUI ui = new MockUI();
    private final FocusableTestComponent component = new FocusableTestComponent();

    FocusableTest() {
    }

    @Test
    public void focusUnattached_nothingScheduled() {
        this.component.focus();
        this.assertPendingInvocationCount("Nothing should be scheduled when component is not attached", 0);
    }

    @Test
    public void focusBeforeAttach_executionScheduled() {
        this.component.focus();
        this.ui.add(new Component[]{this.component});
        this.assertPendingInvocationCount("An focus() inovocation should be pending for the attached component", 1);
    }

    @Test
    public void focusAfterAttach_executionScheduled() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        this.assertPendingInvocationCount("An focus() inovocation should be pending for the attached component", 1);
    }

    @Test
    public void detachAfterFocus_nothingScheduled() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        this.ui.remove(new Component[]{this.component});
        this.assertPendingInvocationCount("Nothing should be scheduled when component is not attached", 0);
    }

    private void assertPendingInvocationCount(String message, int expected) {
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)expected, (int)invocations.size(), (String)message);
    }

    @Test
    public void focus_withFocusVisible_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.VISIBLE});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"focusVisible\":true"), (String)"Should set focusVisible to true");
        Assertions.assertFalse((boolean)paramJson.contains("preventScroll"), (String)"Should not contain preventScroll");
    }

    @Test
    public void focus_withFocusNotVisible_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.NOT_VISIBLE});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"focusVisible\":false"), (String)"Should set focusVisible to false");
    }

    @Test
    public void focus_withPreventScrollEnabled_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.PreventScroll.ENABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"preventScroll\":true"), (String)"Should set preventScroll to true");
        Assertions.assertFalse((boolean)paramJson.contains("focusVisible"), (String)"Should not contain focusVisible");
    }

    @Test
    public void focus_withPreventScrollDisabled_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.PreventScroll.DISABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"preventScroll\":false"), (String)"Should set preventScroll to false");
    }

    @Test
    public void focus_withBothOptions_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.VISIBLE, FocusOption.PreventScroll.ENABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"preventScroll\":true"), (String)"Should set preventScroll to true");
        Assertions.assertTrue((boolean)paramJson.contains("\"focusVisible\":true"), (String)"Should set focusVisible to true");
    }

    @Test
    public void focus_withBothOptionsFalse_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus(new FocusOption[]{FocusOption.FocusVisible.NOT_VISIBLE, FocusOption.PreventScroll.DISABLED});
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.get(0).getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus($1)"), (String)"Should contain focus call with parameter");
        List params = invocations.get(0).getInvocation().getParameters();
        Assertions.assertTrue((params.size() >= 2 ? 1 : 0) != 0, (String)"Should have at least 2 parameters");
        String paramJson = params.get(1).toString();
        Assertions.assertTrue((boolean)paramJson.contains("\"preventScroll\":false"), (String)"Should set preventScroll to false");
        Assertions.assertTrue((boolean)paramJson.contains("\"focusVisible\":false"), (String)"Should set focusVisible to false");
    }

    @Test
    public void focus_withoutOptions_generatesCorrectJS() {
        this.ui.add(new Component[]{this.component});
        this.component.focus();
        List<PendingJavaScriptInvocation> invocations = this.ui.dumpPendingJsInvocations();
        Assertions.assertEquals((int)1, (int)invocations.size());
        String expression = invocations.getFirst().getInvocation().getExpression();
        Assertions.assertTrue((boolean)expression.contains("setTimeout"), (String)"Should contain setTimeout wrapper");
        Assertions.assertTrue((boolean)expression.contains(".focus()"), (String)"Should contain focus call without parameters");
        Assertions.assertFalse((boolean)expression.contains(".focus($1)"), (String)"Should not contain focus call with parameter");
        List params = invocations.getFirst().getInvocation().getParameters();
        Assertions.assertEquals((int)2, (int)params.size(), (String)"Should have exactly 1 parameter (the element node and wrapped parameter)");
    }

    @Tag(value="div")
    private static class FocusableTestComponent
    extends Component
    implements Focusable {
        private FocusableTestComponent() {
        }
    }
}

