/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.component.webcomponent.WebComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultWebComponentExporterFactoryTest {
    DefaultWebComponentExporterFactoryTest() {
    }

    @Test
    public void ctor_nullArg_throws() {
        Assertions.assertThrows(NullPointerException.class, () -> new WebComponentExporterFactory.DefaultWebComponentExporterFactory(null));
    }

    @Test
    public void createInnerClass_throws() {
        WebComponentExporterFactory.DefaultWebComponentExporterFactory factory = new WebComponentExporterFactory.DefaultWebComponentExporterFactory(InnerClass.class);
        RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> factory.create());
        Assertions.assertTrue((boolean)(ex.getCause() instanceof IllegalArgumentException));
        Assertions.assertTrue((boolean)ex.getMessage().contains(InnerClass.class.getName()));
        Assertions.assertTrue((boolean)ex.getMessage().contains("inner"));
    }

    @Test
    public void create_exporterHasNoTag_throws() {
        WebComponentExporterFactory.DefaultWebComponentExporterFactory factory = new WebComponentExporterFactory.DefaultWebComponentExporterFactory(NoSpecifiedTagClass.class);
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> factory.create());
        Assertions.assertTrue((boolean)ex.getMessage().contains(NoSpecifiedTagClass.class.getCanonicalName()));
        Assertions.assertTrue((boolean)ex.getMessage().contains("give null value to super(String)"));
    }

    private class InnerClass
    extends WebComponentExporter<Component> {
        protected InnerClass() {
            super("a-b");
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }

    public static class NoSpecifiedTagClass
    extends WebComponentExporter<Component> {
        public NoSpecifiedTagClass() {
            super(null);
        }

        protected void configureInstance(WebComponent<Component> webComponent, Component component) {
        }
    }
}

