/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.experimental;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.experimental.TestFeatureFlagProvider;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.MockVaadinContext;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class FeatureFlagsTest {
    @TempDir
    Path temporaryFolder;
    private VaadinContext context;
    private FeatureFlags featureFlags;
    private File propertiesDir;
    private ApplicationConfiguration configuration;
    private File featureFlagsFile;

    FeatureFlagsTest() {
    }

    @BeforeEach
    public void before() throws IOException {
        this.propertiesDir = Files.createTempDirectory(this.temporaryFolder, "temp", new FileAttribute[0]).toFile();
        this.context = new MockVaadinContext();
        this.configuration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)false);
        this.context.setAttribute(ApplicationConfiguration.class, (Object)this.configuration);
        this.featureFlags = FeatureFlags.get((VaadinContext)this.context);
        this.featureFlags.setPropertiesLocation(this.propertiesDir);
        this.mockResourcesLocation();
        this.featureFlagsFile = new File(this.propertiesDir, "vaadin-featureflags.properties");
        Files.deleteIfExists(this.featureFlagsFile.toPath());
    }

    @Test
    public void propertiesLoaded() throws IOException {
        Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should be initially disabled");
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        this.featureFlags.loadProperties();
        Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should have been enabled");
    }

    @Test
    public void setPropertiesLocation() throws Exception {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should be initially disabled");
        this.featureFlags.setPropertiesLocation(this.propertiesDir);
        Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should have been enabled");
    }

    @Test
    public void setPropertiesLocationWithNoFileDisablesFeatures() throws Exception {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        this.featureFlags.setPropertiesLocation(this.propertiesDir);
        File emptyFolder = Files.createTempDirectory("test-folder", new FileAttribute[0]).toFile();
        emptyFolder.deleteOnExit();
        this.featureFlags.setPropertiesLocation(emptyFolder);
        Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should have been disabled");
    }

    @Test
    public void enableDisableFeature() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=false\n");
        this.featureFlags.loadProperties();
        Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should be disabled after reading the properties");
        this.featureFlags.setEnabled(TestFeatureFlagProvider.EXAMPLE.getId(), true);
        Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should have been enabled");
        Assertions.assertEquals((Object)String.format("# %s\ncom.vaadin.experimental.exampleFeatureFlag=true\n", TestFeatureFlagProvider.EXAMPLE.getTitle()), (Object)FileUtils.readFileToString((File)this.featureFlagsFile, (Charset)StandardCharsets.UTF_8));
        this.featureFlags.setEnabled(TestFeatureFlagProvider.EXAMPLE.getId(), false);
        Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature should have been disabled");
        Assertions.assertEquals((Object)"", (Object)FileUtils.readFileToString((File)this.featureFlagsFile, (Charset)StandardCharsets.UTF_8), (String)"Feature flags file should be empty when no features are enabled");
    }

    @Test
    public void setEnabledOnlyInDevelopmentMode() throws IOException {
        Mockito.when((Object)this.configuration.isProductionMode()).thenReturn((Object)true);
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        ApplicationConfiguration conf = ApplicationConfiguration.get((VaadinContext)VaadinService.getCurrent().getContext());
        Mockito.when((Object)conf.isProductionMode()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalStateException.class, () -> this.featureFlags.setEnabled(TestFeatureFlagProvider.EXAMPLE.getId(), true));
    }

    @Test
    public void disabledFeatureFlagsNotMarkedInStatsWhenLoading() throws IOException {
        UsageStatistics.resetEntries();
        this.createFeatureFlagsFile("");
        this.featureFlags.loadProperties();
        Assertions.assertFalse((boolean)this.hasUsageStatsEntry("flow/featureflags/exampleFeatureFlag"));
    }

    @Test
    public void enabledFeatureFlagsMarkedInStatsWhenLoading() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        this.featureFlags.loadProperties();
        Assertions.assertTrue((boolean)this.hasUsageStatsEntry("flow/featureflags/exampleFeatureFlag"));
    }

    @Test
    public void disabledFeatureFlagsNotMarkedInStatsWhenToggled() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=true\n");
        UsageStatistics.resetEntries();
        this.featureFlags.setEnabled(TestFeatureFlagProvider.EXAMPLE.getId(), false);
        Assertions.assertFalse((boolean)this.hasUsageStatsEntry("flow/featureflags/exampleFeatureFlag"));
    }

    @Test
    public void enabledFeatureFlagsMarkedInStatsWhenToggled() throws IOException {
        this.createFeatureFlagsFile("com.vaadin.experimental.exampleFeatureFlag=false\n");
        UsageStatistics.resetEntries();
        this.featureFlags.setEnabled(TestFeatureFlagProvider.EXAMPLE.getId(), true);
        Assertions.assertTrue((boolean)this.hasUsageStatsEntry("flow/featureflags/exampleFeatureFlag"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void featureFlagShouldBeOverridableWithSystemProperty() throws IOException {
        String feature = "exampleFeatureFlag";
        String propertyName = "vaadin.experimental." + feature;
        String previousValue = System.getProperty(propertyName);
        try {
            System.setProperty(propertyName, "true");
            String fileContents = String.format("com.vaadin.experimental.%s=false\n", feature);
            this.createFeatureFlagsFile(fileContents);
            this.featureFlags.loadProperties();
            Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE));
            Assertions.assertEquals((Object)fileContents, (Object)FileUtils.readFileToString((File)this.featureFlagsFile, (Charset)StandardCharsets.UTF_8), (String)"Feature flags file should not be overwritten by system property value");
        }
        finally {
            if (previousValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, previousValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void featureFlagLoadedByResourceProviderShouldBeOverridableWithSystemProperty() throws IOException {
        String feature = "exampleFeatureFlag";
        String propertyName = "vaadin.experimental." + feature;
        String previousValue = System.getProperty(propertyName);
        File flagsFile = new File(this.propertiesDir, "another-vaadin-featureflags.properties");
        ResourceProvider resourceProvider = (ResourceProvider)Mockito.mock(ResourceProvider.class);
        Mockito.when((Object)resourceProvider.getApplicationResource("vaadin-featureflags.properties")).thenReturn((Object)flagsFile.toURI().toURL());
        Lookup lookup = (Lookup)this.context.getAttribute(Lookup.class);
        Mockito.when((Object)((ResourceProvider)lookup.lookup(ResourceProvider.class))).thenReturn((Object)resourceProvider);
        try {
            String fileContents = String.format("com.vaadin.experimental.%s=false\n", feature);
            FileUtils.write((File)flagsFile, (CharSequence)fileContents, (Charset)StandardCharsets.UTF_8);
            System.setProperty(propertyName, "true");
            this.featureFlags.loadProperties();
            Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE));
            Assertions.assertFalse((boolean)this.featureFlagsFile.exists(), (String)"Setting feature flag by system properties should not create feature flag file");
        }
        finally {
            if (previousValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, previousValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noFeatureFlagFile_systemPropertyProvided_featureEnabled() throws IOException {
        String feature = "exampleFeatureFlag";
        String propertyName = "vaadin.experimental." + feature;
        String previousValue = System.getProperty(propertyName);
        try {
            System.setProperty(propertyName, "true");
            this.featureFlags.loadProperties();
            Assertions.assertTrue((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature set with system property should be enabled");
            Assertions.assertFalse((boolean)this.featureFlagsFile.exists(), (String)"Setting feature flag by system properties should not create feature flag file");
        }
        finally {
            if (previousValue == null) {
                System.clearProperty(propertyName);
            } else {
                System.setProperty(propertyName, previousValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noFeatureFlagFile_noSystemPropertyProvided_allFeatureDisabled() throws IOException {
        String feature = "exampleFeatureFlag";
        String propertyName = "vaadin.experimental." + feature;
        String previousValue = System.getProperty(propertyName);
        try {
            if (previousValue != null) {
                System.clearProperty(propertyName);
            }
            this.featureFlags.loadProperties();
            Assertions.assertFalse((boolean)this.featureFlags.isEnabled(TestFeatureFlagProvider.EXAMPLE), (String)"Feature not set with system property should be disabled by default");
        }
        finally {
            if (previousValue != null) {
                System.setProperty(propertyName, previousValue);
            }
        }
    }

    @Test
    public void get_concurrentAccess_servletContextLock_noDeadlock() throws Exception {
        BiConsumer<Void, Throwable> errorLogger = (unused, throwable) -> {
            if (throwable != null) {
                LoggerFactory.getLogger(FeatureFlagsTest.class).error("Future failed", throwable);
            }
        };
        this.context = new MockVaadinContext(){

            @Override
            public <T> T getAttribute(Class<T> type) {
                this.doSleep();
                return super.getAttribute(type);
            }

            public <T> T getAttribute(Class<T> type, Supplier<T> defaultValueSupplier) {
                this.doSleep();
                return (T)super.getAttribute(type, defaultValueSupplier);
            }

            private void doSleep() {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        CountDownLatch latch = new CountDownLatch(2);
        CompletionStage directTask = CompletableFuture.runAsync(() -> {
            FeatureFlags.get((VaadinContext)this.context);
            latch.countDown();
        }).whenComplete((BiConsumer)errorLogger);
        CompletionStage supplierTask = CompletableFuture.runAsync(() -> this.context.getAttribute(FeatureFlags.class, () -> {
            FeatureFlags out = FeatureFlags.get((VaadinContext)this.context);
            latch.countDown();
            return out;
        })).whenComplete((BiConsumer)errorLogger);
        CompletableFuture.allOf(new CompletableFuture[]{directTask, supplierTask});
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Futures not completed, potential deadlock");
    }

    @Test
    public void get_concurrentAccess_vaadinContextLock_noDeadlock() throws Exception {
        BiConsumer<Void, Throwable> errorLogger = (unused, throwable) -> {
            if (throwable != null) {
                LoggerFactory.getLogger(FeatureFlagsTest.class).error("Future failed", throwable);
            }
        };
        this.context = new MockVaadinContext();
        CountDownLatch latch = new CountDownLatch(2);
        CompletionStage supplierTask = CompletableFuture.runAsync(() -> {
            VaadinContext vaadinContext = this.context;
            synchronized (vaadinContext) {
                ApplicationRouteRegistry attribute = (ApplicationRouteRegistry)this.context.getAttribute(ApplicationRouteRegistry.class);
                if (attribute == null) {
                    attribute = (ApplicationRouteRegistry)Mockito.mock(ApplicationRouteRegistry.class);
                    this.context.setAttribute((Object)attribute);
                }
            }
            this.context.getAttribute(FeatureFlags.class, () -> {
                FeatureFlags out = FeatureFlags.get((VaadinContext)this.context);
                latch.countDown();
                return out;
            });
        }).whenComplete((BiConsumer)errorLogger);
        CompletionStage directTask = CompletableFuture.runAsync(() -> {
            FeatureFlags.get((VaadinContext)this.context);
            latch.countDown();
        }).whenComplete((BiConsumer)errorLogger);
        CompletableFuture.allOf(new CompletableFuture[]{directTask, supplierTask});
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Futures not completed, potential deadlock");
    }

    @Test
    public void propertiesFileCheckedForUnsupportedFeatureFlags() throws IOException {
        Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
        try (MockedStatic context = Mockito.mockStatic(LoggerFactory.class);){
            context.when(() -> LoggerFactory.getLogger(FeatureFlags.class)).thenReturn((Object)mockedLogger);
            this.createFeatureFlagsFile("com.vaadin.experimental.unsupportedFeature=true\ncom.vaadin.experimental.exampleFeatureFlag=true\n");
            this.featureFlags.loadProperties();
            ((Logger)Mockito.verify((Object)mockedLogger, (VerificationMode)Mockito.never())).warn("Unsupported feature flag is present: {}", (Object)"com.vaadin.experimental.exampleFeatureFlag");
            ((Logger)Mockito.verify((Object)mockedLogger, (VerificationMode)Mockito.times((int)1))).warn("Unsupported feature flag is present: {}", (Object)"com.vaadin.experimental.unsupportedFeature");
        }
    }

    @Test
    public void propertiesFileCheckForUnsupportedFeatureFlagsRanOnlyOnce() throws IOException {
        Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
        try (MockedStatic context = Mockito.mockStatic(LoggerFactory.class);){
            context.when(() -> LoggerFactory.getLogger(FeatureFlags.class)).thenReturn((Object)mockedLogger);
            this.createFeatureFlagsFile("com.vaadin.experimental.unsupportedFeature=true\n");
            this.featureFlags.loadProperties();
            this.featureFlags.loadProperties();
            ((Logger)Mockito.verify((Object)mockedLogger, (VerificationMode)Mockito.times((int)1))).warn("Unsupported feature flag is present: {}", (Object)"com.vaadin.experimental.unsupportedFeature");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void systemPropertiesCheckedForUnsupportedFeatureFlags() {
        Logger mockedLogger = (Logger)Mockito.mock(Logger.class);
        String exampleProperty = "vaadin.experimental.exampleFeatureFlag";
        String unsupportedProperty = "vaadin.experimental.unsupportedFeature";
        String previousValue = System.getProperty(exampleProperty);
        try (MockedStatic mockedFactory = Mockito.mockStatic(LoggerFactory.class);){
            mockedFactory.when(() -> LoggerFactory.getLogger(FeatureFlags.class)).thenReturn((Object)mockedLogger);
            System.setProperty(exampleProperty, "true");
            System.setProperty(unsupportedProperty, "true");
            this.context.removeAttribute(FeatureFlags.FeatureFlagsWrapper.class);
            this.featureFlags = FeatureFlags.get((VaadinContext)this.context);
            ((Logger)Mockito.verify((Object)mockedLogger, (VerificationMode)Mockito.never())).warn("Unsupported feature flag is present: {}", (Object)exampleProperty);
            ((Logger)Mockito.verify((Object)mockedLogger, (VerificationMode)Mockito.times((int)1))).warn("Unsupported feature flag is present: {}", (Object)unsupportedProperty);
        }
        finally {
            if (previousValue == null) {
                System.clearProperty(exampleProperty);
            } else {
                System.setProperty(exampleProperty, previousValue);
            }
            System.clearProperty(unsupportedProperty);
        }
    }

    private boolean hasUsageStatsEntry(String name) {
        return UsageStatistics.getEntries().filter(entry -> entry.getName().equals(name)).findFirst().isPresent();
    }

    private void mockResourcesLocation() {
        VaadinService service = (VaadinService)Mockito.mock(VaadinService.class);
        VaadinService.setCurrent((VaadinService)service);
        VaadinContext vaadinContext = (VaadinContext)Mockito.mock(VaadinContext.class);
        Mockito.when((Object)service.getContext()).thenReturn((Object)vaadinContext);
        ApplicationConfiguration applicationConfiguration = (ApplicationConfiguration)Mockito.mock(ApplicationConfiguration.class);
        Mockito.when((Object)((ApplicationConfiguration)vaadinContext.getAttribute((Class)Mockito.eq(ApplicationConfiguration.class), (Supplier)Mockito.any()))).thenReturn((Object)applicationConfiguration);
        Mockito.when((Object)applicationConfiguration.getJavaResourceFolder()).thenReturn((Object)this.propertiesDir);
    }

    private void createFeatureFlagsFile(String data) throws IOException {
        FileUtils.write((File)this.featureFlagsFile, (CharSequence)data, (Charset)StandardCharsets.UTF_8);
    }
}

