/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueMerger;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.operations.CancelableOperation;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.impl.LocalAsynchronousSignalTree;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class SharedValueSignal<T>
extends AbstractSignal<T> {
    private final Class<T> valueType;

    public SharedValueSignal(T initialValue) {
        this(new LocalAsynchronousSignalTree(), Id.ZERO, ANYTHING_GOES, initialValue.getClass());
        this.set(initialValue);
    }

    public SharedValueSignal(Class<T> valueType) {
        this(new LocalAsynchronousSignalTree(), Id.ZERO, ANYTHING_GOES, Objects.requireNonNull(valueType));
    }

    protected SharedValueSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> valueType) {
        super(tree, id, validator);
        this.valueType = Objects.requireNonNull(valueType);
    }

    public SignalOperation<T> set(@Nullable T value) {
        assert (value == null || this.valueType.isInstance(value));
        return this.submit(new SignalCommand.SetCommand(Id.random(), this.id(), SharedValueSignal.toJson(value)), success -> SharedValueSignal.nodeValue(Objects.requireNonNull(success.onlyUpdate().oldNode()), this.valueType));
    }

    @Override
    protected @Nullable T extractValue( @Nullable Node.Data data) {
        if (data == null) {
            return null;
        }
        return SharedValueSignal.nodeValue(data, this.valueType);
    }

    @Override
    protected @Nullable Object usageChangeValue(Node.Data data) {
        return data.value();
    }

    public SignalOperation<Void> replace(@Nullable T expectedValue, @Nullable T newValue) {
        SignalCommand.ValueCondition condition = new SignalCommand.ValueCondition(Id.random(), this.id(), SharedValueSignal.toJson(expectedValue));
        SignalCommand.SetCommand set = new SignalCommand.SetCommand(Id.random(), this.id(), SharedValueSignal.toJson(newValue));
        return this.submit(new SignalCommand.TransactionCommand(Id.random(), List.of(condition, set)));
    }

    public CancelableOperation<T> update(SignalUpdater<T> updater) {
        CancelableOperation operation = new CancelableOperation();
        this.tryUpdate(updater, operation);
        return operation;
    }

    private void tryUpdate(SignalUpdater<T> updater, CancelableOperation<T> operation) {
        if (operation.isCancelled()) {
            operation.result().cancel(false);
            return;
        }
        SignalOperation setOperation = Objects.requireNonNull(Transaction.runInTransaction(() -> {
            Object value = this.peek();
            this.verifyValue(value);
            Object newValue = updater.update(value);
            return this.set(newValue);
        }).returnValue());
        setOperation.result().whenComplete((result, error) -> {
            if (error != null) {
                operation.result().completeExceptionally((Throwable)error);
            } else if (result.successful()) {
                operation.result().complete((SignalOperation.ResultOrError<SignalOperation.ResultOrError>)result);
            } else {
                this.tryUpdate(updater, operation);
            }
        });
    }

    public SignalOperation<Void> verifyValue(@Nullable T expectedValue) {
        return this.submit(new SignalCommand.ValueCondition(Id.random(), this.id(), SharedValueSignal.toJson(expectedValue)));
    }

    public SharedValueSignal<T> withValidator(CommandValidator validator) {
        return new SharedValueSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.valueType);
    }

    public SharedValueSignal<T> asReadonly() {
        return this.withValidator(CommandValidator.REJECT_ALL);
    }

    @Override
    public SharedNodeSignal asNode() {
        return super.asNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedValueSignal)) return false;
        SharedValueSignal other = (SharedValueSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.valueType, other.valueType)) return false;
        if (!Objects.equals(this.getClass(), other.getClass())) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.valueType);
    }

    public String toString() {
        return "SharedValueSignal[" + String.valueOf(this.peek()) + "]";
    }

    public <C> SerializableConsumer<C> updater(ValueMerger<T, C> merger) {
        Objects.requireNonNull(merger);
        return newChildValue -> this.update(currentValue -> merger.merge(currentValue, newChildValue));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LoggerFactory.getLogger(SharedValueSignal.class).warn("Serializing SharedValueSignal. Sharing signals across a cluster is not yet implemented.");
        out.defaultWriteObject();
    }
}

