/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.signals.Id;
import com.vaadin.flow.signals.Node;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.operations.PutIfAbsentResult;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import com.vaadin.flow.signals.shared.impl.CommandResult;
import com.vaadin.flow.signals.shared.impl.LocalAsynchronousSignalTree;
import com.vaadin.flow.signals.shared.impl.SignalTree;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class SharedMapSignal<T>
extends AbstractSignal<Map<String, SharedValueSignal<T>>> {
    private Class<T> elementType;

    public SharedMapSignal(Class<T> elementType) {
        this(new LocalAsynchronousSignalTree(), Id.ZERO, ANYTHING_GOES, elementType);
    }

    protected SharedMapSignal(SignalTree tree, Id id, CommandValidator validator, Class<T> elementType) {
        super(tree, id, validator);
        this.elementType = Objects.requireNonNull(elementType);
    }

    @Override
    public Map<String, SharedValueSignal<T>> get() {
        return Objects.requireNonNull((Map)super.get());
    }

    @Override
    public Map<String, SharedValueSignal<T>> peek() {
        return Objects.requireNonNull((Map)super.peek());
    }

    @Override
    public Map<String, SharedValueSignal<T>> peekConfirmed() {
        return Objects.requireNonNull((Map)super.peekConfirmed());
    }

    private SharedValueSignal<T> child(Id childId) {
        return new SharedValueSignal<T>(this.tree(), childId, this.validator(), this.elementType);
    }

    @Override
    protected Map<String, SharedValueSignal<T>> extractValue( @Nullable Node.Data data) {
        if (data == null) {
            return Map.of();
        }
        return SharedMapSignal.children(data, this::child);
    }

    @Override
    protected Object usageChangeValue(Node.Data data) {
        return data.mapChildren();
    }

    public SignalOperation<T> put(String key, @Nullable T value) {
        return this.submit(new SignalCommand.PutCommand(Id.random(), this.id(), Objects.requireNonNull(key), SharedMapSignal.toJson(value)), success -> {
            if (success.updates().size() == 1) {
                return SharedMapSignal.nodeValue(Objects.requireNonNull(success.onlyUpdate().oldNode()), this.elementType);
            }
            assert (success.updates().size() == 2);
            return null;
        });
    }

    public SignalOperation<PutIfAbsentResult<SharedValueSignal<T>>> putIfAbsent(String key, @Nullable T value) {
        Id commandId = Id.random();
        return this.submit(new SignalCommand.PutIfAbsentCommand(commandId, this.id(), null, Objects.requireNonNull(key), SharedMapSignal.toJson(value)), success -> {
            Id childId;
            boolean created = success.updates().containsKey(commandId);
            if (created) {
                childId = commandId;
            } else {
                CommandResult.NodeModification modification = Objects.requireNonNull(success.updates().get(this.id()));
                Node.Data newNode = (Node.Data)Objects.requireNonNull(modification.newNode());
                childId = Objects.requireNonNull(newNode.mapChildren().get(key));
            }
            return new PutIfAbsentResult<SharedValueSignal<T>>(created, this.child(childId));
        });
    }

    public SignalOperation<T> remove(String key) {
        return this.submit(new SignalCommand.RemoveByKeyCommand(Id.random(), this.id(), Objects.requireNonNull(key)), success -> {
            CommandResult.NodeModification removal = success.updates().values().stream().filter(update -> update.newNode() == null).findAny().get();
            return SharedMapSignal.nodeValue(Objects.requireNonNull(removal.oldNode()), this.elementType);
        });
    }

    @Override
    public SignalOperation<Void> clear() {
        return super.clear();
    }

    private SignalOperation<Void> submitKeyCondition(String key, @Nullable Id expectedChildId) {
        return this.submit(new SignalCommand.KeyCondition(Id.random(), this.id(), key, expectedChildId));
    }

    public SignalOperation<Void> verifyKey(String key, AbstractSignal<?> expectedChild) {
        return this.submitKeyCondition(Objects.requireNonNull(key), expectedChild.id());
    }

    public SignalOperation<Void> verifyHasKey(String key) {
        return this.submitKeyCondition(key, null);
    }

    public SignalOperation<Void> verifyKeyAbsent(String key) {
        return this.submitKeyCondition(key, Id.ZERO);
    }

    public SharedMapSignal<T> withValidator(CommandValidator validator) {
        return new SharedMapSignal<T>(this.tree(), this.id(), this.mergeValidators(validator), this.elementType);
    }

    public SharedMapSignal<T> asReadonly() {
        return this.withValidator(anything -> false);
    }

    @Override
    public SharedNodeSignal asNode() {
        return super.asNode();
    }

    static <T extends Signal<?>> Map<String, T> children(Node.Data node, SerializableFunction<Id, T> factory) {
        LinkedHashMap children = new LinkedHashMap();
        node.mapChildren().forEach((key, id) -> children.put(key, (Signal)factory.apply((Id)id)));
        return Collections.unmodifiableMap(children);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SharedMapSignal)) return false;
        SharedMapSignal other = (SharedMapSignal)obj;
        if (!Objects.equals(this.tree(), other.tree())) return false;
        if (!Objects.equals(this.id(), other.id())) return false;
        if (!Objects.equals(this.validator(), other.validator())) return false;
        if (!Objects.equals(this.elementType, other.elementType)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.tree(), this.id(), this.validator(), this.elementType);
    }

    public String toString() {
        Object value = this.peek();
        if (value == null) {
            return "SharedMapSignal[null]";
        }
        return value.entrySet().stream().map((? super T entry) -> (String)entry.getKey() + "=" + String.valueOf(((SharedValueSignal)entry.getValue()).peek())).collect(Collectors.joining(", ", "SharedMapSignal[", "]"));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        LoggerFactory.getLogger(SharedMapSignal.class).warn("Serializing SharedMapSignal. Sharing signals across a cluster is not yet implemented.");
        out.defaultWriteObject();
    }
}

