/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.function.SignalModifier;
import com.vaadin.flow.signals.function.SignalUpdater;
import com.vaadin.flow.signals.function.ValueMerger;
import com.vaadin.flow.signals.function.ValueModifier;
import com.vaadin.flow.signals.impl.Transaction;
import com.vaadin.flow.signals.local.AbstractLocalSignal;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class ValueSignal<T>
extends AbstractLocalSignal<T> {
    private boolean modifyRunning = false;
    private transient boolean modifyUsed = false;
    private transient boolean usedWithoutSessionLock = false;
    private final SerializableBiPredicate<T, T> equalityChecker;

    public ValueSignal(@Nullable T initialValue) {
        this(initialValue, Objects::equals);
    }

    public ValueSignal(@Nullable T initialValue, SerializableBiPredicate<T, T> equalityChecker) {
        super(initialValue);
        this.equalityChecker = Objects.requireNonNull(equalityChecker, "Equality checker must not be null");
    }

    @Override
    protected void checkPreconditions() {
        this.assertLockHeld();
        super.checkPreconditions();
        if (Transaction.inExplicitTransaction()) {
            throw new IllegalStateException("ValueSignal cannot be used inside signal transactions because it can hold a reference to a mutable object that can be mutated directly, bypassing transaction control. Use SharedValueSignal instead.");
        }
        if (this.modifyRunning) {
            throw new ConcurrentModificationException();
        }
        VaadinSession session = VaadinSession.getCurrent();
        if (session == null || !session.hasLock()) {
            this.usedWithoutSessionLock = true;
        }
        if (this.modifyUsed && this.usedWithoutSessionLock) {
            throw new IllegalStateException("This ValueSignal instance has been used with modify() and accessed without holding the session lock. This is not thread-safe because modify() works with mutable values without holding a lock while the modifier callback runs. Use immutable values with set(), replace(), or update() instead of modify() when the signal is shared between threads.");
        }
    }

    public void set(@Nullable T value) {
        this.lock();
        try {
            this.checkPreconditions();
            if (!this.equalityChecker.test(value, this.getSignalValue())) {
                this.setSignalValue(value);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(@Nullable T expectedValue, @Nullable T newValue) {
        this.lock();
        try {
            this.checkPreconditions();
            if (this.equalityChecker.test(expectedValue, this.getSignalValue())) {
                if (!this.equalityChecker.test(newValue, this.getSignalValue())) {
                    this.setSignalValue(newValue);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized @Nullable T update(SignalUpdater<T> updater) {
        Objects.requireNonNull(updater);
        this.lock();
        try {
            this.checkPreconditions();
            Object oldValue = this.getSignalValue();
            T newValue = updater.update(oldValue);
            if (!this.equalityChecker.test(newValue, oldValue)) {
                this.setSignalValue(newValue);
            }
            Object t = oldValue;
            return t;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ValueModifier<T> modifier) {
        Objects.requireNonNull(modifier);
        if (!this.tryLock()) {
            throw new ConcurrentModificationException();
        }
        try {
            this.checkPreconditions();
            this.modifyUsed = true;
            this.modifyRunning = true;
        }
        finally {
            this.unlock();
        }
        boolean completed = false;
        try {
            modifier.modify(this.getSignalValueUnsafe());
            completed = true;
        }
        finally {
            this.lock();
            try {
                this.modifyRunning = false;
                if (completed) {
                    this.setSignalValue(this.getSignalValue());
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    public Signal<T> asReadonly() {
        return () -> this.get();
    }

    public <C> SerializableConsumer<C> updater(ValueMerger<T, C> merger) {
        Objects.requireNonNull(merger);
        return newChildValue -> this.update(currentValue -> merger.merge(currentValue, newChildValue));
    }

    public <C> SerializableConsumer<C> modifier(SignalModifier<T, C> modifier) {
        Objects.requireNonNull(modifier);
        return newValue -> this.modify(parentValue -> modifier.modify(parentValue, newValue));
    }

    public String toString() {
        return "ValueSignal[" + String.valueOf(this.peek()) + "]";
    }
}

