/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.impl.TransientListener;
import com.vaadin.flow.signals.impl.UsageTracker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;

public abstract class AbstractLocalSignal<T>
implements Signal<T> {
    private final List<TransientListener> listeners = new ArrayList<TransientListener>();
    private final ReentrantLock lock = new ReentrantLock();
    private int version;
    private @Nullable T signalValue;
    private transient @Nullable VaadinSession ownerSession;

    protected AbstractLocalSignal(@Nullable T initialValue) {
        this.signalValue = initialValue;
    }

    protected void checkPreconditions() {
        VaadinSession currentSession = VaadinSession.getCurrent();
        if (currentSession == null) {
            return;
        }
        if (this.ownerSession == null) {
            this.ownerSession = currentSession;
        } else if (this.ownerSession != currentSession) {
            throw new IllegalStateException("This " + this.getClass().getSimpleName() + " instance was created in one VaadinSession but is being accessed from another. This typically happens when a local signal is stored in a static field or an application-scoped bean. Use SharedValueSignal or SharedListSignal instead for state that is shared across sessions.");
        }
    }

    @Override
    public @Nullable T get() {
        if (!UsageTracker.isGetAllowed()) {
            throw new IllegalStateException("Signal.get() was called outside a reactive context. Use peek() to read the value without setting up dependency tracking, or use Signal.untracked(() -> signal.get()) to explicitly opt out.");
        }
        this.lock.lock();
        try {
            this.checkPreconditions();
            if (UsageTracker.isActive()) {
                UsageTracker.registerUsage(this.createUsage());
            }
            T t = this.signalValue;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public @Nullable T peek() {
        this.lock.lock();
        try {
            this.checkPreconditions();
            T t = this.signalValue;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void unlock() {
        this.lock.unlock();
    }

    protected boolean tryLock() {
        return this.lock.tryLock();
    }

    protected void assertLockHeld() {
        assert (this.lock.isHeldByCurrentThread());
    }

    protected @Nullable T getSignalValue() {
        this.assertLockHeld();
        return this.signalValue;
    }

    protected @Nullable T getSignalValueUnsafe() {
        return this.signalValue;
    }

    protected void setSignalValue(@Nullable T value) {
        this.assertLockHeld();
        this.signalValue = value;
        ++this.version;
        List<TransientListener> copy = List.copyOf(this.listeners);
        this.listeners.clear();
        for (TransientListener listener : copy) {
            if (!listener.invoke(false)) continue;
            this.listeners.add(listener);
        }
    }

    private UsageTracker.Usage createUsage() {
        this.assertLockHeld();
        final int originalVersion = this.version;
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                AbstractLocalSignal.this.lock.lock();
                try {
                    boolean bl = AbstractLocalSignal.this.version != originalVersion;
                    return bl;
                }
                finally {
                    AbstractLocalSignal.this.lock.unlock();
                }
            }

            @Override
            public Registration onNextChange(TransientListener listener) {
                AbstractLocalSignal.this.lock.lock();
                try {
                    if (this.hasChanges() && !listener.invoke(true)) {
                        Registration registration = () -> {};
                        return registration;
                    }
                    AbstractLocalSignal.this.listeners.add(listener);
                    Registration registration = () -> {
                        AbstractLocalSignal.this.lock.lock();
                        try {
                            AbstractLocalSignal.this.listeners.remove(listener);
                        }
                        finally {
                            AbstractLocalSignal.this.lock.unlock();
                        }
                    };
                    return registration;
                }
                finally {
                    AbstractLocalSignal.this.lock.unlock();
                }
            }
        };
    }

    ReentrantLock getLock() {
        return this.lock;
    }
}

