/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableIntFunction;
import com.vaadin.flow.signals.Signal;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.function.TransactionTask;
import com.vaadin.flow.signals.function.ValueSupplier;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.SharedNumberSignal;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedNumberSignalTest
extends SignalTestBase {
    @Test
    void constructor_noArgs_zeroValue() {
        SharedNumberSignal signal = new SharedNumberSignal();
        Assertions.assertEquals((double)0.0, (Double)signal.peek());
    }

    @Test
    void constructor_initialValue_initialValue() {
        SharedNumberSignal signal = new SharedNumberSignal(42.0);
        Assertions.assertEquals((double)42.0, (Double)signal.peek());
    }

    @Test
    void incrementBy_concurrentIncrements_allIncrementsConsidered() {
        SharedNumberSignal signal = new SharedNumberSignal();
        SignalOperation operation = (SignalOperation)Signal.runInTransaction((ValueSupplier & Serializable)() -> {
            SignalOperation operationInner = signal.incrementBy(1.0);
            Signal.runWithoutTransaction((TransactionTask & Serializable)() -> {
                signal.incrementBy(2.0);
                Assertions.assertEquals((double)2.0, (Double)signal.peek());
            });
            Assertions.assertEquals((double)1.0, (Double)signal.get());
            return operationInner;
        }).returnValue();
        Assertions.assertEquals((double)3.0, (Double)signal.peek());
        Double result = (Double)TestUtil.assertSuccess(operation);
        Assertions.assertEquals((double)3.0, (Double)result);
    }

    @Test
    void getAsInt_decimalValue_valueIsTruncated() {
        SharedNumberSignal signal = new SharedNumberSignal(2.718);
        Assertions.assertEquals((int)2, (Integer)((Integer)Signal.runInTransaction((ValueSupplier & Serializable)() -> signal.getAsInt()).returnValue()));
    }

    @Test
    void value_intOverload_setsTheValue() {
        SharedNumberSignal signal = new SharedNumberSignal();
        signal.set(2);
        Assertions.assertEquals((double)2.0, (Double)signal.peek());
    }

    @Test
    void withValidator_spyingValidator_seesParentAndChildOperations() {
        SharedNumberSignal signal = new SharedNumberSignal();
        ArrayList validatedCommands = new ArrayList();
        SharedNumberSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        wrapper.incrementBy(1.0);
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.IncrementCommand.class, validatedCommands.get(0));
    }

    @Test
    void readonly_makeChangesToListAndChild_allChangesRejected() {
        SharedNumberSignal signal = new SharedNumberSignal();
        SharedNumberSignal readonly = signal.asReadonly();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonly.incrementBy(1.0));
    }

    @Test
    void mapIntValue_simpleIntMapper_valueIsMapped() {
        SharedNumberSignal signal = new SharedNumberSignal();
        Signal doubled = signal.mapIntValue((SerializableIntFunction & Serializable)value -> value * 2);
        Assertions.assertEquals((int)0, (Integer)((Integer)doubled.peek()));
        signal.set(5);
        Assertions.assertEquals((int)10, (Integer)((Integer)doubled.peek()));
    }

    @Test
    void equalsHashCode() {
        SharedNumberSignal signal = new SharedNumberSignal();
        Assertions.assertEquals((Object)signal, (Object)signal);
        SharedNumberSignal copy = new SharedNumberSignal(signal.tree(), signal.id(), signal.validator());
        Assertions.assertEquals((Object)signal, (Object)copy);
        Assertions.assertEquals((int)signal.hashCode(), (int)copy.hashCode());
        SharedNumberSignal asValue = signal.asNode().asNumber();
        Assertions.assertEquals((Object)signal, (Object)asValue);
        Assertions.assertEquals((int)signal.hashCode(), (int)asValue.hashCode());
        Assertions.assertNotEquals((Object)signal, (Object)new SharedNumberSignal());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asReadonly());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode().asValue(Double.class));
        Assertions.assertNotEquals((Object)signal.asNode().asValue(Double.class), (Object)signal);
    }

    @Test
    void toString_includesValue() {
        SharedNumberSignal signal = new SharedNumberSignal(1.0);
        Assertions.assertEquals((Object)"SharedNumberSignal[1.0]", (Object)signal.toString());
    }

    @Test
    void peek_returnsZeroAfterSetNull() {
        SharedNumberSignal signal = new SharedNumberSignal();
        signal.set(null);
        Assertions.assertEquals((double)0.0, (Double)signal.peek());
    }

    @Test
    void peekConfirmed_returnsZeroAfterSetNull() {
        SharedNumberSignal signal = new SharedNumberSignal();
        signal.set(null);
        Assertions.assertEquals((double)0.0, (Double)signal.peekConfirmed());
    }
}

