/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.operations.InsertOperation;
import com.vaadin.flow.signals.operations.PutIfAbsentResult;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedListSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedNodeSignal;
import com.vaadin.flow.signals.shared.SharedNumberSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedNodeSignalTest
extends SignalTestBase {
    @Test
    void constructor_initialValue_isEmpty() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal.SharedNodeSignalState value = (SharedNodeSignal.SharedNodeSignalState)signal.peek();
        Assertions.assertNull((Object)value.value(String.class));
        Assertions.assertNull((Object)value.parent());
        Assertions.assertEquals((int)0, (int)value.listChildren().size());
        Assertions.assertEquals((int)0, (int)value.mapChildren().size());
    }

    @Test
    void insertValue_emptyNode_getsChildNodeWithValue() {
        SharedNodeSignal signal = new SharedNodeSignal();
        InsertOperation operation = signal.insertChildWithValue((Object)"value", SharedListSignal.ListPosition.last());
        TestUtil.assertSuccess(operation);
        List listChildren = ((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren();
        Assertions.assertEquals((int)1, (int)listChildren.size());
        Assertions.assertEquals((Object)((SharedNodeSignal)operation.signal()).id(), (Object)((SharedNodeSignal)listChildren.get(0)).id());
        Assertions.assertEquals((Object)"value", (Object)((SharedNodeSignal.SharedNodeSignalState)((SharedNodeSignal)operation.signal()).peek()).value(String.class));
    }

    @Test
    void asValue_updateValueThroughWrapper_valueUpdated() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedValueSignal asValue = signal.asValue(String.class);
        Assertions.assertEquals(null, (Object)asValue.peek());
        asValue.set((Object)"update");
        Assertions.assertEquals((Object)"update", (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).value(String.class));
    }

    @Test
    void asValue_incompatibleValue_getterThrows() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedValueSignal asString = signal.asValue(String.class);
        asString.set((Object)"update");
        Assertions.assertThrows(RuntimeException.class, () -> ((SharedNodeSignal.SharedNodeSignalState)signal.peek()).value(Double.class));
        SharedValueSignal asDouble = signal.asValue(Double.class);
        Assertions.assertThrows(RuntimeException.class, () -> asDouble.peek());
    }

    @Test
    void asNumber_nullValue_readsAndIncrementsAsZero() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNumberSignal asNumber = signal.asNumber();
        Assertions.assertEquals((double)0.0, (Double)asNumber.peek());
        asNumber.incrementBy(1.0);
        Assertions.assertEquals((double)1.0, (Double)asNumber.peek());
        Assertions.assertEquals((double)1.0, (Double)((Double)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).value(Double.class)));
    }

    @Test
    void asList_insertThroughWrapper_valueUpdated() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedListSignal asList = signal.asList(String.class);
        asList.insertLast((Object)"last");
        List listChildren = ((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren();
        Assertions.assertEquals((int)1, (int)listChildren.size());
        Assertions.assertEquals((Object)"last", (Object)((SharedNodeSignal.SharedNodeSignalState)((SharedNodeSignal)listChildren.get(0)).peek()).value(String.class));
    }

    @Test
    void asList_insertThroughNode_wrapperUpdated() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedListSignal asList = signal.asList(String.class);
        signal.insertChildWithValue((Object)"last", SharedListSignal.ListPosition.last());
        List value = asList.peek();
        Assertions.assertEquals((int)1, (int)value.size());
        Assertions.assertEquals((Object)"last", (Object)((SharedValueSignal)value.get(0)).peek());
    }

    @Test
    void asMap_putThroughWrapper_valueUpdate() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedMapSignal asMap = signal.asMap(String.class);
        asMap.put("key", (Object)"value");
        Map mapChildren = ((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren();
        Assertions.assertEquals(Set.of("key"), mapChildren.keySet());
        Assertions.assertEquals((Object)"value", (Object)((SharedNodeSignal.SharedNodeSignalState)((SharedNodeSignal)mapChildren.get("key")).peek()).value(String.class));
    }

    @Test
    void asMap_putThroughNode_wrapperUpdated() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedMapSignal asMap = signal.asMap(String.class);
        signal.putChildWithValue("key", (Object)"value");
        Map value = asMap.peek();
        Assertions.assertEquals(Set.of("key"), value.keySet());
        Assertions.assertEquals((Object)"value", (Object)((SharedValueSignal)value.get("key")).peek());
    }

    @Test
    void insertChild_emptyNode_insertsEmptyListChild() {
        SharedNodeSignal signal = new SharedNodeSignal();
        InsertOperation operation = signal.insertChild(SharedListSignal.ListPosition.last());
        SharedNodeSignal child = (SharedNodeSignal)operation.signal();
        Assertions.assertEquals(List.of(child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        Assertions.assertEquals(null, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).value(String.class));
    }

    @Test
    void putChildIfAbsent_emptyNode_insertsEmptyMapChild() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SignalOperation operation = signal.putChildIfAbsent("key");
        PutIfAbsentResult result = (PutIfAbsentResult)TestUtil.assertSuccess(operation);
        Assertions.assertTrue((boolean)result.created());
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        Assertions.assertEquals(Map.of("key", child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        Assertions.assertEquals(null, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).value(String.class));
    }

    @Test
    void adpotAt_existingChild_orderChanged() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal a = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal b = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SignalOperation operation = signal.adoptAt((AbstractSignal)a, SharedListSignal.ListPosition.last());
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals(List.of(b, a), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        Assertions.assertEquals((Object)signal, (Object)((SharedNodeSignal.SharedNodeSignalState)a.peek()).parent());
    }

    @Test
    void adoptAt_nestedStructure_hierarchyChagned() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal parent = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal child = (SharedNodeSignal)parent.insertChild(SharedListSignal.ListPosition.last()).signal();
        Assertions.assertEquals((Object)parent, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).parent());
        SignalOperation operation = signal.adoptAt((AbstractSignal)child, SharedListSignal.ListPosition.first());
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)signal, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).parent());
        Assertions.assertEquals(List.of(child, parent), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        Assertions.assertEquals(List.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)parent.peek()).listChildren());
    }

    @Test
    void adoptAt_addParentToChild_rejected() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal parent = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal child = (SharedNodeSignal)parent.insertChild(SharedListSignal.ListPosition.last()).signal();
        SignalOperation operation = child.adoptAt((AbstractSignal)parent, SharedListSignal.ListPosition.first());
        TestUtil.assertFailure(operation);
    }

    @Test
    void adoptAt_adoptMapChild_noLongerMapChild() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("key");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        Assertions.assertEquals(List.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        signal.adoptAt((AbstractSignal)child, SharedListSignal.ListPosition.last());
        Assertions.assertEquals(List.of(child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
    }

    @Test
    void adoptAs_existingChild_keyChanged() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("key");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        SignalOperation operation = signal.adoptAs((AbstractSignal)child, "update");
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals(Map.of("update", child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        Assertions.assertEquals((Object)signal, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).parent());
    }

    @Test
    void adoptAs_nestedStructure_hierarchyChanged() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("parent");
        SharedNodeSignal parent = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("parent");
        parent.putChildIfAbsent("child");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)parent.peek()).mapChildren().get("child");
        Assertions.assertEquals((Object)parent, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).parent());
        SignalOperation operation = signal.adoptAs((AbstractSignal)child, "child");
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)signal, (Object)((SharedNodeSignal.SharedNodeSignalState)child.peek()).parent());
        Assertions.assertEquals(Map.of("parent", parent, "child", child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)parent.peek()).mapChildren());
    }

    @Test
    void adoptAs_addParentToChild_rejected() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("parent");
        SharedNodeSignal parent = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("parent");
        parent.putChildIfAbsent("child");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)parent.peek()).mapChildren().get("child");
        SignalOperation operation = child.adoptAs((AbstractSignal)parent, "child");
        TestUtil.assertFailure(operation);
    }

    @Test
    void adoptAs_adoptListChild_noLongerListChild() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal child = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        SignalOperation operation = signal.adoptAs((AbstractSignal)child, "key");
        TestUtil.assertSuccess(operation);
        Assertions.assertEquals(List.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
        Assertions.assertEquals(Map.of("key", child), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
    }

    @Test
    void removeChildByNode_listAndMapNodes_nodesRemoved() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal listChild = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        signal.putChildIfAbsent("key");
        SharedNodeSignal mapChild = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        SignalOperation mapRemoveOp = signal.removeChild(mapChild);
        TestUtil.assertSuccess(mapRemoveOp);
        Assertions.assertNull((Object)mapChild.peek());
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        SignalOperation listRemoveOp = signal.removeChild(listChild);
        TestUtil.assertSuccess(listRemoveOp);
        Assertions.assertNull((Object)listChild.peek());
        Assertions.assertEquals(List.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
    }

    @Test
    void removeChildByString_mapNode_nodeRemoved() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("key");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        SignalOperation mapRemoveOp = signal.removeChild("key");
        TestUtil.assertSuccess(mapRemoveOp);
        Assertions.assertNull((Object)child.peek());
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
    }

    @Test
    void clear_listAndMapNodes_nodesRemoved() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal listChild = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        signal.putChildIfAbsent("key");
        SharedNodeSignal mapChild = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("key");
        SignalOperation operation = signal.clear();
        TestUtil.assertSuccess(operation);
        Assertions.assertNull((Object)mapChild.peek());
        Assertions.assertNull((Object)listChild.peek());
        Assertions.assertEquals(Map.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren());
        Assertions.assertEquals(List.of(), (Object)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren());
    }

    @Test
    void value_modifyStateInstance_isImmutable() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal.SharedNodeSignalState value = (SharedNodeSignal.SharedNodeSignalState)signal.peek();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.listChildren().clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.mapChildren().clear());
    }

    @Test
    void value_readStateAfterModifications_seesOldState() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal.SharedNodeSignalState value = (SharedNodeSignal.SharedNodeSignalState)signal.peek();
        signal.asValue(String.class).set((Object)"value");
        signal.insertChild(SharedListSignal.ListPosition.last());
        signal.putChildIfAbsent("key");
        Assertions.assertEquals(null, (Object)value.value(String.class));
        Assertions.assertEquals(List.of(), (Object)value.listChildren());
        Assertions.assertEquals(Map.of(), (Object)value.mapChildren());
    }

    @Test
    void withValidator_spyingValidator_seesParentAndChildOperations() {
        SharedNodeSignal signal = new SharedNodeSignal();
        ArrayList validatedCommands = new ArrayList();
        SharedNodeSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        SharedNodeSignal child = (SharedNodeSignal)wrapper.insertChildWithValue((Object)"child", SharedListSignal.ListPosition.last()).signal();
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.InsertCommand.class, validatedCommands.get(0));
        child.asValue(String.class).set((Object)"update");
        Assertions.assertEquals((int)2, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.ValueCommand.class, validatedCommands.get(1));
    }

    @Test
    void readonly_makeChangesToRoottAndChild_allChangesRejected() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.insertChildWithValue((Object)"child", SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal readonly = signal.asReadonly();
        SharedNodeSignal readonlyChild = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)readonly.peek()).listChildren().get(0);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonly.clear());
        Assertions.assertEquals(List.of(readonlyChild), (Object)((SharedNodeSignal.SharedNodeSignalState)readonly.peek()).listChildren());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonlyChild.asValue(String.class).set((Object)"update"));
        Assertions.assertEquals((Object)"child", (Object)((SharedNodeSignal.SharedNodeSignalState)readonlyChild.peek()).value(String.class));
    }

    @Test
    void usageTracking_changeDifferentValues_anyChangeDetected() {
        SharedNodeSignal signal = new SharedNodeSignal();
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.asValue(String.class).set((Object)"value");
        Assertions.assertTrue((boolean)usage.hasChanges());
        usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.insertChildWithValue((Object)"insert", SharedListSignal.ListPosition.last());
        Assertions.assertTrue((boolean)usage.hasChanges());
        usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.putChildWithValue("key", (Object)"value");
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void equalsHashCode() {
        SharedNodeSignal signal = new SharedNodeSignal();
        Assertions.assertEquals((Object)signal, (Object)signal);
        SharedNodeSignal copy = new SharedNodeSignal(signal.tree(), signal.id(), signal.validator());
        Assertions.assertEquals((Object)signal, (Object)copy);
        Assertions.assertEquals((int)signal.hashCode(), (int)copy.hashCode());
        Assertions.assertEquals((Object)signal, (Object)signal.asValue(String.class).asNode());
        Assertions.assertNotEquals((Object)signal, (Object)new SharedNodeSignal());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asReadonly());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asList(Double.class));
    }

    @Test
    void equalsHashCode_listChildren() {
        SharedNodeSignal signal = new SharedNodeSignal();
        SharedNodeSignal operationChild = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal other = (SharedNodeSignal)signal.insertChild(SharedListSignal.ListPosition.last()).signal();
        SharedNodeSignal valueChild = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).listChildren().get(0);
        Assertions.assertEquals((Object)operationChild, (Object)valueChild);
        Assertions.assertEquals((int)operationChild.hashCode(), (int)valueChild.hashCode());
        Assertions.assertNotEquals((Object)operationChild, (Object)other);
    }

    @Test
    void equalsHashCode_mapChildren() {
        SharedNodeSignal signal = new SharedNodeSignal();
        signal.putChildIfAbsent("child");
        signal.putChildIfAbsent("other");
        SharedNodeSignal child = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("child");
        SharedNodeSignal other = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("other");
        SharedNodeSignal valueChild = (SharedNodeSignal)((SharedNodeSignal.SharedNodeSignalState)signal.peek()).mapChildren().get("child");
        Assertions.assertEquals((Object)child, (Object)valueChild);
        Assertions.assertEquals((int)child.hashCode(), (int)valueChild.hashCode());
        Assertions.assertNotEquals((Object)child, (Object)other);
    }

    @Test
    void toString_includesValue() {
        SharedNodeSignal signal = new SharedNodeSignal();
        Assertions.assertEquals((Object)"SharedNodeSignal[]", (Object)signal.toString());
        signal.asValue(String.class).set((Object)"value");
        Assertions.assertEquals((Object)"SharedNodeSignal[value: \"value\"]", (Object)signal.toString());
        signal.insertChildWithValue((Object)"listChild", SharedListSignal.ListPosition.last());
        Assertions.assertEquals((Object)"SharedNodeSignal[value: \"value\", listChildren: [SharedNodeSignal[value: \"listChild\"]]]", (Object)signal.toString());
        signal.putChildWithValue("key", (Object)"mapChild");
        Assertions.assertEquals((Object)"SharedNodeSignal[value: \"value\", listChildren: [SharedNodeSignal[value: \"listChild\"]], mapChildren: [key = SharedNodeSignal[value: \"mapChild\"]]]", (Object)signal.toString());
    }
}

