/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.shared;

import com.vaadin.flow.function.SerializableRunnable;
import com.vaadin.flow.signals.SignalCommand;
import com.vaadin.flow.signals.SignalTestBase;
import com.vaadin.flow.signals.TestUtil;
import com.vaadin.flow.signals.function.CommandValidator;
import com.vaadin.flow.signals.impl.UsageTracker;
import com.vaadin.flow.signals.operations.PutIfAbsentResult;
import com.vaadin.flow.signals.operations.SignalOperation;
import com.vaadin.flow.signals.shared.AbstractSignal;
import com.vaadin.flow.signals.shared.SharedMapSignal;
import com.vaadin.flow.signals.shared.SharedValueSignal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SharedMapSignalTest
extends SignalTestBase {
    @Test
    void constructor_initialValue_isEmpty() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        int size = signal.peek().size();
        Assertions.assertEquals((int)0, (int)size);
    }

    @Test
    void put_missingKey_newEntryCreated() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        SignalOperation operation = signal.put("key", (Object)"value");
        String resultValue = (String)TestUtil.assertSuccess(operation);
        Assertions.assertNull((Object)resultValue);
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
    }

    @Test
    void put_existingKey_oldEntryUpdated() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"initial");
        SharedValueSignal child = (SharedValueSignal)signal.peek().get("key");
        SignalOperation operation = signal.put("key", (Object)"update");
        String resultValue = (String)TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"initial", (Object)resultValue);
        Assertions.assertEquals((Object)"update", (Object)child.peek());
        this.assertChildren((SharedMapSignal<String>)signal, "key", "update");
    }

    @Test
    void put_multiplePuts_insertionOrderPreserved() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        List<String> insertOrder = Stream.generate(() -> UUID.randomUUID().toString()).limit(10L).toList();
        for (String string : insertOrder) {
            signal.put(string, null);
        }
        ArrayList<String> updateOrder = new ArrayList<String>(insertOrder);
        Collections.shuffle(updateOrder);
        for (String key : updateOrder) {
            signal.put(key, (Object)"update");
        }
        List list = List.copyOf(signal.peek().keySet());
        Assertions.assertEquals(insertOrder, list);
    }

    @Test
    void putIfAbsent_missingKey_newEntryCreated() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        SignalOperation operation = signal.putIfAbsent("key", (Object)"value");
        PutIfAbsentResult result = (PutIfAbsentResult)TestUtil.assertSuccess(operation);
        Assertions.assertTrue((boolean)result.created());
        SharedValueSignal child = (SharedValueSignal)result.entry();
        Assertions.assertEquals((Object)"value", (Object)child.peek());
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
        child.set((Object)"update");
        this.assertChildren((SharedMapSignal<String>)signal, "key", "update");
    }

    @Test
    void putIfAbsent_existingKey_noUpdateAndEntryUnchanged() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SharedValueSignal child = (SharedValueSignal)signal.peek().get("key");
        SignalOperation operation = signal.putIfAbsent("key", (Object)"update");
        PutIfAbsentResult result = (PutIfAbsentResult)TestUtil.assertSuccess(operation);
        Assertions.assertFalse((boolean)result.created());
        SharedValueSignal resultChild = (SharedValueSignal)result.entry();
        Assertions.assertEquals((Object)"value", (Object)resultChild.peek());
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
        Assertions.assertEquals((Object)child.id(), (Object)resultChild.id());
    }

    @Test
    void remove_exisingKey_removed() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.remove("key");
        String resultValue = (String)TestUtil.assertSuccess(operation);
        Assertions.assertEquals((Object)"value", (Object)resultValue);
        this.assertChildren((SharedMapSignal<String>)signal, new String[0]);
    }

    @Test
    void remove_missingKey_operationFailed() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.remove("other");
        TestUtil.assertFailure(operation);
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
    }

    @Test
    void clear_mapWithEntries_cleared() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.clear();
        TestUtil.assertSuccess(operation);
        this.assertChildren((SharedMapSignal<String>)signal, new String[0]);
    }

    @Test
    void verifyKey_matchingKey_success() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.verifyKey("key", (AbstractSignal)signal.peek().get("key"));
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyKey_mismatchingKey_success() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        signal.put("key2", (Object)"value2");
        SignalOperation operation = signal.verifyKey("key", (AbstractSignal)signal.peek().get("key2"));
        TestUtil.assertFailure(operation);
    }

    @Test
    void verifyHasKey_hasKey_success() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.verifyHasKey("key");
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyHasKey_hasNoKey_failure() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.verifyHasKey("key2");
        TestUtil.assertFailure(operation);
    }

    @Test
    void verifyKeyAbsent_hasNoKey_success() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.verifyKeyAbsent("key2");
        TestUtil.assertSuccess(operation);
    }

    @Test
    void verifyKeyAbsent_hasKey_failure() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SignalOperation operation = signal.verifyKeyAbsent("key");
        TestUtil.assertFailure(operation);
    }

    @Test
    void value_modifyMapInstance_immutable() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        Map value = signal.peek();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.put("key", new SharedValueSignal((Object)"update")));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> value.clear());
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
    }

    @Test
    void value_readMapAfterUpdate_readsOldData() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        Map value = signal.peek();
        signal.put("key2", (Object)"value2");
        Assertions.assertFalse((boolean)value.containsKey("key2"));
    }

    @Test
    void withValidator_spyingValidator_seesParentAndChildOperations() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        ArrayList validatedCommands = new ArrayList();
        SharedMapSignal wrapper = signal.withValidator((CommandValidator & Serializable)command -> {
            validatedCommands.add(command);
            return true;
        });
        wrapper.put("key", (Object)"value");
        Assertions.assertEquals((int)1, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.PutCommand.class, validatedCommands.get(0));
        ((SharedValueSignal)wrapper.peek().get("key")).set((Object)"update");
        Assertions.assertEquals((int)2, (int)validatedCommands.size());
        Assertions.assertInstanceOf(SignalCommand.ValueCommand.class, validatedCommands.get(1));
    }

    @Test
    void readonly_makeChangesToMapAndChild_allChangesRejected() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key", (Object)"value");
        SharedMapSignal readonly = signal.asReadonly();
        SharedValueSignal readonlyChild = (SharedValueSignal)readonly.peek().get("key");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonly.clear());
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> readonlyChild.set((Object)"update"));
        this.assertChildren((SharedMapSignal<String>)signal, "key", "value");
    }

    @Test
    void usageTracking_changeDifferentValues_onlyMapChangeDetected() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        UsageTracker.Usage usage = UsageTracker.track((SerializableRunnable & Serializable)() -> signal.get());
        signal.asNode().asValue(String.class).set((Object)"value");
        Assertions.assertFalse((boolean)usage.hasChanges());
        signal.put("key", (Object)"value");
        Assertions.assertTrue((boolean)usage.hasChanges());
    }

    @Test
    void equalsHashCode() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        Assertions.assertEquals((Object)signal, (Object)signal);
        SharedMapSignal copy = new SharedMapSignal(signal.tree(), signal.id(), signal.validator(), String.class);
        Assertions.assertEquals((Object)signal, (Object)copy);
        Assertions.assertEquals((int)signal.hashCode(), (int)copy.hashCode());
        SharedMapSignal asValue = signal.asNode().asMap(String.class);
        Assertions.assertEquals((Object)signal, (Object)asValue);
        Assertions.assertEquals((int)signal.hashCode(), (int)asValue.hashCode());
        Assertions.assertNotEquals((Object)signal, (Object)new SharedMapSignal(String.class));
        Assertions.assertNotEquals((Object)signal, (Object)signal.asReadonly());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode());
        Assertions.assertNotEquals((Object)signal, (Object)signal.asNode().asList(Double.class));
    }

    @Test
    void equalsHashCode_children() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.putIfAbsent("child", (Object)"value");
        signal.putIfAbsent("other", (Object)"other");
        SharedValueSignal child = (SharedValueSignal)signal.peek().get("child");
        SharedValueSignal other = (SharedValueSignal)signal.peek().get("other");
        SharedValueSignal valueChild = (SharedValueSignal)signal.peek().get("child");
        Assertions.assertEquals((Object)child, (Object)valueChild);
        Assertions.assertEquals((int)child.hashCode(), (int)valueChild.hashCode());
        Assertions.assertNotEquals((Object)child, (Object)other);
    }

    @Test
    void toString_includesValue() {
        SharedMapSignal signal = new SharedMapSignal(String.class);
        signal.put("key1", (Object)"value1");
        signal.put("key2", (Object)"value2");
        Assertions.assertEquals((Object)"SharedMapSignal[key1=value1, key2=value2]", (Object)signal.toString());
    }

    private void assertChildren(SharedMapSignal<String> signal, String ... expectedKeyValuePairs) {
        Assertions.assertEquals((int)0, (int)(expectedKeyValuePairs.length % 2));
        Map value = signal.peek();
        Assertions.assertEquals((int)(expectedKeyValuePairs.length / 2), (int)value.size());
        for (int i = 0; i < expectedKeyValuePairs.length; i += 2) {
            String key = expectedKeyValuePairs[i];
            String expextedValue = expectedKeyValuePairs[i + 1];
            Assertions.assertTrue((boolean)value.containsKey(key));
            Assertions.assertEquals((Object)expextedValue, (Object)((SharedValueSignal)value.get(key)).peek());
        }
    }
}

