/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.signals.local;

import com.vaadin.flow.signals.local.ListSignal;
import com.vaadin.flow.signals.local.ValueSignal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LocalSignalSerializationTest {
    private void assertSerializeAndDeserialize(Object obj) {
        try {
            this.serializeAndDeserialize(obj);
        }
        catch (Throwable e) {
            Assertions.fail((String)("Not Serializable: " + e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    public <T> T serializeAndDeserialize(T instance) throws Throwable {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bs);
        out.writeObject(instance);
        byte[] data = bs.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(data));
        Object readObject = in.readObject();
        return (T)readObject;
    }

    @Test
    public void valueSignal_serializable() {
        ValueSignal signal = new ValueSignal((Object)"");
        this.assertSerializeAndDeserialize(signal);
        signal.set((Object)"Test");
        this.assertSerializeAndDeserialize(signal);
    }

    @Test
    void listSignal_serializable() {
        ListSignal signal = new ListSignal();
        this.assertSerializeAndDeserialize(signal);
        signal.insertFirst((Object)"Test");
        this.assertSerializeAndDeserialize(signal);
    }
}

