/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared;

import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RegistrationTest {
    RegistrationTest() {
    }

    @Test
    public void once_onlyCalledOnce() {
        AtomicBoolean invoked = new AtomicBoolean();
        Command & Serializable action = (Command & Serializable)() -> {
            boolean calledPreviously = invoked.getAndSet(true);
            Assertions.assertFalse((boolean)calledPreviously, (String)"Command should not invoked previously");
        };
        Registration registration = Registration.once((Command)action);
        Assertions.assertFalse((boolean)invoked.get(), (String)"Command should not yet be invoked");
        registration.remove();
        Assertions.assertTrue((boolean)invoked.get(), (String)"Command should be invoked");
        registration.remove();
    }

    @Test
    public void combine_removesAll() {
        AtomicBoolean firstRemoved = new AtomicBoolean();
        AtomicBoolean secondRemoved = new AtomicBoolean();
        Registration registration = Registration.combine((Registration[])new Registration[]{(Registration & Serializable)() -> firstRemoved.set(true), (Registration & Serializable)() -> secondRemoved.set(true)});
        Assertions.assertFalse((boolean)firstRemoved.get(), (String)"Should not be removed yet");
        Assertions.assertFalse((boolean)secondRemoved.get(), (String)"Should not be removed yet");
        registration.remove();
        Assertions.assertTrue((boolean)firstRemoved.get(), (String)"Should be removed now");
        Assertions.assertTrue((boolean)secondRemoved.get(), (String)"Should be removed now");
    }

    @Test
    public void addAndRemove_addsAndRemoves() {
        ArrayList collection = new ArrayList();
        Object o1 = new Object();
        Object o2 = new Object();
        Registration r1 = Registration.addAndRemove(collection, (Object)o1);
        Assertions.assertEquals((int)1, (int)collection.size());
        Assertions.assertTrue((boolean)collection.contains(o1));
        Registration r2 = Registration.addAndRemove(collection, (Object)o2);
        Assertions.assertEquals((int)2, (int)collection.size());
        Assertions.assertTrue((boolean)collection.contains(o2));
        r1.remove();
        Assertions.assertEquals((int)1, (int)collection.size());
        Assertions.assertFalse((boolean)collection.contains(o1));
        r2.remove();
        Assertions.assertTrue((boolean)collection.isEmpty());
    }
}

